/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.task;

import com.huawei.yinglong.river.sitedeployment.dcs.task.CommonTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.task.DeployVmsTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeployVmsTaskManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployVmsTaskManager.class);
    private static final int FC_PARALLEL = 4;
    private final Map<String, PriorityQueue<DeployVmsTask>> taskQueueByCnaMap = new ConcurrentHashMap<String, PriorityQueue<DeployVmsTask>>();
    private final Map<String, Set<String>> tasksInRunning = new ConcurrentHashMap<String, Set<String>>();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("site-deployment-vms").uncaughtExceptionHandler((thread, exception) -> log.warn("thread {} exception {}.", (Object)thread.getName(), (Object)exception.getMessage())).daemon(true).build());
    private boolean isTasksInRunning = false;

    public static DeployVmsTaskManager getInstance() {
        return TaskManagerHolder.INSTANCE;
    }

    public void addAndStartTask(List<DeployVmsTask> deployVmsTasks) {
        deployVmsTasks.forEach(this::addTaskToQueue);
        if (!this.isTasksInRunning) {
            this.executorService.execute(this::executeTasks);
        }
    }

    private void executeTasks() {
        this.isTasksInRunning = true;
        while (this.isTasksInRunning) {
            this.tasksInRunning.values().forEach(ids -> ids.removeIf(this::isTaskFinished));
            this.tasksInRunning.keySet().forEach(this::addTaskToTaskExecuteThreadPool);
            ThreadUtils.threadSafeSleep(10, TimeUnit.SECONDS);
            this.refreshTaskRunningStatus();
        }
    }

    private void refreshTaskRunningStatus() {
        this.isTasksInRunning = this.taskQueueByCnaMap.values().stream().anyMatch(queue -> Objects.nonNull(queue.peek())) || this.tasksInRunning.values().stream().anyMatch(vmInRunning -> !vmInRunning.isEmpty());
    }

    private boolean isTaskFinished(String taskId) {
        return CommonTaskManager.getInstance().queryTaskDetailById(taskId).filter(deployTaskInfoVo -> TaskStatus.isFinishStatus(TaskStatus.valueOf(deployTaskInfoVo.getState()))).isPresent();
    }

    private void addTaskToTaskExecuteThreadPool(String key) {
        DeployVmsTask baseTask;
        while (this.tasksInRunning.get(key).size() < 4 && Objects.nonNull(baseTask = this.taskQueueByCnaMap.get(key).poll())) {
            CommonTaskManager.getInstance().startTaskById(baseTask.getTaskId());
            this.tasksInRunning.get(key).add(baseTask.getTaskId());
        }
    }

    private void addTaskToQueue(DeployVmsTask deployVmsTask) {
        if (!this.taskQueueByCnaMap.containsKey(deployVmsTask.getCnaName())) {
            this.taskQueueByCnaMap.put(deployVmsTask.getCnaName(), new PriorityQueue<DeployVmsTask>(Comparator.comparing(DeployVmsTask::getWeight).reversed()));
            this.tasksInRunning.put(deployVmsTask.getCnaName(), new HashSet());
        }
        this.taskQueueByCnaMap.get(deployVmsTask.getCnaName()).add(deployVmsTask);
        CommonTaskManager.getInstance().addTask(deployVmsTask);
    }

    @Generated
    private DeployVmsTaskManager() {
    }

    private static class TaskManagerHolder {
        static final DeployVmsTaskManager INSTANCE = new DeployVmsTaskManager();

        private TaskManagerHolder() {
        }
    }
}

