/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFilesUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigFilesUtils.class);
    private static final String CONFIG_WORK_SPACE = System.getProperty("user.dir");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<String> getConfigValueFromCustomFile(String configFilePath, String key) {
        String configNormalPath = FilePathValidatorUtils.joinChildPath(CONFIG_WORK_SPACE, configFilePath);
        if (StringUtils.isEmpty(configNormalPath)) {
            return Optional.empty();
        }
        Properties properties = new Properties();
        try (BufferedReader reader = new BufferedReader(new FileReader(configNormalPath));){
            properties.load(reader);
            Optional<String> optional = Optional.of(properties.getProperty(key, ""));
            return optional;
        }
        catch (IOException e) {
            log.error("parse config key {} failed", (Object)key);
            return Optional.empty();
        }
    }

    @Generated
    private ConfigFilesUtils() {
    }
}

