/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.utils;

import com.huawei.ism.tool.certbase.integrity.CheckFileIntegrityUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileContentOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CryptUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CryptUtils.class);
    private static final char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String DEFAULT_SIGNATURE_MODE = "SHA256WithRSA/PSS";
    private static final String KEY_ALGORITHM = "RSA";
    private static final String RSA_PUBLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAhFZjry7nNXtnCtp6sT2FbpN+RTuU+LnzSNawdKXA4zOu23hJ6mQyOsK0A9ZpoHbIBP1XUKyK4Oz4Mgi3NVlp65sMgs7EMU+J1aKDqcZU0texULMnahyq/4kdnaCdfNvJZiC1sbapgOxbNffH/C8yR/XEglDSq8TYOGKQ2IVUOfgOxhyFW0vqHyy2VIJvKE6rHijOmpjsyLHQGc0VLMZIezYrb+mGaa7a5TGX5E0hLoRaYaYQf+ZmD9Ed0aqyA+psGZlM7oLSZR5xDSLQpetpzHpTSFh5830JmkAfShpW4KceLsUeazgKiWd/i3ojEf141Xq+TlE5PVqjLc9qLFTYvQIDAQAB";
    private static final String HUAWEI_ROOT_CA = "-----BEGIN CERTIFICATE-----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\nUCrZxwwkrbPM3H6LA3VdrF1oWN0hjg==\n-----END CERTIFICATE-----";

    public static PublicKey getPublicKey(String key) {
        byte[] keyBytes = Base64.decodeBase64((String)key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        PublicKey publicKey = null;
        try {
            publicKey = KeyFactory.getInstance(KEY_ALGORITHM).generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            log.error("get PublicKey error.", (Throwable)e);
        }
        return publicKey;
    }

    public static boolean verifyConsistencyFileByCms(File pkgFile, File p7sFile) {
        return CheckFileIntegrityUtils.checkFileReleaseSignByCms((String)FilePathValidatorUtils.getSafePath(p7sFile).orElse(""), (String)FilePathValidatorUtils.getSafePath(pkgFile).orElse(""), (byte[])HUAWEI_ROOT_CA.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean verifyConsistencyFileBySha256(File pkgFile, File sha256File) {
        try (InputStream sha256data = Files.newInputStream(Paths.get(pkgFile.toURI()), new OpenOption[0]);){
            String sha256 = FileUtils.readFileToString((File)sha256File, (Charset)StandardCharsets.UTF_8).trim();
            boolean bl = Objects.equals(sha256, DigestUtils.sha256Hex((InputStream)sha256data));
            return bl;
        }
        catch (IOException e) {
            log.error("verify by sha256 read file failed");
            return false;
        }
    }

    public static boolean verifyConsistencyFileBySign(File pkgFile, File signFile) {
        if (!pkgFile.exists() || !signFile.exists()) {
            return false;
        }
        byte[] signData = FileContentOperateUtils.readBytesFromFile(signFile);
        if (signData == null || signData.length == 0) {
            return false;
        }
        byte[] sha256Bytes = CryptUtils.calculateSha256Code(pkgFile);
        if (sha256Bytes == null || sha256Bytes.length == 0) {
            return false;
        }
        return CryptUtils.verifySign(CryptUtils.toHexText(sha256Bytes), signData);
    }

    public static boolean verifySign(String pkgData, byte[] signData) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            Signature signature = Signature.getInstance(DEFAULT_SIGNATURE_MODE);
            signature.initVerify(CryptUtils.getPublicKey(RSA_PUBLIC_KEY));
            signature.update(pkgData.getBytes(StandardCharsets.UTF_8));
            return signature.verify(signData);
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] calculateSha256Code(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int size;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            boolean hasData = false;
            byte[] buffer = new byte[1024];
            while ((size = fileInputStream.read(buffer)) > 0) {
                messageDigest.update(buffer, 0, size);
                hasData = true;
            }
            if (!hasData) return new byte[0];
            byte[] byArray = messageDigest.digest();
            return byArray;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            log.error("get file hash 256 failed.", (Throwable)e);
        }
        return new byte[0];
    }

    public static String toHexText(byte[] buffer) {
        StringBuffer sBuffer = new StringBuffer(buffer.length * 2);
        IntStream.range(0, buffer.length).forEach(idx -> {
            sBuffer.append(HEX_CHAR[(buffer[idx] & 0xF0) >>> 4]);
            sBuffer.append(HEX_CHAR[buffer[idx] & 0xF]);
        });
        return sBuffer.toString();
    }

    @Generated
    private CryptUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

