/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.utils;

import com.huawei.ism.tool.sdk.unified.log.filter.LogFilterMark;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FcvWeakPasswordUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FcvWeakPasswordUtils.class);
    private static List<String> weakPwdDict;

    private static void initWeakPasswordDict() {
        InputStream resourceInput = FcvWeakPasswordUtils.class.getClassLoader().getResourceAsStream("fcv_weak_password_dict.txt");
        if (Objects.isNull(resourceInput)) {
            weakPwdDict = Collections.emptyList();
            log.warn("not fount weak password dict{}.", (Object)LogFilterMark.INSENSITIVE);
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceInput, StandardCharsets.UTF_8));){
            weakPwdDict = reader.lines().collect(Collectors.toList());
            if (weakPwdDict.isEmpty()) {
                log.error("load weak password empty{}.", (Object)LogFilterMark.INSENSITIVE);
            }
        }
        catch (IOException exception) {
            log.error("release weak verify stream failed{}.", (Object)LogFilterMark.INSENSITIVE, (Object)exception);
        }
    }

    public static boolean validWeakPassword(String password) {
        if (CollectionUtils.isEmpty(weakPwdDict)) {
            FcvWeakPasswordUtils.initWeakPasswordDict();
        }
        return weakPwdDict.stream().noneMatch(dickPwd -> FcvWeakPasswordUtils.compareWeakPassword(dickPwd, password.toLowerCase(Locale.ROOT)));
    }

    private static boolean compareWeakPassword(String dickPwd, String checkedPwd) {
        if (Objects.equals(dickPwd, checkedPwd)) {
            return true;
        }
        if (checkedPwd.startsWith(dickPwd) || checkedPwd.endsWith(dickPwd)) {
            return checkedPwd.length() - dickPwd.length() <= 2;
        }
        return false;
    }

    @Generated
    private FcvWeakPasswordUtils() {
    }
}

