/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.constant.LineSeparator;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileContentOperateUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileContentOperateUtils.class);
    private static final long DEFAULT_SIZE_LIMIT = 0x4000000L;

    public static boolean replaceTextFileContent(String originTextFile, String targetTextFile, Map<String, String> replaceMap, LineSeparator separator) {
        String originPath = FilePathValidatorUtils.getSafePath(originTextFile).orElse("");
        String targetPath = FilePathValidatorUtils.getSafePath(targetTextFile).orElse("");
        if (!FilePathValidatorUtils.isValidExistPaths(originPath) || !FilePathValidatorUtils.isValidPaths(targetPath)) {
            log.error("text file or target file is invalid");
            return false;
        }
        if (FileUtils.sizeOf((File)new File(originPath)) > 0x4000000L) {
            log.error("file size is more than default size");
            return false;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(originPath));
             FileWriter writer = new FileWriter(targetPath);){
            CharArrayWriter arrayWriter = new CharArrayWriter();
            reader.lines().map(line -> FileContentOperateUtils.replaceLine(replaceMap, line)).forEach(line -> FileContentOperateUtils.writeLine(arrayWriter, line, separator));
            arrayWriter.writeTo(writer);
        }
        catch (IOException exception) {
            log.error("read or write file error", (Throwable)exception);
            return false;
        }
        return true;
    }

    public static boolean replaceTextFileContentByUtf(String originTextFile, String targetTextFile, Map<String, String> replaceMap, LineSeparator separator) throws IOException {
        String originPath = FilePathValidatorUtils.getSafePath(originTextFile).orElse("");
        String targetPath = FilePathValidatorUtils.getSafePath(targetTextFile).orElse("");
        if (!FilePathValidatorUtils.isValidExistPaths(originPath) || !FilePathValidatorUtils.isValidPaths(targetPath)) {
            log.error("text file or target file is invalid");
            return false;
        }
        if (FileUtils.sizeOf((File)new File(originPath)) > 0x4000000L) {
            log.error("file size is more than default size");
            return false;
        }
        File originFile = new File(originPath);
        File targetFile = new File(targetPath);
        if (!targetFile.createNewFile()) {
            log.error("create new file failed");
            return false;
        }
        return FileContentOperateUtils.writeReplaceFile(replaceMap, separator, originFile, targetFile);
    }

    private static boolean writeReplaceFile(Map<String, String> replaceMap, LineSeparator separator, File originFile, File targetFile) {
        try (FileInputStream inputStream = new FileInputStream(originFile);
             InputStreamReader isr = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
             BufferedReader bf = new BufferedReader(isr);
             FileWriterWithEncoding fw = new FileWriterWithEncoding(targetFile, StandardCharsets.UTF_8);
             BufferedWriter bw = new BufferedWriter((Writer)fw);){
            String readLine;
            while ((readLine = bf.readLine()) != null) {
                String replaceLine = FileContentOperateUtils.replaceLine(replaceMap, readLine);
                FileContentOperateUtils.writeLineByUtf(bw, replaceLine, separator);
            }
        }
        catch (IOException e) {
            log.error("read or write file error", (Throwable)e);
            return false;
        }
        return true;
    }

    private static String replaceLine(Map<String, String> replaceMap, String line) {
        String currentLine = line;
        List matchKeys = replaceMap.keySet().stream().filter(line::contains).collect(Collectors.toList());
        for (String key : matchKeys) {
            currentLine = currentLine.replace(key, replaceMap.get(key));
        }
        return currentLine;
    }

    private static void writeLine(CharArrayWriter arrayWriter, String line, LineSeparator separator) {
        try {
            arrayWriter.write(line);
            arrayWriter.append(separator.getSeparator());
        }
        catch (IOException exception) {
            log.error("write one line error", (Throwable)exception);
        }
    }

    private static void writeLineByUtf(BufferedWriter writer, String line, LineSeparator separator) {
        try {
            writer.write(line);
            writer.append(separator.getSeparator());
        }
        catch (IOException exception) {
            log.error("write one line error", (Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readBytesFromFile(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byte[] buffer = new byte[fileInputStream.available()];
            int size = fileInputStream.read(buffer);
            log.info("read byte from file size = {}.", (Object)size);
            byte[] byArray = buffer;
            return byArray;
        }
        catch (IOException e) {
            log.error("read file to bytes field.", (Throwable)e);
            return new byte[0];
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<String> readFileContentInZipFile(String zipFile, String fileName) {
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                String entryName = entry.getName();
                if (entryName.endsWith(fileName)) {
                    Optional<String> optional = FileContentOperateUtils.readFileContentInZipFile(zipInputStream);
                    return optional;
                }
                entry = zipInputStream.getNextEntry();
            }
            return Optional.empty();
        }
        catch (FileNotFoundException e) {
            log.error("read zip file not find, {}.", (Object)fileName);
            return Optional.empty();
        }
        catch (IOException e) {
            log.error("read zip file error", (Throwable)e);
        }
        return Optional.empty();
    }

    @NotNull
    private static Optional<String> readFileContentInZipFile(ZipInputStream zipInputStream) throws IOException {
        int bytesRead;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = zipInputStream.read(buffer)) != -1) {
            byteArrayOutputStream.write(buffer, 0, bytesRead);
        }
        zipInputStream.closeEntry();
        return Optional.of(byteArrayOutputStream.toString());
    }

    @Generated
    private FileContentOperateUtils() {
    }
}

