/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.FileOperateErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.FileOperateException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOperateUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileOperateUtils.class);

    public static boolean createDirectory(String dirPath) {
        String canonicalPath = FilePathValidatorUtils.getSafePath(dirPath).orElse("");
        if (StringUtils.isEmpty((CharSequence)canonicalPath)) {
            log.warn("current create directory path is empty");
            return false;
        }
        File dirPathFile = new File(canonicalPath);
        if (dirPathFile.exists()) {
            log.warn("current create directory exists");
            return dirPathFile.isDirectory();
        }
        return dirPathFile.mkdir();
    }

    public static boolean deleteDirectory(String dirPath) {
        String canonicalPath = FilePathValidatorUtils.getSafePath(dirPath).orElse("");
        if (StringUtils.isEmpty((CharSequence)canonicalPath)) {
            log.warn("current delete directory path is empty");
            return false;
        }
        File dirPathFile = new File(canonicalPath);
        if (!dirPathFile.exists()) {
            return true;
        }
        return FileUtils.deleteQuietly((File)dirPathFile);
    }

    public static List<String> getSpecialFileNames(File dirFile, Predicate<String> predicate) {
        return Arrays.stream((Object[])Optional.ofNullable(dirFile.listFiles()).orElse(new File[0])).map(File::getName).filter(predicate).collect(Collectors.toList());
    }

    public static Optional<String> createTemplateCacheFile(String taskId) {
        return FilePathValidatorUtils.getSafePath(System.getProperty("user.dir")).map(path -> FilePathValidatorUtils.joinChildPath(path, "template_cache", taskId));
    }

    public static void writeDataToFile(String path, String data) {
        Path filePath = Paths.get(path, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            try {
                FileUtils.createParentDirectories((File)filePath.toFile());
                Files.createFile(filePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new FileOperateException(FileOperateErrorCode.FILE_WRITE_ERROR);
            }
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(path);
             FileChannel channel = fileOutputStream.getChannel();
             FileLock lock = channel.tryLock();){
            if (lock == null) {
                throw new FileOperateException(FileOperateErrorCode.FILE_UTILIZATION_ERROR);
            }
            fileOutputStream.write(data.getBytes(StandardCharsets.UTF_8));
            fileOutputStream.flush();
        }
        catch (IOException e) {
            log.error("write file error", (Throwable)e);
            throw new FileOperateException(FileOperateErrorCode.FILE_WRITE_ERROR);
        }
    }

    @Generated
    private FileOperateUtils() {
    }
}

