/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.utils;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePathValidatorUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FilePathValidatorUtils.class);
    private static final String LINUX_SEPARATOR = "/";

    public static String createLinuxPaths(String currentPath, String ... childPaths) {
        if (childPaths == null || childPaths.length == 0) {
            return currentPath;
        }
        return currentPath + LINUX_SEPARATOR + String.join((CharSequence)LINUX_SEPARATOR, childPaths);
    }

    public static Optional<String> getSafePath(File file) {
        try {
            return Optional.of(file.getCanonicalPath());
        }
        catch (IOException exception) {
            log.error("get safe file path error", (Throwable)exception);
            return Optional.empty();
        }
    }

    public static Optional<String> getSafePath(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return Optional.empty();
        }
        return FilePathValidatorUtils.getSafePath(new File(path));
    }

    public static boolean isValidExistPaths(String ... paths) {
        return Arrays.stream(paths).map(FilePathValidatorUtils::getSafePath).allMatch(path -> path.filter(FilePathValidatorUtils::isValid).isPresent());
    }

    public static boolean isValidPaths(String ... paths) {
        return Arrays.stream(paths).map(FilePathValidatorUtils::getSafePath).allMatch(path -> path.filter(StringUtils::isNotEmpty).isPresent());
    }

    public static String joinChildPath(String ... paths) {
        return FilePathValidatorUtils.getSafePath(String.join((CharSequence)File.separator, paths)).orElse("");
    }

    public static String getSuffix(String fileName) {
        if (!fileName.contains(".")) {
            return "";
        }
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    private static boolean isValid(String path) {
        return StringUtils.isNotEmpty((CharSequence)path) && new File(path).exists();
    }

    @Generated
    private FilePathValidatorUtils() {
    }
}

