/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.utils;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);
    private static final String REGEXP_IP_V4 = "^((25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))\\.){3}(25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))$";
    private static final Pattern PATTERN_IP_V4 = Pattern.compile("^((25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))\\.){3}(25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))$");
    private static final String REGEX_MAC_ADDRESS = "^[A-Fa-f\\d]{2}([-:]?[A-Fa-f\\d]{2})([-:.]?[A-Fa-f\\d]{2})([-:]?[A-Fa-f\\d]{2})([-:.]?[A-Fa-f\\d]{2})([-:]?[A-Fa-f\\d]{2})$";
    private static final Pattern PATTERN_MAC_ADDRESS = Pattern.compile("^[A-Fa-f\\d]{2}([-:]?[A-Fa-f\\d]{2})([-:.]?[A-Fa-f\\d]{2})([-:]?[A-Fa-f\\d]{2})([-:.]?[A-Fa-f\\d]{2})([-:]?[A-Fa-f\\d]{2})$");
    private static final String REGEX_IP_V6 = "^\\s*((([0-9A-Fa-f]{1,4}:){7}(([0-9A-Fa-f]{1,4})|:))|(([0-9A-Fa-f]{1,4}:){6}(:|((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})|(:[0-9A-Fa-f]{1,4})))|(([0-9A-Fa-f]{1,4}:){5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){4}(:[0-9A-Fa-f]{1,4}){0,1}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){3}(:[0-9A-Fa-f]{1,4}){0,2}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){2}(:[0-9A-Fa-f]{1,4}){0,3}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:)(:[0-9A-Fa-f]{1,4}){0,4}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(:(:[0-9A-Fa-f]{1,4}){0,5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})))(%.+)?\\s*$";
    private static final Pattern PATTERN_IP_V6 = Pattern.compile("^\\s*((([0-9A-Fa-f]{1,4}:){7}(([0-9A-Fa-f]{1,4})|:))|(([0-9A-Fa-f]{1,4}:){6}(:|((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})|(:[0-9A-Fa-f]{1,4})))|(([0-9A-Fa-f]{1,4}:){5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){4}(:[0-9A-Fa-f]{1,4}){0,1}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){3}(:[0-9A-Fa-f]{1,4}){0,2}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){2}(:[0-9A-Fa-f]{1,4}){0,3}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:)(:[0-9A-Fa-f]{1,4}){0,4}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(:(:[0-9A-Fa-f]{1,4}){0,5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})))(%.+)?\\s*$");
    private static final int PING_DEFAULT_TIMEOUT_MS = 1000;

    public static boolean isValidIpV6(String ipV6) {
        if (StringUtils.isEmpty((CharSequence)ipV6)) {
            return false;
        }
        if (PATTERN_IP_V6.matcher(ipV6).matches()) {
            try {
                InetAddress inetAddress = Inet6Address.getByName(ipV6);
                if (inetAddress instanceof Inet6Address) {
                    Inet6Address address = (Inet6Address)inetAddress;
                    return !address.isMulticastAddress() && !address.isLoopbackAddress() && !address.isAnyLocalAddress();
                }
            }
            catch (UnknownHostException e) {
                log.error("check ip v6 is failed.", (Throwable)e);
            }
        }
        return false;
    }

    public static boolean isValidIpV4(String ipV4) {
        if (StringUtils.isEmpty((CharSequence)ipV4)) {
            return false;
        }
        if (PATTERN_IP_V4.matcher(ipV4).matches()) {
            try {
                InetAddress address = InetAddress.getByName(ipV4);
                return address != null && !address.isMulticastAddress() && !address.isLoopbackAddress() && !address.isAnyLocalAddress();
            }
            catch (UnknownHostException e) {
                log.error("check ip v4 is failed.", (Throwable)e);
            }
        }
        return false;
    }

    public static boolean isValidNetmask(String netmask) {
        if (StringUtils.isEmpty((CharSequence)netmask)) {
            return false;
        }
        if (PATTERN_IP_V4.matcher(netmask).matches()) {
            String binaryNetmask = IpUtils.netmaskToBinaryNetmask(netmask);
            int zeroIdx = binaryNetmask.indexOf("0");
            if (zeroIdx < 0) {
                return true;
            }
            int oneIdx = binaryNetmask.lastIndexOf(49);
            if (oneIdx < 0) {
                return false;
            }
            return zeroIdx > oneIdx;
        }
        return false;
    }

    public static int getNetmaskPrefix(String netmask) {
        if (!PATTERN_IP_V4.matcher(netmask).matches()) {
            log.error("parse netmask prefix invalid, netmask = {}.", (Object)netmask);
            throw new IllegalArgumentException("netmask invalid.");
        }
        return IpUtils.netmaskToBinaryNetmask(netmask).lastIndexOf(49) + 1;
    }

    private static String netmaskToBinaryNetmask(String netmask) {
        return Stream.of(netmask.split("\\.")).map(Integer::parseInt).map(Integer::toBinaryString).map(IpUtils::transferToFullBinary).reduce(String::concat).orElse("");
    }

    private static String transferToFullBinary(String binary) {
        StringBuilder sBuilder = new StringBuilder("00000000");
        sBuilder.append(binary);
        return sBuilder.substring(sBuilder.length() - 8);
    }

    public static boolean isValidMacAddress(String mac) {
        if (StringUtils.isEmpty((CharSequence)mac)) {
            return false;
        }
        return PATTERN_MAC_ADDRESS.matcher(mac).matches();
    }

    private static byte[] textToNumericFormatV4(String ip) {
        try {
            if (StringUtils.isEmpty((CharSequence)ip)) {
                return new byte[0];
            }
            return InetAddress.getByName(ip).getAddress();
        }
        catch (IOException e) {
            log.error("ip text to number failed.", (Throwable)e);
            return new byte[0];
        }
    }

    private static boolean isByteArrayEmpty(byte[] value) {
        return Objects.isNull(value) || value.length == 0;
    }

    public static boolean checkNetworkRangeValid(String ip, String mask, String gateway) {
        byte[] ipValue = IpUtils.textToNumericFormatV4(ip);
        byte[] maskValue = IpUtils.textToNumericFormatV4(mask);
        byte[] gatewayValue = IpUtils.textToNumericFormatV4(gateway);
        if (IpUtils.isByteArrayEmpty(ipValue) || IpUtils.isByteArrayEmpty(maskValue) || IpUtils.isByteArrayEmpty(gatewayValue)) {
            return false;
        }
        for (int i = 0; i < ipValue.length && i < maskValue.length && i < gatewayValue.length; ++i) {
            if ((ipValue[i] & maskValue[i]) == (gatewayValue[i] & maskValue[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isReachable(String ip) {
        return IpUtils.isReachable(ip, 1000);
    }

    public static boolean isReachable(String ip, int timeoutMs) {
        try {
            if (StringUtils.isEmpty((CharSequence)ip)) {
                return false;
            }
            return InetAddress.getByName(ip).isReachable(timeoutMs);
        }
        catch (IOException e) {
            log.error("check ip {} reachable failed.", (Object)ip);
            return false;
        }
    }

    public static String calcSubnetAddress(String ip, String mask) {
        StringBuilder result = new StringBuilder();
        try {
            int i;
            InetAddress ipAddress = InetAddress.getByName(ip);
            InetAddress maskAddress = InetAddress.getByName(mask);
            byte[] ipRaw = ipAddress.getAddress();
            byte[] maskRaw = maskAddress.getAddress();
            int[] resultRaw = new int[ipRaw.length];
            for (i = 0; i < resultRaw.length; ++i) {
                resultRaw[i] = ipRaw[i] & maskRaw[i] & 0xFF;
            }
            result.append(resultRaw[0]);
            for (i = 1; i < resultRaw.length; ++i) {
                result.append(".").append(resultRaw[i]);
            }
        }
        catch (UnknownHostException e) {
            log.error("Uncorrect ip or mask.", (Throwable)e);
        }
        return result.toString();
    }

    public static boolean checkSegment(String segment) {
        if (StringUtils.isEmpty((CharSequence)segment)) {
            return false;
        }
        String[] split = segment.split("/");
        if (split.length != 2) {
            return false;
        }
        if (!IpUtils.isValidIpV4(split[0])) {
            return false;
        }
        if (!StringUtils.isNumeric((CharSequence)split[1])) {
            return false;
        }
        int num = Integer.parseInt(split[1]);
        return num >= 0 && num <= 32;
    }

    @Generated
    private IpUtils() {
    }
}

