/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.utils;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NumberUtils.class);

    public static long parseLong(String text, long defaultValue) {
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException e) {
            log.error("parse {} to long error", (Object)text, (Object)e);
            return defaultValue;
        }
    }

    public static int parseInt(String text, int defaultValue) {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            log.error("parse {} to int error", (Object)text, (Object)e);
            return defaultValue;
        }
    }

    public static String parseDurationTime(int durationTime) {
        int minDuration = durationTime & 0xFFFF;
        int maxDuration = (durationTime & 0xFFFF0000) >>> 16;
        if (maxDuration == 0) {
            return String.valueOf(minDuration);
        }
        return minDuration + "-" + maxDuration;
    }

    public static int parseDurationTime(String durationTime) {
        String[] durationTimes = durationTime.split("-");
        if (durationTimes.length <= 1) {
            return NumberUtils.parseInt(durationTimes[0], 0);
        }
        int minDuration = NumberUtils.parseInt(durationTimes[0], 0);
        int maxDuration = NumberUtils.parseInt(durationTimes[1], 0);
        return maxDuration << 16 | minDuration;
    }

    @Generated
    private NumberUtils() {
    }
}

