/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.StreamUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsCmdUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OsCmdUtils.class);
    private static final int DEFAULT_CMD_TIMEOUT_SECOND = 300;

    public static String executeCmd(String cmd) {
        return OsCmdUtils.executeCmd(cmd, null, null, 300);
    }

    public static String executeCmd(String cmd, String character) {
        return OsCmdUtils.executeCmd(cmd, null, null, 300, Charset.forName(character));
    }

    public static String executeCmd(String cmd, String[] envs, File dir, int timeoutSecond) {
        return OsCmdUtils.executeCmd(cmd, envs, dir, timeoutSecond, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeCmd(String cmd, String[] envs, File dir, int timeoutSecond, Charset charset) {
        InputStream inputStream = null;
        InputStream errorStream = null;
        String result = "";
        String error = "";
        try {
            Process process = OsCmdUtils.createCmdProcess(cmd, envs, dir);
            inputStream = process.getInputStream();
            errorStream = process.getErrorStream();
            ProcessStreamSupplier streamSupplier = new ProcessStreamSupplier(inputStream, charset);
            ProcessStreamSupplier errorSupplier = new ProcessStreamSupplier(errorStream, charset);
            Future<String> normalInputStream = ThreadUtils.submit(streamSupplier::get);
            Future<String> errorInputStream = ThreadUtils.submit(errorSupplier::get);
            boolean isExecuteSuccess = process.waitFor(timeoutSecond, TimeUnit.SECONDS);
            log.info("cmd execute result {}", (Object)isExecuteSuccess);
            result = normalInputStream.get(timeoutSecond, TimeUnit.SECONDS);
            error = errorInputStream.get(timeoutSecond, TimeUnit.SECONDS);
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException exception) {
            try {
                log.error("execute cmd error", (Throwable)exception);
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(inputStream);
                StreamUtils.closeStream(errorStream);
                throw throwable;
            }
            StreamUtils.closeStream(inputStream);
            StreamUtils.closeStream(errorStream);
        }
        StreamUtils.closeStream(inputStream);
        StreamUtils.closeStream(errorStream);
        if (StringUtils.isNotEmpty((CharSequence)error)) {
            log.error(error);
        }
        return result;
    }

    private static Process createCmdProcess(String cmd, String[] envs, File dir) throws IOException {
        return Runtime.getRuntime().exec(cmd, envs, dir);
    }

    @Generated
    private OsCmdUtils() {
    }

    private static class ProcessStreamSupplier
    implements Supplier<String> {
        private final InputStream inputStream;
        private final Charset charset;

        public ProcessStreamSupplier(InputStream inputStream, Charset charset) {
            this.inputStream = inputStream;
            this.charset = Objects.isNull(charset) ? StandardCharsets.UTF_8 : charset;
        }

        @Override
        public String get() {
            StringBuilder result = new StringBuilder();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream, this.charset));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    result.append(line).append(System.lineSeparator());
                }
            }
            catch (IOException exception) {
                log.error("readline error.", (Throwable)exception);
            }
            return result.toString();
        }
    }
}

