/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.utils;

import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.rest.entity.Result;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorDetail;
import java.util.Optional;
import lombok.Generated;

public final class ResponseUtils {
    private static final int SUCCESS = 0;
    private static final int FAILED_CODE = 1;

    public static <T> Response<T> failed(String description, String suggestion) {
        return Response.builder().result(ResponseUtils.failedResult(description, suggestion)).build();
    }

    public static <T> Response<T> failed(ErrorDetail errorDetail) {
        return Response.builder().result(ResponseUtils.failedResult(errorDetail.getErrorMessage(), errorDetail.getSuggestMessage())).build();
    }

    public static <T> Response<T> failed(T data) {
        return Response.builder().result(ResponseUtils.failedResult()).data(data).build();
    }

    public static <T> Response<T> success(T data) {
        return Response.builder().result(ResponseUtils.successResult()).data(data).build();
    }

    public static <T> Response<T> success() {
        return Response.builder().result(ResponseUtils.successResult()).build();
    }

    public static <T> boolean isSuccessfully(Response<T> response) {
        return Optional.ofNullable(response).map(Response::getResult).map(Result::getCode).filter(code -> code == 0).isPresent();
    }

    public static Result failedResult(String description, String suggestion) {
        return Result.builder().code(Integer.valueOf(1)).description(description).suggestion(suggestion).build();
    }

    private static Result failedResult() {
        return ResponseUtils.failedResult("", "");
    }

    public static Result successResult() {
        return Result.builder().code(Integer.valueOf(0)).build();
    }

    @Generated
    private ResponseUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

