/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreadUtils.class);
    private static final ThreadPoolExecutor THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(50, 50, 10L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(), (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("site-deployment-dcs-%d").uncaughtExceptionHandler((thread, exception) -> log.error("thread {} exception {}.", new Object[]{thread.getName(), exception.getMessage(), exception})).daemon(true).build(), new ThreadPoolExecutor.AbortPolicy());
    private static final ScheduledThreadPoolExecutor SCHEDULED_EXECUTOR = new ScheduledThreadPoolExecutor(10, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("site-deployment-dcs-schedule").uncaughtExceptionHandler((thread, exception) -> log.warn("thread {} exception {}.", (Object)thread.getName(), (Object)exception.getMessage())).daemon(true).build(), new ThreadPoolExecutor.AbortPolicy());

    public static void threadSafeSleep(int sleepTime, TimeUnit timeUnit) {
        long millis = timeUnit.toMillis(sleepTime);
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException exception) {
            log.error("thread {} sleep error", (Object)Thread.currentThread().getName(), (Object)exception);
        }
    }

    public static <T> Future<T> submit(Callable<T> task) {
        return THREAD_POOL_EXECUTOR.submit(task);
    }

    public static <T> Future<T> submit(Runnable task, T result) {
        return THREAD_POOL_EXECUTOR.submit(task, result);
    }

    public static Future<?> submit(Runnable task) {
        return THREAD_POOL_EXECUTOR.submit(task);
    }

    public static void execute(Runnable command) {
        THREAD_POOL_EXECUTOR.execute(command);
    }

    public static ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return SCHEDULED_EXECUTOR.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Generated
    private ThreadUtils() {
    }
}

