/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class UrlUtils {
    private static final Pattern HOST_PATTERN = Pattern.compile("https?://(.*?)(:\\d+)?/");

    public static String getHostName(@NotNull String url) {
        Matcher matcher = HOST_PATTERN.matcher(url);
        return matcher.find() ? matcher.group(1) : "";
    }

    public static String getHttpBaseUrlByIp(@NotNull String ip) {
        if (IpUtils.isValidIpV6(ip)) {
            return String.format(Locale.ROOT, "https://[%s]", ip);
        }
        if (IpUtils.isValidIpV4(ip)) {
            return String.format(Locale.ROOT, "https://%s", ip);
        }
        return "";
    }

    @Generated
    private UrlUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

