/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WeakPasswordValidUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WeakPasswordValidUtils.class);
    private static List<String> weakPassword = new ArrayList<String>();

    private static void initWeakPasswordBlacklist() {
        InputStream resourceInput = WeakPasswordValidUtils.class.getClassLoader().getResourceAsStream("weak_password_list.txt");
        if (Objects.isNull(resourceInput)) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceInput, StandardCharsets.UTF_8));){
            weakPassword = reader.lines().collect(Collectors.toList());
            if (weakPassword.isEmpty()) {
                log.error("load weak password failed");
            }
        }
        catch (IOException exception) {
            log.error("release weak verify stream failed.", (Throwable)exception);
        }
    }

    public static boolean validWeakPassword(String password) {
        if (WeakPasswordValidUtils.weakPassword.isEmpty()) {
            WeakPasswordValidUtils.initWeakPasswordBlacklist();
        }
        String encPwd = DigestUtils.md5Hex((String)password.toLowerCase(Locale.ROOT));
        return WeakPasswordValidUtils.weakPassword.stream().noneMatch(weakPassword -> weakPassword.equals(encPwd));
    }

    @Generated
    private WeakPasswordValidUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

