/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.OsCmdUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.io.File;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZipUtils.class);

    public static boolean decompressFileBy7Zip(String toolPath, String zipSourcePath, String targetPath) {
        if (!FilePathValidatorUtils.isValidExistPaths(toolPath, zipSourcePath)) {
            log.error("current 7z tool path or zip source path is empty");
            return false;
        }
        if (!FilePathValidatorUtils.isValidPaths(targetPath)) {
            log.error("current target directory is empty");
            return false;
        }
        String cmd = "\"" + toolPath + "\" x \"" + zipSourcePath + "\" -o\"" + targetPath + "\" -y";
        String result = OsCmdUtils.executeCmd(cmd, "gbk");
        log.info("decompress file result {}", (Object)result);
        return !result.contains("Errors") && !StringUtils.isEmpty((CharSequence)result);
    }

    public static boolean compressFileBy7Zip(String toolPath, String sourcePath, String targetFile) {
        if (!FilePathValidatorUtils.isValidExistPaths(toolPath, sourcePath)) {
            log.error("current 7z tool path or zip source path is empty");
            return false;
        }
        if (FilePathValidatorUtils.isValidExistPaths(targetFile)) {
            log.error("current target file is exist");
            return false;
        }
        String cmd = "\"" + toolPath + "\" a \"" + targetFile + "\" \"" + sourcePath + "\"";
        String result = OsCmdUtils.executeCmd(cmd, "gbk");
        log.info("compress file result {}", (Object)result);
        return !result.contains("Errors") && !StringUtils.isEmpty((CharSequence)result);
    }

    public static boolean checkDecompressFileExist(String unzipFilePath, long limitTime, TimeUnit timeUnit) {
        long startCheckTime = System.currentTimeMillis();
        File unzipFile = new File(unzipFilePath);
        log.info("start check decompress file:{},limit time:{} {}", new Object[]{unzipFile.getName(), limitTime, timeUnit.name()});
        while (!unzipFile.exists() || unzipFile.length() <= 0L) {
            long currentTime = System.currentTimeMillis();
            if (TimeUnit.MILLISECONDS.toSeconds(currentTime - startCheckTime) > timeUnit.toSeconds(limitTime)) {
                log.error("current file {} not exists", (Object)unzipFile.getName());
                return false;
            }
            ThreadUtils.threadSafeSleep(2, TimeUnit.SECONDS);
        }
        return true;
    }

    @Generated
    private ZipUtils() {
    }
}

