/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.utils.exception;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.resource.ResourceBundleUtils;
import java.text.MessageFormat;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public final class ExceptionResourceUtils {
    private static final String RESOURCE_BUNDLE_ERROR_NAME = "error_code";
    private static final String ERROR_MESSAGE_KEY = ".error";
    private static final String SUGGEST_MESSAGE_KEY = ".suggest";

    public static String getResourceBundleErrorName() {
        return RESOURCE_BUNDLE_ERROR_NAME;
    }

    public static String getErrorMessage(String key) {
        return ExceptionResourceUtils.getErrorMessage(key, null);
    }

    public static String getErrorMessage(String key, List<Object> errorParams) {
        return ExceptionResourceUtils.getErrorMessage(RESOURCE_BUNDLE_ERROR_NAME, key, errorParams);
    }

    public static String getSuggestMessage(String key, List<Object> suggestParams) {
        return ExceptionResourceUtils.getSuggestMessage(RESOURCE_BUNDLE_ERROR_NAME, key, suggestParams);
    }

    public static String getErrorMessage(String resourceBundle, String key, List<Object> errorParams) {
        String resourceString = ResourceBundleUtils.getStringFromResource(resourceBundle, key + ERROR_MESSAGE_KEY);
        return ExceptionResourceUtils.getFormatString(resourceString, errorParams);
    }

    public static String getSuggestMessage(String resourceBundle, String key, List<Object> suggestParams) {
        String resourceString = ResourceBundleUtils.getStringFromResource(resourceBundle, key + SUGGEST_MESSAGE_KEY);
        return ExceptionResourceUtils.getFormatString(resourceString, suggestParams);
    }

    private static String getFormatString(String resourceString, List<Object> param) {
        return CollectionUtils.isEmpty(param) ? resourceString : MessageFormat.format(resourceString, param.toArray(new Object[0]));
    }

    @Generated
    private ExceptionResourceUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

