/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.utils.iamge;

import com.huawei.yinglong.river.sitedeployment.dcs.constant.LineSeparator;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileContentOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.OsCmdUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ZipUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.iamge.ImageConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.iamge.ImageUpdate;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.iamge.IsoEulerVersion;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImageUtils.class);

    public static synchronized Optional<String> updateImage(ImageUpdate update) {
        String cacheDir = FilePathValidatorUtils.joinChildPath(ImageConstant.ISO_CACHE_DIR, update.getIp() + "_" + StringUtils.formatTimeText("yyyyMMddHHmmssSS"));
        if (!ImageUtils.depressIso(update.getPath(), cacheDir)) {
            log.error("depress iso file error.");
            return Optional.empty();
        }
        if (!ImageUtils.removeBootDir(cacheDir)) {
            log.error("remove boot dir failed.");
            return Optional.empty();
        }
        if (!ImageUtils.replaceGrubContent(cacheDir)) {
            log.error("replace grub content failed.");
            return Optional.empty();
        }
        if (!ImageUtils.replaceKsContent(update, cacheDir)) {
            log.error("replace custom ks content failed.");
            return Optional.empty();
        }
        if (!ImageUtils.replaceIsoLinuxConf(update, cacheDir)) {
            log.error("replace iso linux conf failed.");
            return Optional.empty();
        }
        ImageUtils.packageIsoImage(update, cacheDir);
        return Optional.of(FilePathValidatorUtils.joinChildPath(cacheDir, update.getRepackageIsoName()));
    }

    private static boolean replaceIsoLinuxConf(ImageUpdate update, String cacheDir) {
        if (!update.getPath().toLowerCase().contains("x86")) {
            return true;
        }
        String version = IsoEulerVersion.parse(update.getRepackageIsoName()).getVersion();
        String templatePath = FilePathValidatorUtils.joinChildPath(ImageConstant.TEMPLATE_DIR, version, "x86", "isolinux.cfg");
        log.info("replace iso linux conf, template path : {}.", (Object)templatePath);
        String oriCfgPath = FilePathValidatorUtils.joinChildPath(cacheDir, "isolinux", "isolinux.cfg");
        File oriCfgFile = new File(oriCfgPath);
        if (!oriCfgFile.delete()) {
            log.error("replace iso linux conf but delete org file failed.");
            return false;
        }
        try {
            Files.copy(Paths.get(templatePath, new String[0]), Paths.get(oriCfgPath, new String[0]), new CopyOption[0]);
        }
        catch (IOException exception) {
            log.error("replace iso linux cfg error");
            return false;
        }
        return true;
    }

    private static boolean replaceGrubContent(String cacheDir) {
        String replacedGrubPath = FilePathValidatorUtils.joinChildPath(cacheDir, "EFI", "BOOT", "grub.cfg");
        File replacedGrubFile = new File(replacedGrubPath);
        String backupGrubPath = FilePathValidatorUtils.joinChildPath(cacheDir, "EFI", "BOOT", "bak_grub.cfg");
        File grubFile = new File(backupGrubPath);
        if (!replacedGrubFile.renameTo(grubFile)) {
            log.error("rename grub file failed.");
            return false;
        }
        HashMap<String, String> grubContent = new HashMap<String, String>();
        grubContent.put("set default=\"2\"", "set default=\"0\"");
        if (!FileContentOperateUtils.replaceTextFileContent(backupGrubPath, replacedGrubPath, grubContent, LineSeparator.LINUX)) {
            log.error("replace grub file content failed.");
            return false;
        }
        return grubFile.delete();
    }

    private static boolean removeBootDir(String cacheDir) {
        String bootDir = FilePathValidatorUtils.joinChildPath(cacheDir, "[BOOT]");
        return FileOperateUtils.deleteDirectory(bootDir);
    }

    private static boolean depressIso(String isoPath, String cacheDir) {
        return ZipUtils.decompressFileBy7Zip(ImageConstant.ZIP_TOOL_PATH, isoPath, cacheDir);
    }

    private static void packageIsoImage(ImageUpdate update, String cacheDir) {
        String version = IsoEulerVersion.parse(update.getRepackageIsoName()).getVersion();
        String packageCmd = update.getPath().toLowerCase().contains("x86") ? String.format(ImageConstant.X86_PACKAGE_CMD, version, update.getRepackageIsoName()) : String.format(ImageConstant.ARM_PACKAGE_CMD, version, update.getRepackageIsoName());
        log.info("package iso, name:{}, command:{}.", (Object)update.getRepackageIsoName(), (Object)packageCmd);
        OsCmdUtils.executeCmd(packageCmd, null, new File(cacheDir), 30);
    }

    private static boolean replaceKsContent(ImageUpdate update, String cacheDir) {
        String version = IsoEulerVersion.parse(update.getRepackageIsoName()).getVersion();
        String ksPath = FilePathValidatorUtils.joinChildPath(cacheDir, "_custom.ks");
        String template = FilePathValidatorUtils.joinChildPath(ImageConstant.TEMPLATE_DIR, version, update.getPath().toLowerCase().contains("x86") ? "x86" : "arm", "_custom.ks");
        log.info("replace ks, template is {}.", (Object)template);
        File ksFile = new File(ksPath);
        if (!ksFile.delete()) {
            log.error("delete custom ks file failed.");
            return false;
        }
        Map<String, String> replaceContent = ImageUtils.replaceContent(update);
        return FileContentOperateUtils.replaceTextFileContent(template, ksPath, replaceContent, LineSeparator.LINUX);
    }

    private static Map<String, String> replaceContent(ImageUpdate update) {
        String disksLetter = IntStream.range(0, update.getDiskNum()).mapToObj(num -> "vd" + (char)(97 + num)).collect(Collectors.joining(","));
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("{grubPassword}", update.getGrubPassword());
        replace.put("{password}", update.getRootPassword());
        replace.put("{diskList}", disksLetter);
        replace.put("{ip}", update.getIp());
        replace.put("{netmask}", update.getNetMask());
        replace.put("{gateway}", update.getGateway());
        replace.put("{device}", update.getNetDevice());
        return replace;
    }

    @Generated
    private ImageUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

