/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.utils.valid;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PasswordCommonValidUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PasswordCommonValidUtils.class);
    private static final Pattern PATTERN_DIGIT = Pattern.compile("\\d");
    private static final Pattern PATTERN_UPPER = Pattern.compile("[A-Z]");
    private static final Pattern PATTERN_LOWER = Pattern.compile("[a-z]");
    private static final String SPACIAL_CHARS = "~!@#$%^&*( )-_=+|\\[{}];:\",<.>/?";
    private static final String SPACIAL_CHARS_NO_SPACE = "~!@#$%^&*()-_=+|\\[{}];:\",<.>/?";
    private static final Pattern PATTERN_REPEATED_THREE_TIMES = Pattern.compile("^.*(.)\\1\\1\\1.*$");

    public static boolean validCommonCharacterPassword(String password, int minLimit) {
        boolean hasLimitDiffFormat = PasswordCommonValidUtils.passwordValid(password, minLimit);
        boolean hasSpcChar = PasswordCommonValidUtils.validWhitelistSpecialChars(password);
        return hasSpcChar && hasLimitDiffFormat;
    }

    public static boolean validCommonCharacterPassword(String password) {
        int minLimit = 3;
        if (PasswordCommonValidUtils.validWhitelistSpecialChars(password)) {
            --minLimit;
        }
        return PasswordCommonValidUtils.passwordValid(password, minLimit);
    }

    public static boolean validCommonCharacterPassword(String password, int minLimit, boolean spacialCharContainsSpace) {
        if (spacialCharContainsSpace) {
            return PasswordCommonValidUtils.validCommonCharacterPassword(password, minLimit);
        }
        boolean hasLimitDiffFormat = PasswordCommonValidUtils.passwordValid(password, minLimit);
        boolean hasSpcChar = PasswordCommonValidUtils.validWhitelistSpecialCharsWithoutSpace(password);
        return hasSpcChar && hasLimitDiffFormat;
    }

    private static boolean passwordValid(String password, int minLimit) {
        boolean hasUpper = PATTERN_UPPER.matcher(password).find();
        boolean hasLower = PATTERN_LOWER.matcher(password).find();
        boolean hasDigit = PATTERN_DIGIT.matcher(password).find();
        return Stream.of(hasUpper, hasLower, hasDigit).filter(flag -> flag).count() >= (long)minLimit;
    }

    public static boolean validContainUsername(String password, String username) {
        return StringUtils.isNotEmpty(username) && (password.contains(username) || password.contains(new StringBuffer(username).reverse()));
    }

    public static boolean validLengthPassword(String password, int minLength, int maxLength) {
        return minLength <= password.length() && password.length() <= maxLength;
    }

    public static boolean validWhitelistSpecialChars(String password) {
        return PasswordCommonValidUtils.checkWithSpacialChar(password, SPACIAL_CHARS);
    }

    private static boolean checkWithSpacialChar(String password, String spacialChar) {
        boolean hasSpecialChar = false;
        for (char ch : password.toCharArray()) {
            if (Character.isUpperCase(ch) || Character.isLowerCase(ch) || Character.isDigit(ch)) continue;
            if (!spacialChar.contains(String.valueOf(ch))) {
                return false;
            }
            hasSpecialChar = true;
        }
        return hasSpecialChar;
    }

    public static boolean validWhitelistSpecialCharsWithoutSpace(String password) {
        return PasswordCommonValidUtils.checkWithSpacialChar(password, SPACIAL_CHARS_NO_SPACE);
    }

    public static boolean validPasswordWithoutConsecutiveChars(String password) {
        return !PasswordCommonValidUtils.checkHasConsecutiveChars(password);
    }

    private static boolean checkHasConsecutiveChars(String password) {
        return PATTERN_REPEATED_THREE_TIMES.matcher(password).find();
    }

    @Generated
    private PasswordCommonValidUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

