/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.library;

import com.library.LoggerUtil;

public class IpAddressUtils {
    private static final int IPV4_DECIMAL_RADIX = 10;
    private static final int IPV4_MAX = 255;
    private static final int IPV6_HEX_RADIX = 16;
    private static final int IPV6_MAX = 65535;
    private static final String IPV6_SEPARATOR = ":";
    private static final String IPV6_COMPACT_SEPARATOR = "::";
    private static final int PORT_MAX = 65535;

    public static boolean isLegalIPV4Address(String ip) {
        LoggerUtil.info("validate IPv4 : [" + ip + "]");
        if (ip == null) {
            LoggerUtil.error("IPv4 address is null");
            return false;
        }
        if (!ip.contains(".") || ip.endsWith(".")) {
            LoggerUtil.error("Invalid ipv4");
            return false;
        }
        String[] ipParts = ip.split("\\.");
        if (ipParts.length != 4) {
            LoggerUtil.error("Invalid ipv4 length");
            return false;
        }
        return IpAddressUtils.isLegalIp(ipParts, 10, 255);
    }

    public static boolean isLegalIPV6Address(String ip) {
        LoggerUtil.info("validate IPv6 : [" + ip + "]");
        if (ip == null) {
            LoggerUtil.error("IPv6 address is null");
            return false;
        }
        if (ip.contains(IPV6_COMPACT_SEPARATOR)) {
            return IpAddressUtils.validateCompactIPV6Address(ip);
        }
        return IpAddressUtils.validateNormalIPV6Address(ip);
    }

    private static boolean validateNormalIPV6Address(String ip) {
        if (ip.endsWith(IPV6_SEPARATOR)) {
            LoggerUtil.error("Invalid ipv6 end with ':'");
            return false;
        }
        String[] ipParts = ip.split(IPV6_SEPARATOR);
        if (ipParts.length != 8) {
            LoggerUtil.error("Invalid ipv6 : length is nor correct");
            return false;
        }
        return IpAddressUtils.isLegalIp(ipParts, 16, 65535);
    }

    private static boolean validateCompactIPV6Address(String ip) {
        String[] secondParts;
        int index = ip.indexOf(IPV6_COMPACT_SEPARATOR);
        int nextToCompactSeparator = index + 2;
        if (nextToCompactSeparator < ip.length() && ip.charAt(nextToCompactSeparator) == ':') {
            LoggerUtil.error("Invalid ipv6 address multiple : exists ");
            return false;
        }
        int lastIndex = ip.lastIndexOf(IPV6_COMPACT_SEPARATOR);
        if (index != lastIndex) {
            LoggerUtil.error("Invalid ipv6 multiple :: ");
            return false;
        }
        String[] parts = ip.split(IPV6_COMPACT_SEPARATOR);
        if (parts.length == 0) {
            return true;
        }
        if (ip.startsWith(IPV6_COMPACT_SEPARATOR)) {
            if (ip.endsWith(IPV6_SEPARATOR)) {
                LoggerUtil.error("Invalid ipv6 end with : ");
                return false;
            }
            String[] secondParts2 = parts[1].split(IPV6_SEPARATOR);
            if (secondParts2.length > 8) {
                LoggerUtil.error("Invalid ipv6 length error ");
                return false;
            }
            return IpAddressUtils.isLegalIp(secondParts2, 16, 65535);
        }
        if (ip.endsWith(IPV6_COMPACT_SEPARATOR)) {
            String[] firstParts = parts[0].split(IPV6_SEPARATOR);
            if (firstParts.length > 8) {
                LoggerUtil.error("Invalid ipv6 length error ");
                return false;
            }
            return IpAddressUtils.isLegalIp(firstParts, 16, 65535);
        }
        if (ip.endsWith(IPV6_SEPARATOR)) {
            LoggerUtil.error("Invalid ipv6 end with : ");
            return false;
        }
        String[] firstParts = parts[0].split(IPV6_SEPARATOR);
        if (firstParts.length + (secondParts = parts[1].split(IPV6_SEPARATOR)).length > 8) {
            LoggerUtil.error("Invalid ipv6 length error ");
            return false;
        }
        return IpAddressUtils.isLegalIp(firstParts, 16, 65535) && IpAddressUtils.isLegalIp(secondParts, 16, 65535);
    }

    private static boolean isLegalIp(String[] ipParts, int radix, int max) {
        for (String ipPart : ipParts) {
            try {
                int ipValue = Integer.valueOf(ipPart, radix);
                if (ipValue >= 0 && ipValue <= max) continue;
                LoggerUtil.error("Invalid ip value");
                return false;
            }
            catch (NumberFormatException e) {
                LoggerUtil.error("Invalid ip character");
                return false;
            }
        }
        return true;
    }

    public static Object getPort(Object port) {
        if (port instanceof String) {
            try {
                int parsedPort = Integer.parseInt((String)port);
                if (parsedPort < 0 || parsedPort > 65535) {
                    LoggerUtil.error("Port range should be in 0 ~ 65535");
                }
            }
            catch (NumberFormatException e) {
                LoggerUtil.error("Invalid port can not convert.");
            }
            return port;
        }
        if (port instanceof Integer) {
            int parsedPort = (Integer)port;
            if (parsedPort <= 0 || parsedPort > 65535) {
                LoggerUtil.error("Port is invalid");
            }
            return port;
        }
        LoggerUtil.error("Unsupport data type.");
        return port;
    }
}

