/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vm.console.process;

import com.huawei.vm.console.communication.CommunicationSender;
import com.huawei.vm.console.communication.ProtocolCode;
import com.huawei.vm.console.communication.ProtocolProcessor;
import com.huawei.vm.console.process.USBProcessor;
import com.huawei.vm.console.storage.impl.CDROMDevice;
import com.huawei.vm.console.storage.impl.CDROMDriver;
import com.huawei.vm.console.storage.impl.CDROMImage;
import com.huawei.vm.console.utils.TestPrint;
import com.huawei.vm.console.utils.VMException;
import com.kvm.AESHandler;

public class SFF8020iProcessor
extends USBProcessor
implements Runnable {
    private final CDROMDriver cdrom;
    private int readErrNum = 0;
    private long readErrAreaBegin = 0L;
    private long readErrAreaEnd = 0L;
    public static final int READ_ERR_LIMIT = 2;
    protected final byte[] inquiryData = new byte[]{5, -128, 0, 33, 31, 0, 0, 0, 86, 105, 114, 116, 117, 97, 108, 32, 68, 86, 68, 45, 82, 79, 77, 32, 86, 77, 32, 49, 46, 49, 46, 48, 32, 50, 50, 53};
    public int cacheBlockNum = 0;
    public long cacheLba = 0L;

    public SFF8020iProcessor(CDROMDriver cdrom, CommunicationSender sender) {
        super(sender);
        this.cdrom = cdrom;
    }

    public SFF8020iProcessor(String devicePath, int deviceType, CommunicationSender sender) throws VMException {
        super(sender);
        if (2 == deviceType) {
            this.cdrom = new CDROMDevice(devicePath);
        } else if (3 == deviceType) {
            this.cdrom = new CDROMImage(devicePath, true);
        } else {
            throw new VMException(324);
        }
    }

    @Override
    public void run() {
        while (!this.exitFlag) {
            this.processCommand();
        }
    }

    private void checkChangeDisk() {
        if (this.cdrom.isChangeDisk()) {
            try {
                if (this.cdrom.isEject()) {
                    this.cdrom.eject();
                } else {
                    this.cdrom.insert();
                }
            }
            catch (VMException e) {
                TestPrint.println(3, "Error happened while changing disk.");
            }
        }
    }

    @Override
    public void processCommand() {
        this.getCommand();
        this.checkChangeDisk();
        if (this.exitFlag) {
            return;
        }
        this.cdrom.refreshState();
        switch (this.command[0] & 0xFF) {
            case 18: {
                this.doInquiry();
                break;
            }
            case 85: {
                int paramListLength = ProtocolCode.getInt16bits(this.command, 8);
                if (paramListLength != this.getData(this.dataBuffer, paramListLength)) {
                    this.setSenseKeys(5, 26, 0, 0);
                    break;
                }
                this.setSenseKeys(0, 0, 0, 0);
                break;
            }
            case 90: {
                this.doModeSense();
                break;
            }
            case 30: {
                this.doPreventAllowMediumRemoval(this.command);
                break;
            }
            case 40: 
            case 168: {
                this.doRead(this.command);
                break;
            }
            case 37: {
                this.doReadCapacity();
                break;
            }
            case 190: {
                this.doReadCD();
                break;
            }
            case 185: {
                this.doReadMSF();
                break;
            }
            case 68: {
                this.doReadHeader();
                break;
            }
            case 66: {
                this.doReadSubChannel();
                break;
            }
            case 67: {
                this.doReadToc(this.command);
                break;
            }
            case 3: {
                this.doRequsetSense();
                break;
            }
            case 43: {
                this.setSenseKeys(0, 0, 0, 0);
                break;
            }
            case 27: {
                this.doStartStopUnit(this.command);
                break;
            }
            case 0: {
                this.doTestUnitRead();
                break;
            }
            case 74: {
                this.doTestUnitRead();
                break;
            }
            default: {
                this.setSenseKeys(5, 36, 0, 0);
            }
        }
        this.commandFinish();
    }

    private void doInquiry() {
        this.sendData(this.inquiryData.length, this.inquiryData, true);
        this.setSenseKeys(0, 0, 0, 0);
    }

    private void doModeSense() {
        int length = this.cdrom.modeSense(this.dataBuffer, this.command[2] >> 6 & 0xFF, this.command[2] & 0x3F);
        if (0 == length) {
            this.setSenseKeys(5, 36, 0, 0);
        } else {
            this.setSenseKeys(0, 0, 0, 0);
            this.sendData(length, this.dataBuffer, true);
        }
    }

    private void doPreventAllowMediumRemoval(byte[] command) {
        boolean support;
        boolean isPrevent = false;
        if (1 == (command[4] & 1)) {
            isPrevent = true;
        }
        if (support = this.cdrom.preventAllowMediumRemoval(isPrevent)) {
            this.setSenseKeys(0, 0, 0, 0);
        } else {
            this.setSenseKeys(5, 36, 0, 0);
        }
    }

    private void doRead(byte[] command) {
        long lba = ProtocolCode.getInt32bits(command, 3);
        int blockNum = 0;
        blockNum = 40 == command[0] ? ProtocolCode.getInt16bits(command, 8) : ProtocolCode.getInt32bits(command, 7);
        int length = blockNum * 2048;
        if (this.cacheBlockNum != 0 && this.cacheBlockNum == blockNum && this.cacheLba != 0L && this.cacheLba == lba) {
            this.sendData(length, this.dataBuffer2, true);
            this.setSenseKeys(0, 0, 0, 0);
        } else {
            int curRead = this.read(lba, blockNum, false);
            if (curRead <= 0) {
                return;
            }
            this.sendData(curRead, this.dataBuffer2, true);
            this.setSenseKeys(0, 0, 0, 0);
        }
        this.cacheBlockNum = blockNum;
        this.cacheLba = lba + (long)blockNum;
        this.read(this.cacheLba, this.cacheBlockNum, true);
    }

    private int read(long lba, int blockNum, boolean cache) {
        long startPos = lba * 2048L;
        int length = 0;
        int curRead = 0;
        length = blockNum * 2048;
        try {
            if (this.readErrNum >= 2 && this.readErrAreaBegin <= lba && lba < this.readErrAreaEnd) {
                if (!cache) {
                    this.setSenseKeys(3, 16, 0, (int)(startPos / 2048L));
                }
                this.cacheBlockNum = 0;
                this.cacheLba = 0L;
            } else if (startPos >= 0L && startPos < this.cdrom.getMediumSize()) {
                int readLength = 0;
                int bufferLen = this.dataBuffer2.length;
                readLength = bufferLen < length ? bufferLen : length;
                curRead = this.cdrom.read(this.dataBuffer2, startPos, readLength);
                length = curRead == readLength ? (length -= readLength) : -1;
                if (0 == length) {
                    if (!cache) {
                        this.setSenseKeys(0, 0, 0, 0);
                    }
                } else {
                    TestPrint.println(3, "SFF Processor: Read -- address error(sensekey:ILOGICAL BLOCK ADDRESS OUT OF RANGE)");
                    if (!cache) {
                        this.setSenseKeys(5, 33, 0, 0);
                    }
                    this.cacheBlockNum = 0;
                    this.cacheLba = 0L;
                }
                this.readErrNum = 0;
            } else {
                TestPrint.println(3, "SFF Processor: Read -- address error(sensekey:ILOGICAL BLOCK ADDRESS OUT OF RANGE)");
                if (!cache) {
                    this.setSenseKeys(5, 33, 0, 0);
                }
                this.cacheBlockNum = 0;
                this.cacheLba = 0L;
            }
        }
        catch (VMException e) {
            this.cacheBlockNum = 0;
            this.cacheLba = 0L;
            switch (e.getKey()) {
                case 250: {
                    TestPrint.println(3, "SFF Processor: Read -- read error(sensekey:ID CRC ERROR)");
                    if (!cache) {
                        this.setSenseKeys(3, 16, 0, (int)(startPos / 2048L));
                    }
                    ++this.readErrNum;
                    this.readErrAreaBegin = lba;
                    this.readErrAreaEnd = lba + (long)blockNum;
                    break;
                }
                case 251: {
                    TestPrint.println(3, "SFF Processor: Read -- address error(sensekey:ILOGICAL BLOCK ADDRESS OUT OF RANGE)");
                    if (cache) break;
                    this.setSenseKeys(5, 33, 0, 0);
                    break;
                }
                case 253: {
                    TestPrint.println(3, "SFF Processor:Read -- media not present.");
                    this.cdrom.setDeviceState(0);
                    if (cache) break;
                    this.setSenseKeys(2, 58, 0, 0);
                    break;
                }
            }
        }
        return curRead;
    }

    private void doReadCapacity() {
        switch (this.cdrom.testUnitReady()) {
            case 0: {
                this.setSenseKeys(2, 58, 0, 0);
                break;
            }
            case 2: {
                this.setSenseKeys(6, 40, 0, 0);
                break;
            }
            case 3: {
                long mediumSize = 0L;
                try {
                    mediumSize = this.cdrom.getMediumSize();
                    long lba = mediumSize / 2048L - 1L;
                    this.dataBuffer[0] = (byte)(lba >> 24 & 0xFFL);
                    this.dataBuffer[1] = (byte)(lba >> 16 & 0xFFL);
                    this.dataBuffer[2] = (byte)(lba >> 8 & 0xFFL);
                    this.dataBuffer[3] = (byte)(lba & 0xFFL);
                    this.dataBuffer[4] = 0;
                    this.dataBuffer[5] = 0;
                    this.dataBuffer[6] = 8;
                    this.dataBuffer[7] = 0;
                    this.setSenseKeys(0, 0, 0, 0);
                    this.sendData(8, this.dataBuffer, true);
                }
                catch (VMException e) {
                    this.cdrom.setDeviceState(0);
                    this.setSenseKeys(2, 58, 0, 0);
                }
                break;
            }
        }
    }

    private void doReadCD() {
        this.setSenseKeys(5, 36, 0, 0);
    }

    private void doReadMSF() {
        this.setSenseKeys(5, 36, 0, 0);
    }

    private void doReadHeader() {
        this.setSenseKeys(5, 36, 0, 0);
    }

    private void doReadSubChannel() {
        this.setSenseKeys(5, 36, 0, 0);
    }

    private void doReadToc(byte[] command) {
        boolean isMSF = (command[1] & 2) == 2;
        int format = command[2] & 7;
        if (0 == format) {
            format = command[9] >> 6 & 3;
        }
        int allocLength = ProtocolCode.getInt16bits(command, 8);
        byte startTrack = command[6];
        int tocDataLen = 0;
        try {
            tocDataLen = this.cdrom.readTOC(this.dataBuffer, isMSF, format, startTrack);
            this.setSenseKeys(0, 0, 0, 0);
        }
        catch (VMException e) {
            if (252 == e.getKey()) {
                this.setSenseKeys(5, 36, 0, 0);
            }
            this.cdrom.setDeviceState(0);
            this.setSenseKeys(2, 58, 0, 0);
        }
        if (allocLength < tocDataLen) {
            tocDataLen = allocLength;
        }
        this.sendData(tocDataLen, this.dataBuffer, true);
    }

    private void doRequsetSense() {
        byte[] senseData = this.senseData;
        this.sendData(senseData.length, senseData, true);
    }

    private void doStartStopUnit(byte[] command) {
        boolean isEject = false;
        boolean isStart = false;
        if (2 == (command[4] & 2)) {
            isEject = true;
        }
        if (1 == (command[4] & 1)) {
            isStart = true;
        }
        try {
            this.cdrom.startStopUnit(isEject, isStart);
            this.setSenseKeys(0, 0, 0, 0);
        }
        catch (VMException e) {
            this.setSenseKeys(5, 36, 0, 0);
        }
    }

    private void doTestUnitRead() {
        int state = 0;
        state = this.cdrom.testUnitReady();
        switch (state) {
            case 2: {
                this.cdrom.setDeviceState(2);
                this.setSenseKeys(6, 40, 0, 0);
                this.readErrNum = 0;
                break;
            }
            case 3: {
                this.cdrom.setDeviceState(3);
                this.setSenseKeys(0, 0, 0, 0);
                break;
            }
            case 5: {
                this.cdrom.setDeviceState(0);
                this.setSenseKeys(2, 48, 0, 0);
                this.readErrNum = 0;
                break;
            }
            case 4: {
                this.cdrom.setDeviceState(2);
                this.setSenseKeys(2, 4, 0, 0);
                this.readErrNum = 0;
                break;
            }
            default: {
                this.cdrom.setDeviceState(0);
                this.setSenseKeys(2, 58, 0, 0);
                this.readErrNum = 0;
            }
        }
    }

    @Override
    public void sendData(int dataLength, byte[] dataBuffer, boolean isLast) {
        int off = 0;
        int curLength = 0;
        byte[] curPack = null;
        byte[] curData = null;
        int send_len = 0;
        if (0 == dataLength && isLast) {
            curPack = ProtocolProcessor.sffDataPak(1, 3, dataLength, this.commandID);
            this.sender.sendImmediate(curPack, 12);
        }
        boolean flag = false;
        while (dataLength > 0 && !this.exitFlag) {
            if (ProtocolCode.CDROM_PACKET_SIZE < dataLength) {
                curLength = ProtocolCode.CDROM_PACKET_SIZE;
                curPack = ProtocolProcessor.sffDataPak(1, 1, curLength, this.commandID);
            } else {
                curLength = dataLength;
                curPack = isLast ? ProtocolProcessor.sffDataPak(1, 3, curLength, this.commandID) : ProtocolProcessor.sffDataPak(1, 1, curLength, this.commandID);
            }
            if (this.sender.getConsole().getVmm_compress_state() == 0) {
                curData = this.sender.getByteArr(12 + curLength);
                System.arraycopy(curPack, 0, curData, 0, 12);
                System.arraycopy(dataBuffer, off, curData, 12, curLength);
                send_len = 12 + curLength;
            } else {
                byte[] data = new byte[curLength];
                byte[] datalen = new byte[]{(byte)(curLength >> 24 & 0xFF), (byte)(curLength >> 16 & 0xFF), (byte)(curLength >> 8 & 0xFF), (byte)(curLength & 0xFF)};
                System.arraycopy(dataBuffer, off, data, 0, curLength);
                byte[] temDes = AESHandler.vmmencry(data, this.sender.getConsole().getSecretKey(), curLength, this.sender.getConsole().getSecretIvBMC());
                if (temDes == null || 0 == temDes.length) {
                    return;
                }
                int ComLen = temDes.length + 4;
                curPack[4] = (byte)(ComLen >> 24 & 0xFF);
                curPack[5] = (byte)(ComLen >> 16 & 0xFF);
                curPack[6] = (byte)(ComLen >> 8 & 0xFF);
                curPack[7] = (byte)(ComLen & 0xFF);
                curData = this.sender.getByteArr(12 + temDes.length + 4);
                System.arraycopy(curPack, 0, curData, 0, 12);
                System.arraycopy(datalen, 0, curData, 12, 4);
                System.arraycopy(temDes, 0, curData, 16, temDes.length);
                send_len = 12 + temDes.length + 4;
            }
            flag = this.sender.send(curData, send_len);
            while (!flag && !this.exitFlag) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
            off += curLength;
            dataLength -= curLength;
        }
    }

    @Override
    public void commandFinish() {
        int result = 0;
        if (0 != this.getSenseKey() && 3 != (this.command[0] & 0xFF) || 74 == (this.command[0] & 0xFF)) {
            result = 1;
        }
        byte[] cmpltPak = this.sender.getByteArr(12);
        ProtocolProcessor.sffCmpltPak(cmpltPak, 0, result, this.commandID);
        this.sender.sendImmediate(cmpltPak, 12);
    }
}

