/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.fo;

import com.huawei.yinglong.river.sitedeployment.dcs.annotation.validation.ObjectValidator;
import com.huawei.yinglong.river.sitedeployment.dcs.annotation.validation.Validatable;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.DeployArch;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.DeployScene;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.FcInstallParamValidator;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.fo.CnaInstallParamsFo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.fo.InsParamBackupFo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.fo.InsParamNtpFo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.fo.VrmInstallParamsFo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.utils.ValidationUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.ValidationMsgUtils;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;

public class FcInstallParamsFo
implements Validatable {
    private static EnumMap<DeployScene, FcInstallParamValidator> validateSceneMaps = new EnumMap(DeployScene.class);
    @NotEmpty
    private String id;
    @NotEmpty
    private String name;
    @NotEmpty
    private String packagePath;
    @Pattern(regexp="^FusionCompute-LinuxInstaller-(\\d\\.)+\\w+-(X86_64|ARM_64)\\.zip$", message="{error.validation.installer_file_name}")
    @NotNull
    private @Pattern(regexp="^FusionCompute-LinuxInstaller-(\\d\\.)+\\w+-(X86_64|ARM_64)\\.zip$", message="{error.validation.installer_file_name}") @NotNull String installerFileName;
    @Pattern(regexp="^FusionCompute_VRM-(\\d\\.)+\\w+-(X86_64|ARM_64)\\.zip$", message="{error.validation.vrm_temp_file_name}")
    private @Pattern(regexp="^FusionCompute_VRM-(\\d\\.)+\\w+-(X86_64|ARM_64)\\.zip$", message="{error.validation.vrm_temp_file_name}") String vrmTempFileName;
    @Pattern(regexp="^FusionCompute_CNA-(\\d\\.)+\\w+-(X86_64|ARM_64)\\.iso$", message="{error.validation.cna_iso_file_name}")
    private @Pattern(regexp="^FusionCompute_CNA-(\\d\\.)+\\w+-(X86_64|ARM_64)\\.iso$", message="{error.validation.cna_iso_file_name}") String cnaIsoFileName;
    @Valid
    private VrmInstallParamsFo vrm;
    @Valid
    private CnaInstallParamsFo cna;

    public List<String> validate(int scene, Class<?> ... groups) {
        DeployArch deployArch = DeployArch.of(this.installerFileName);
        DeployScene deployScene = DeployScene.of(scene);
        this.clearInvalidParams(deployScene);
        List validateResults = ObjectValidator.valid((Object)this, ValidationMsgUtils::getString, (Class[])new Class[0]);
        Optional.ofNullable(validateSceneMaps.get((Object)deployScene)).ifPresent(consumer -> validateResults.addAll(consumer.validate(this.id, deployArch, this.vrm, this.cna)));
        return validateResults.stream().distinct().collect(Collectors.toList());
    }

    private void clearInvalidParams(DeployScene deployScene) {
        if (deployScene == DeployScene.DEPLOY_VRM) {
            this.cna = null;
            this.cnaIsoFileName = null;
        }
        if (deployScene == DeployScene.DEPLOY_CNA) {
            this.vrm = null;
            this.vrmTempFileName = null;
        }
        Optional.ofNullable(this.vrm).map(VrmInstallParamsFo::getBackup).ifPresent(InsParamBackupFo::clearInvalidParams);
        Optional.ofNullable(this.vrm).map(VrmInstallParamsFo::getNtp).ifPresent(InsParamNtpFo::clearInvalidParams);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPackagePath() {
        return this.packagePath;
    }

    @Generated
    public String getInstallerFileName() {
        return this.installerFileName;
    }

    @Generated
    public String getVrmTempFileName() {
        return this.vrmTempFileName;
    }

    @Generated
    public String getCnaIsoFileName() {
        return this.cnaIsoFileName;
    }

    @Generated
    public VrmInstallParamsFo getVrm() {
        return this.vrm;
    }

    @Generated
    public CnaInstallParamsFo getCna() {
        return this.cna;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPackagePath(String packagePath) {
        this.packagePath = packagePath;
    }

    @Generated
    public void setInstallerFileName(String installerFileName) {
        this.installerFileName = installerFileName;
    }

    @Generated
    public void setVrmTempFileName(String vrmTempFileName) {
        this.vrmTempFileName = vrmTempFileName;
    }

    @Generated
    public void setCnaIsoFileName(String cnaIsoFileName) {
        this.cnaIsoFileName = cnaIsoFileName;
    }

    @Generated
    public void setVrm(VrmInstallParamsFo vrm) {
        this.vrm = vrm;
    }

    @Generated
    public void setCna(CnaInstallParamsFo cna) {
        this.cna = cna;
    }

    static {
        validateSceneMaps.put(DeployScene.FILL_PARAM, ValidationUtils::validateParamInFillParam);
        validateSceneMaps.put(DeployScene.DEPLOY_VRM, (taskId, arch, vrm, cna) -> ValidationUtils.validateParamInDeployVrm(taskId, arch, vrm));
        validateSceneMaps.put(DeployScene.DEPLOY_CNA, (taskId, arch, vrm, cna) -> ValidationUtils.validateParamInDeployCna(taskId, arch, cna));
    }
}

