/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.fo;

import com.huawei.yinglong.river.sitedeployment.dcs.annotation.IpAddress;
import com.huawei.yinglong.river.sitedeployment.dcs.annotation.Password;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class InsParamBackupFo {
    private boolean isConfigBackup;
    @Pattern(regexp="(third|host)", message="{error.validation.data_type}")
    private @Pattern(regexp="(third|host)", message="{error.validation.data_type}") String backupType;
    @Pattern(regexp="(ftp|ftps)", message="{error.validation.ftp_protocol}")
    private @Pattern(regexp="(ftp|ftps)", message="{error.validation.ftp_protocol}") String ftpProtocol;
    @IpAddress(required=false, message="{error.validation.ftp_ip_address}")
    private String ftpIpAddr;
    @Pattern(regexp=".{1,256}", message="{error.validation.name_over_length}")
    private @Pattern(regexp=".{1,256}", message="{error.validation.name_over_length}") String ftpUsername;
    @Password(required=false, maxLength=31)
    private String ftpPassword;
    @Range(min=1L, max=65535L)
    private @Range(min=1L, max=65535L) int ftpPort = 21;
    @Pattern(regexp="^(/\\w{1,100}){1,60}/?$")
    private @Pattern(regexp="^(/\\w{1,100}){1,60}/?$") String ftpBackupPath;
    private String ftpCertPath;
    private List<String> backupCnaNames;

    void clearInvalidParams() {
        if (!this.isConfigBackup) {
            this.backupType = "third";
            this.ftpProtocol = "ftps";
            this.ftpIpAddr = null;
            this.ftpUsername = "ftp";
            this.ftpPassword = null;
            this.ftpPort = 21;
            this.ftpBackupPath = "/GalaxEngineBackup/VRM/";
            this.ftpCertPath = null;
            this.backupCnaNames = Collections.emptyList();
        }
    }

    @Generated
    public boolean isConfigBackup() {
        return this.isConfigBackup;
    }

    @Generated
    public String getBackupType() {
        return this.backupType;
    }

    @Generated
    public String getFtpProtocol() {
        return this.ftpProtocol;
    }

    @Generated
    public String getFtpIpAddr() {
        return this.ftpIpAddr;
    }

    @Generated
    public String getFtpUsername() {
        return this.ftpUsername;
    }

    @Generated
    public String getFtpPassword() {
        return this.ftpPassword;
    }

    @Generated
    public int getFtpPort() {
        return this.ftpPort;
    }

    @Generated
    public String getFtpBackupPath() {
        return this.ftpBackupPath;
    }

    @Generated
    public String getFtpCertPath() {
        return this.ftpCertPath;
    }

    @Generated
    public List<String> getBackupCnaNames() {
        return this.backupCnaNames;
    }

    @Generated
    public InsParamBackupFo setConfigBackup(boolean isConfigBackup) {
        this.isConfigBackup = isConfigBackup;
        return this;
    }

    @Generated
    public InsParamBackupFo setBackupType(String backupType) {
        this.backupType = backupType;
        return this;
    }

    @Generated
    public InsParamBackupFo setFtpProtocol(String ftpProtocol) {
        this.ftpProtocol = ftpProtocol;
        return this;
    }

    @Generated
    public InsParamBackupFo setFtpIpAddr(String ftpIpAddr) {
        this.ftpIpAddr = ftpIpAddr;
        return this;
    }

    @Generated
    public InsParamBackupFo setFtpUsername(String ftpUsername) {
        this.ftpUsername = ftpUsername;
        return this;
    }

    @Generated
    public InsParamBackupFo setFtpPassword(String ftpPassword) {
        this.ftpPassword = ftpPassword;
        return this;
    }

    @Generated
    public InsParamBackupFo setFtpPort(int ftpPort) {
        this.ftpPort = ftpPort;
        return this;
    }

    @Generated
    public InsParamBackupFo setFtpBackupPath(String ftpBackupPath) {
        this.ftpBackupPath = ftpBackupPath;
        return this;
    }

    @Generated
    public InsParamBackupFo setFtpCertPath(String ftpCertPath) {
        this.ftpCertPath = ftpCertPath;
        return this;
    }

    @Generated
    public InsParamBackupFo setBackupCnaNames(List<String> backupCnaNames) {
        this.backupCnaNames = backupCnaNames;
        return this;
    }

    @Generated
    public InsParamBackupFo() {
    }
}

