/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.impl;

import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.ConsistencyFileItemVo;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.ConsistencyItemVo;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.ConsistencyResultVo;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.PackageConsistencyVo;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyCheckItem;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyFilterType;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyManager;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyType;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.FcErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.LogicException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.ConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ResponseUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorDetail;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PackageConsistencyImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PackageConsistencyImpl.class);

    public Response<ConsistencyResultVo> queryPkgConsistencyResult(String uuid) {
        List checkItems = ConsistencyManager.getManager().queryCheckResult(uuid);
        List itemVos = checkItems.stream().map(this::createConsistencyItem).collect(Collectors.toList());
        return ResponseUtils.success((Object)ConsistencyResultVo.builder().items(itemVos).build());
    }

    public Response<PackageConsistencyVo> validatePkgConsistency(String path, Integer type, String installModes) {
        try {
            ConsistencyFilterType filterType = ConsistencyFilterType.of((int)type);
            if (filterType == ConsistencyFilterType.NONE) {
                return ResponseUtils.failed((ErrorDetail)new LogicException((ErrorKey)FcErrorCode.TASK_PARAM_INVALID, Collections.singletonList("type")));
            }
            ConsistencyType consistencyType = this.getConsistencyType();
            String decodePath = URLDecoder.decode(path, StandardCharsets.UTF_8.name());
            List checkItems = ConsistencyManager.getManager().queryCheckItems(decodePath, filterType, consistencyType, installModes);
            if (checkItems == null || checkItems.isEmpty()) {
                return ResponseUtils.failed((ErrorDetail)new LogicException(FcErrorCode.CONSISTENCY_SOFTWARE_NOT_EXIST));
            }
            List fileItemVos = checkItems.stream().map(this::createConsistencyFileItem).collect(Collectors.toList());
            String uuid = ConsistencyManager.getManager().startConsistencyCheck(checkItems, consistencyType);
            return ResponseUtils.success((Object)PackageConsistencyVo.builder().uuid(uuid).items(fileItemVos).build());
        }
        catch (BasicException e) {
            return ResponseUtils.failed((String)e.getErrorMessage(), (String)e.getSuggestMessage());
        }
        catch (UnsupportedEncodingException e) {
            return ResponseUtils.failed((String)e.getMessage(), (String)"");
        }
    }

    public Response<ConsistencyResultVo> syncValidatePkgConsistency(String path, Integer validateType) {
        try {
            ConsistencyFilterType filterType = ConsistencyFilterType.of((int)validateType);
            if (filterType == ConsistencyFilterType.NONE) {
                return ResponseUtils.failed((ErrorDetail)new LogicException((ErrorKey)FcErrorCode.TASK_PARAM_INVALID, Collections.singletonList("type")));
            }
            List itemVos = ConsistencyManager.getManager().syncStartConsistencyCheck(URLDecoder.decode(path, StandardCharsets.UTF_8.name()), filterType, this.getConsistencyType()).stream().map(this::createConsistencyItem).collect(Collectors.toList());
            return ResponseUtils.success((Object)ConsistencyResultVo.builder().items(itemVos).build());
        }
        catch (BasicException e) {
            return ResponseUtils.failed((String)e.getErrorMessage(), (String)e.getSuggestMessage());
        }
        catch (UnsupportedEncodingException e) {
            return ResponseUtils.failed((String)e.getMessage(), (String)"");
        }
    }

    private ConsistencyFileItemVo createConsistencyFileItem(ConsistencyCheckItem checkItem) {
        return ConsistencyFileItemVo.builder().fileName(checkItem.getPkgFile().getName()).fileType(Integer.valueOf(checkItem.getType())).build();
    }

    private ConsistencyItemVo createConsistencyItem(ConsistencyCheckItem checkItem) {
        return ConsistencyItemVo.builder().fileName(checkItem.getPkgFile().getName()).fileType(Integer.valueOf(checkItem.getType())).result(Integer.valueOf(checkItem.getResult())).build();
    }

    private ConsistencyType getConsistencyType() {
        String consistencyTypeName = ConfigUtils.getPropertiesValue("deployfc.package.consistency.type", ConsistencyType.CMS.name());
        ConsistencyType consistencyType = ConsistencyType.of((String)consistencyTypeName);
        log.info("current consistency type name : {}, enum type : {}.", (Object)consistencyTypeName, (Object)consistencyType);
        return consistencyType;
    }
}

