/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.fo.InsParamVrmFo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.ConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.ValidationMsgUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.CryptUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ZipUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidDomesticEncryptionHsm {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidDomesticEncryptionHsm.class);
    private static final String SANSEC = ConfigUtils.getPropertiesValue("deploy.fc.hsm.sansec", "");
    private static final String WESTONE = ConfigUtils.getPropertiesValue("deploy.fc.hsm.westone", "");
    private static final String SANSEC_JARS = ConfigUtils.getPropertiesValue("deploy.fc.hsm.sansec.jar", "");
    private static final String WESTONE_JARS = ConfigUtils.getPropertiesValue("deploy.fc.hsm.westone.jar", "");
    private static final String BASE_DIR = FilePathValidatorUtils.getSafePath((String)System.getProperty("user.dir")).orElse("");
    private static final String ZIP_TOOL_PATH = FilePathValidatorUtils.joinChildPath((String[])new String[]{BASE_DIR, "tools", "7z", "7z.exe"});
    private static final String TEMPORATY_FILE = FilePathValidatorUtils.joinChildPath((String[])new String[]{BASE_DIR, "template_cache"});

    public static List<String> validDomesticEncryptionFile(InsParamVrmFo insParamVrmFo) {
        ArrayList<String> validateResults = new ArrayList<String>();
        ValidDomesticEncryptionHsm.validDomesticEncryptionFile(insParamVrmFo.getHsmLibFile()).ifPresent(validateResults::add);
        Optional<String> fileCheckResult = ValidDomesticEncryptionHsm.validDomesticEncryptionZip(insParamVrmFo.getHsmLibFile(), insParamVrmFo.getHsmCompany(), insParamVrmFo.getHsmType());
        if (fileCheckResult.isPresent()) {
            validateResults.add(fileCheckResult.get());
            return validateResults;
        }
        Optional<String> temporaryFile = ValidDomesticEncryptionHsm.unzipDomesticEncryption(insParamVrmFo.getHsmLibFile());
        if (temporaryFile.isPresent()) {
            ValidDomesticEncryptionHsm.validSha256(temporaryFile.get(), insParamVrmFo.getHsmLibFile()).ifPresent(validateResults::add);
            FileOperateUtils.deleteDirectory((String)TEMPORATY_FILE);
        }
        return validateResults;
    }

    private static Optional<String> validSha256(String temporaryFile, String hsmPath) {
        String fileName = hsmPath.substring(hsmPath.lastIndexOf(File.separator) + 1).replace(".zip", "");
        if (!SANSEC.equals(fileName) && !WESTONE.equals(fileName)) {
            return Optional.of(ValidationMsgUtils.getString("error.validation.package_must_be_sansec_or_westone"));
        }
        if (SANSEC.equals(fileName)) {
            return ValidDomesticEncryptionHsm.validSha256File(temporaryFile, SANSEC, SANSEC_JARS);
        }
        return ValidDomesticEncryptionHsm.validSha256File(temporaryFile, WESTONE, WESTONE_JARS);
    }

    private static Optional<String> validSha256File(String temporaryFile, String type, String needVerifyJars) {
        Set needVerifyFiles = Arrays.stream(needVerifyJars.split(",")).collect(Collectors.toSet());
        if (needVerifyFiles.stream().anyMatch(jarFile -> !ValidDomesticEncryptionHsm.isSha256FileCompleteness(jarFile, temporaryFile, type))) {
            return Optional.of(ValidationMsgUtils.getString("error.validation.hsm_zip_package_dictionary_invalid"));
        }
        if (needVerifyFiles.stream().anyMatch(jarFile -> !ValidDomesticEncryptionHsm.verifySha256(jarFile, temporaryFile, type))) {
            return Optional.of(ValidationMsgUtils.getString("error.validation.sha256_file_invalid"));
        }
        return Optional.empty();
    }

    private static boolean verifySha256(String jarFile, String temporaryFile, String type) {
        String jarPath = temporaryFile.concat(File.separator).concat(type).concat(File.separator).concat(jarFile);
        String sha256Path = jarPath.replace("jar", "sha256");
        return CryptUtils.verifyConsistencyFileBySha256((File)new File(jarPath), (File)new File(sha256Path));
    }

    private static boolean isSha256FileCompleteness(String jarFile, String temporaryFile, String type) {
        String jarPath = temporaryFile.concat(File.separator).concat(type).concat(File.separator).concat(jarFile);
        String sha256Path = jarPath.replace("jar", "sha256");
        return FilePathValidatorUtils.isValidExistPaths((String[])new String[]{jarPath}) && FilePathValidatorUtils.isValidExistPaths((String[])new String[]{sha256Path});
    }

    private static Optional<String> unzipDomesticEncryption(String hsmPath) {
        if (StringUtils.isEmpty((CharSequence)hsmPath)) {
            return Optional.empty();
        }
        Optional temporary = FileOperateUtils.createTemplateCacheFile((String)String.valueOf(System.currentTimeMillis()));
        temporary.ifPresent(tempPath -> ZipUtils.decompressFileBy7Zip((String)ZIP_TOOL_PATH, (String)hsmPath, (String)tempPath));
        return temporary;
    }

    private static Optional<String> validDomesticEncryptionFile(String hsmPath) {
        if (!FilePathValidatorUtils.isValidExistPaths((String[])new String[]{hsmPath})) {
            return Optional.of(ValidationMsgUtils.getString("error.validation.fc_vrm_hsm_package_path_invalid"));
        }
        return Optional.empty();
    }

    private static Optional<String> validDomesticEncryptionZip(String path, String hsmCompany, String hsmType) {
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{path, hsmCompany, hsmType})) {
            return Optional.empty();
        }
        String fileName = path.substring(path.lastIndexOf(File.separator) + 1).replace(".zip", "");
        if (!fileName.equals(hsmCompany.concat("_").concat(hsmType))) {
            return Optional.of(ValidationMsgUtils.getString("error.validation.fc_vrm_hsm_package_company_type_compare_invalid"));
        }
        return Optional.empty();
    }

    @Generated
    private ValidDomesticEncryptionHsm() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

