/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.DeployArch;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.fo.CnaInstallParamsFo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.fo.FcInstallParamsFo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.fo.InsParamBackupFo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.fo.InsParamCnaFo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.fo.InsParamNodeFo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.fo.InsParamNtpFo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.fo.InsParamSizeFo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.fo.InsParamVrmFo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.fo.VrmInstallParamsFo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.utils.ValidDomesticEncryptionHsm;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.DeployTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.ValidationMsgUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.NumberUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidationUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidationUtils.class);
    private static final List<Integer> VALID_SYNC_PERIODS = Arrays.asList(64, 128, 256, 512, 1024, 2048, 4096);
    private static final Map<String, List<String>> VALID_HSM_COMPANY_TYPES = new HashMap<String, List<String>>(){
        {
            this.put("Westone", Collections.singletonList("SJJ1744"));
            this.put("Sansec", Collections.singletonList("SJJ1212"));
        }
    };

    private static String getValidationString(String resKey) {
        return ValidationMsgUtils.getString(resKey);
    }

    private static boolean checkIpRepeated(String orgIp, String ... dstIps) {
        if (StringUtils.isEmpty((CharSequence)orgIp)) {
            return false;
        }
        return Arrays.stream(dstIps).filter(StringUtils::isNotEmpty).anyMatch(ip -> Objects.equals(ip, orgIp));
    }

    private static List<String> validateVrmSizeModeParams(VrmInstallParamsFo vrmParams) {
        LinkedList<String> invalidMsgs = new LinkedList<String>();
        InsParamSizeFo size = vrmParams.getSize();
        if (Objects.equals(size.getMode(), "normal") && StringUtils.isEmpty((CharSequence)size.getId())) {
            invalidMsgs.add(ValidationUtils.getValidationString("vrm.size.id"));
        }
        if (Objects.equals(size.getMode(), "custom")) {
            if (size.getCpu() == null) {
                invalidMsgs.add(ValidationUtils.getValidationString("vrm.size.cpu"));
            }
            if (size.getMem() == null) {
                invalidMsgs.add(ValidationUtils.getValidationString("vrm.size.mem"));
            }
        }
        if (vrmParams.getVrm() != null && vrmParams.getVrm().isEnableKrm() && size.getRegistrySizeGb() == null) {
            invalidMsgs.add(ValidationUtils.getValidationString("vrm.size.registrySizeGb"));
        }
        return invalidMsgs;
    }

    private static List<String> validateVrmUserModeParams(InsParamVrmFo vrm) {
        LinkedList<String> invalidMsgs = new LinkedList<String>();
        String userMode = vrm.getUserMode();
        if (Objects.equals(userMode, "normal") && StringUtils.isEmpty((CharSequence)vrm.getAdminPwd())) {
            invalidMsgs.add(ValidationUtils.getValidationString("vrm.vrm.adminPwd"));
        }
        if (Objects.equals(userMode, "three")) {
            if (StringUtils.isEmpty((CharSequence)vrm.getSysAdminPwd())) {
                invalidMsgs.add(ValidationUtils.getValidationString("vrm.vrm.sysAdminPwd"));
            }
            if (StringUtils.isEmpty((CharSequence)vrm.getSecAdminPwd())) {
                invalidMsgs.add(ValidationUtils.getValidationString("vrm.vrm.secAdminPwd"));
            }
            if (StringUtils.isEmpty((CharSequence)vrm.getSecAuditorPwd())) {
                invalidMsgs.add(ValidationUtils.getValidationString("vrm.vrm.secAuditorPwd"));
            }
        }
        return invalidMsgs;
    }

    private static List<String> validateVrmUserModeParams(VrmInstallParamsFo vrmParams, InsParamVrmFo vrm) {
        LinkedList<String> invalidMsgs = new LinkedList<String>();
        InsParamCnaFo cna = vrmParams.getCna();
        invalidMsgs.addAll(ValidationUtils.validateVrmMasterIpPwdInSingleModeParams(vrm, cna));
        invalidMsgs.addAll(ValidationUtils.validateVrmSlaveIpPwdInDoubleModePrams(vrm, cna));
        return invalidMsgs;
    }

    private static List<String> validateVrmSlaveIpPwdInDoubleModePrams(InsParamVrmFo vrm, InsParamCnaFo cna) {
        LinkedList<String> invalidMsgs = new LinkedList<String>();
        if (ValidationUtils.isVrmDoubleMode(vrm)) {
            if (StringUtils.isEmpty((CharSequence)cna.getSlaveIp())) {
                invalidMsgs.add(ValidationUtils.getValidationString("vrm.cna.slaveIp"));
            }
            if (StringUtils.isEmpty((CharSequence)cna.getSlaveRootPwd())) {
                invalidMsgs.add(ValidationUtils.getValidationString("vrm.cna.slaveRootPwd"));
            }
            if (StringUtils.isEmpty((CharSequence)cna.getSlaveGandalfPwd())) {
                invalidMsgs.add(ValidationUtils.getValidationString("vrm.cna.slaveGandalfPwd"));
            }
            if (StringUtils.isEmpty((CharSequence)vrm.getSlaveName())) {
                invalidMsgs.add(ValidationUtils.getValidationString("vrm.vrm.slaveName"));
            }
            if (StringUtils.isEmpty((CharSequence)vrm.getSlaveIp())) {
                invalidMsgs.add(ValidationUtils.getValidationString("vrm.vrm.slaveIp"));
            }
            if (StringUtils.isEmpty((CharSequence)vrm.getFloatIp())) {
                invalidMsgs.add(ValidationUtils.getValidationString("vrm.vrm.floatIp"));
            }
        }
        return invalidMsgs;
    }

    private static List<String> validateVrmMasterIpPwdInSingleModeParams(InsParamVrmFo vrm, InsParamCnaFo cna) {
        LinkedList<String> invalidMsgs = new LinkedList<String>();
        if (StringUtils.isEmpty((CharSequence)cna.getMasterIp())) {
            invalidMsgs.add(ValidationUtils.getValidationString("vrm.cna.masterIp"));
        }
        if (StringUtils.isEmpty((CharSequence)cna.getMasterRootPwd())) {
            invalidMsgs.add(ValidationUtils.getValidationString("vrm.cna.masterRootPwd"));
        }
        if (StringUtils.isEmpty((CharSequence)cna.getMasterGandalfPwd())) {
            invalidMsgs.add(ValidationUtils.getValidationString("vrm.cna.masterGandalfPwd"));
        }
        if (StringUtils.isEmpty((CharSequence)vrm.getMasterName())) {
            invalidMsgs.add(ValidationUtils.getValidationString("vrm.vrm.masterName"));
        }
        if (StringUtils.isEmpty((CharSequence)vrm.getMasterIp())) {
            invalidMsgs.add(ValidationUtils.getValidationString("vrm.vrm.masterIp"));
        }
        return invalidMsgs;
    }

    private static List<String> validateVrmMustParams(VrmInstallParamsFo vrmParams) {
        LinkedList<String> invalidMsgs = new LinkedList<String>();
        InsParamVrmFo vrm = vrmParams.getVrm();
        invalidMsgs.addAll(ValidationUtils.validateVrmUserModeParams(vrmParams, vrm));
        invalidMsgs.addAll(ValidationUtils.validateVrmUserModeParams(vrm));
        invalidMsgs.addAll(ValidationUtils.validateVrmSizeModeParams(vrmParams));
        if (invalidMsgs.isEmpty()) {
            return Collections.emptyList();
        }
        String invalidMsg = StringUtils.formatTxt((String)ValidationUtils.getValidationString("error.validation.not_allow_empty"), (Object[])new Object[]{String.join((CharSequence)",", invalidMsgs)});
        return Collections.singletonList(invalidMsg);
    }

    private static List<String> validateCnaMustParams(DeployArch arch, CnaInstallParamsFo cnaParams) {
        LinkedList<String> invalidMsgs = new LinkedList<String>();
        invalidMsgs.addAll(ValidationUtils.validateCnaMustMasterNode(cnaParams));
        invalidMsgs.addAll(ValidationUtils.validateCnaMustManageNode(cnaParams));
        invalidMsgs.addAll(ValidationUtils.validateCnaMustDhcpConstrains(cnaParams));
        invalidMsgs.addAll(ValidationUtils.validateCnaSoftRaidParams(arch, cnaParams));
        return invalidMsgs;
    }

    private static List<String> validateCnaSoftRaidParams(DeployArch arch, CnaInstallParamsFo cnaParams) {
        if (arch == DeployArch.X86 && cnaParams.isSoftRaid()) {
            return Collections.singletonList(ValidationUtils.getValidationString("error.validation.arch_x86_soft_raid_invalid"));
        }
        return Collections.emptyList();
    }

    private static List<String> validateCnaMustDhcpConstrains(CnaInstallParamsFo cnaParams) {
        if (cnaParams.getDhcp().getSize() < cnaParams.getNodes().size() * 2) {
            return Collections.singletonList(ValidationUtils.getValidationString("error.validation.dhcp_size_lower_node_size"));
        }
        return Collections.emptyList();
    }

    private static Set<String> validateCnaMustManageNode(CnaInstallParamsFo cnaParams) {
        if (cnaParams == null || cnaParams.getNodes() == null) {
            return Collections.emptySet();
        }
        return cnaParams.getNodes().parallelStream().filter(InsParamNodeFo::isManageNode).filter(node -> !StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{node.getHostIp(), node.getGateway(), node.getNetmask()})).map(node -> ValidationUtils.getValidationString("error.validation.master_node_must_host_info")).collect(Collectors.toSet());
    }

    private static List<String> validateCnaMustMasterNode(CnaInstallParamsFo cnaParams) {
        if (cnaParams == null || cnaParams.getNodes() == null) {
            log.error("cna param is empty.");
            return Collections.emptyList();
        }
        LinkedList<String> invalidMsgs = new LinkedList<String>();
        List nodeFos = cnaParams.getNodes().parallelStream().filter(InsParamNodeFo::isMaster).collect(Collectors.toList());
        if (nodeFos.size() != 1) {
            invalidMsgs.add(ValidationUtils.getValidationString("error.validation.master_node_only_one"));
        } else {
            InsParamNodeFo nodeFo = (InsParamNodeFo)nodeFos.get(0);
            if (StringUtils.isEmpty((CharSequence)nodeFo.getEthName())) {
                invalidMsgs.add(ValidationUtils.getValidationString("error.validation.master_eth_name_not_empty"));
            }
        }
        return invalidMsgs;
    }

    public static List<String> validateParamInFillParam(String taskId, DeployArch arch, VrmInstallParamsFo vrmParams, CnaInstallParamsFo cnaParams) {
        LinkedList<IpItem> shouldReachableIps = new LinkedList<IpItem>();
        LinkedList<IpItem> shouldUnreachableIps = new LinkedList<IpItem>();
        Optional.ofNullable(vrmParams.getCna()).ifPresent(cnaFo -> shouldUnreachableIps.addAll(Arrays.asList(IpItem.createByResKey(cnaFo.getMasterIp(), "vrm.cna.masterIp"), IpItem.createByResKey(cnaFo.getSlaveIp(), "vrm.cna.slaveIp"))));
        List<String> validateResults = ValidationUtils.buildValidateResults(taskId, shouldReachableIps, shouldUnreachableIps);
        log.info("validate params, check ip reachable={}, unreachable={}.", shouldReachableIps, shouldUnreachableIps);
        validateResults.addAll(ValidationUtils.classifyVrmIpReachableStatus(taskId, vrmParams));
        log.info("validate params, classify Vrm Ip Reachable Status.");
        validateResults.addAll(ValidationUtils.classifyCnaIpReachableStatus(taskId, cnaParams));
        log.info("validate params, classify Cna Ip Reachable Status.");
        validateResults.addAll(ValidationUtils.validateCnaMustParams(arch, cnaParams));
        log.info("validate params, validate Cna Must Params.");
        validateResults.addAll(ValidationUtils.validateCnaParamRepeated(cnaParams));
        log.info("validate params, validate Cna Param Repeated.");
        validateResults.addAll(ValidationUtils.validateVrmMustParams(vrmParams));
        log.info("validate params, validate Vrm Must Params.");
        validateResults.addAll(ValidationUtils.validateVrmParamRepeated(vrmParams, cnaParams));
        log.info("validate params, validate Vrm Param Repeated.");
        validateResults.addAll(ValidationUtils.validateVrmManageIpIsInCnaList(vrmParams, cnaParams));
        log.info("validate params, validate Vrm ManageIp Is InCnaList.");
        validateResults.addAll(ValidationUtils.validateContainerCipherModeStatus(vrmParams, cnaParams));
        log.info("validate params, validate Container CipherMode.");
        validateResults.addAll(ValidationUtils.validateVrmRegistrySizeValue(vrmParams));
        log.info("validate params, validate Vrm Registry Size Value.");
        validateResults.addAll(ValidationUtils.validateVrmHsmParamsValid(vrmParams));
        log.info("validate params, validate Vrm Hsm Params.");
        validateResults.addAll(ValidationUtils.validateNtpParams(vrmParams));
        log.info("validate params, validate Ntp Params.");
        validateResults.addAll(ValidationUtils.validateBackupParams(vrmParams));
        log.info("validate params, validate Backup Params.");
        validateResults.addAll(ValidationUtils.validateDomesticEncryptionParams(vrmParams));
        log.info("validate params, validate Domestic encryption  Params.");
        return validateResults;
    }

    private static List<String> validateDomesticEncryptionParams(VrmInstallParamsFo vrmParams) {
        if ("sm".equals(vrmParams.getVrm().getCipherMode()) && vrmParams.getVrm().isEnableHsm()) {
            return ValidDomesticEncryptionHsm.validDomesticEncryptionFile(vrmParams.getVrm());
        }
        return Collections.emptyList();
    }

    private static List<String> validateContainerCipherModeStatus(VrmInstallParamsFo vrmParams, CnaInstallParamsFo cnaParams) {
        if (vrmParams == null || vrmParams.getVrm() == null) {
            return Collections.emptyList();
        }
        ArrayList<String> validateResults = new ArrayList<String>();
        InsParamVrmFo paramsVrm = vrmParams.getVrm();
        if (paramsVrm.isEnableKrm() && ValidationUtils.isCipherModeSm(paramsVrm)) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.fc_container_cipher_mode_double_open"));
        }
        if (paramsVrm.isEnableKrm() && Objects.equals("single", paramsVrm.getMode())) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.fc_container_install_scene_single"));
        }
        if (cnaParams != null && !Objects.equals(cnaParams.getCipherMode(), paramsVrm.getCipherMode())) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.fc_cipher_mode_diff_in_cna_vrm"));
        }
        return validateResults;
    }

    private static List<String> validateVrmRegistrySizeValue(VrmInstallParamsFo vrmParams) {
        InsParamSizeFo sizeFo = vrmParams.getSize();
        InsParamVrmFo vrmFo = vrmParams.getVrm();
        if (sizeFo == null || vrmFo == null || sizeFo.getRegistrySizeGb() == null || !vrmFo.isEnableKrm()) {
            return Collections.emptyList();
        }
        ArrayList<String> validateResults = new ArrayList<String>();
        if (Objects.equals(sizeFo.getMode(), "normal") && Stream.of(10, 300).noneMatch(value -> value.equals(sizeFo.getRegistrySizeGb()))) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.fc_registry_size_invalid"));
        }
        if (Objects.equals(sizeFo.getMode(), "custom") && (sizeFo.getRegistrySizeGb() < 10 || sizeFo.getRegistrySizeGb() > 300)) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.fc_registry_size_invalid"));
        }
        return validateResults;
    }

    private static List<String> validateVrmHsmParamsValid(VrmInstallParamsFo vrmParams) {
        long invalidPortCounter;
        InsParamVrmFo vrmFo = vrmParams.getVrm();
        if (!ValidationUtils.isCipherModeSm(vrmFo) || !vrmFo.isEnableHsm()) {
            return Collections.emptyList();
        }
        ArrayList<String> validateResults = new ArrayList<String>();
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{vrmFo.getHsmCompany(), vrmFo.getHsmType()}) || !VALID_HSM_COMPANY_TYPES.containsKey(vrmFo.getHsmCompany()) || !VALID_HSM_COMPANY_TYPES.get(vrmFo.getHsmCompany()).contains(vrmFo.getHsmType())) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.fc_vrm_hsm_company_type_invalid"));
        }
        if (Objects.equals(vrmFo.getHsmCompany(), "Westone") && StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{vrmFo.getHsmIp(), vrmFo.getHsmServicePwd()})) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.fc_vrm_hsm_param_invalid"));
        }
        if (Objects.equals(vrmFo.getHsmCompany(), "Sansec") && StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{vrmFo.getHsmIp(), vrmFo.getHsmAccount(), vrmFo.getHsmPwd(), vrmFo.getHsmServicePwd()})) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.fc_vrm_hsm_param_invalid"));
        }
        if ((invalidPortCounter = Stream.of(vrmFo.getHsmPort(), vrmFo.getHsm02Port()).filter(StringUtils::isNotEmpty).filter(port -> NumberUtils.parseInt((String)port, (int)0) < 1 || NumberUtils.parseInt((String)port, (int)0) > 65535).count()) > 0L) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.fc_vrm_hsm_port_invalid"));
        }
        return validateResults;
    }

    private static List<String> validateVrmManageIpIsInCnaList(VrmInstallParamsFo vrmParams, CnaInstallParamsFo cnaParams) {
        InsParamCnaFo vrmParamsCna = vrmParams.getCna();
        List<InsParamNodeFo> cnaNodes = cnaParams.getNodes();
        if (vrmParamsCna == null || vrmParams.getVrm() == null || cnaNodes == null || cnaNodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> validateResults = new ArrayList<String>();
        boolean isDoubleMode = ValidationUtils.isVrmDoubleMode(vrmParams.getVrm());
        if (!ValidationUtils.isFindVrmManageIpInCnaList(vrmParamsCna.getMasterIp(), cnaNodes)) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.vrm_host_master_ip_not_exist_cna_list"));
        }
        if (isDoubleMode && !ValidationUtils.isFindVrmManageIpInCnaList(vrmParamsCna.getSlaveIp(), cnaNodes)) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.vrm_host_slave_ip_not_exist_cna_list"));
        }
        if (!Objects.equals(cnaParams.getGandalfPwd(), vrmParamsCna.getMasterGandalfPwd()) || isDoubleMode && !Objects.equals(cnaParams.getGandalfPwd(), vrmParamsCna.getSlaveGandalfPwd())) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.vrm_host_slave_gandalf_pwd_not_same_cna"));
        }
        if (!Objects.equals(cnaParams.getRootPwd(), vrmParamsCna.getMasterRootPwd()) || isDoubleMode && !Objects.equals(cnaParams.getRootPwd(), vrmParamsCna.getSlaveRootPwd())) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.vrm_host_slave_root_pwd_not_same_cna"));
        }
        return validateResults;
    }

    private static boolean isFindVrmManageIpInCnaList(String manageIp, List<InsParamNodeFo> cnaNodes) {
        if (StringUtils.isEmpty((CharSequence)manageIp)) {
            log.error("manage ip is empty.");
            return false;
        }
        return cnaNodes.parallelStream().filter(InsParamNodeFo::isManageNode).map(InsParamNodeFo::getHostIp).filter(StringUtils::isNotEmpty).anyMatch(hostIp -> Objects.equals(hostIp, manageIp));
    }

    public static List<String> validateParamInDeployVrm(String taskId, DeployArch arch, VrmInstallParamsFo vrmParams) {
        LinkedList<IpItem> shouldReachableIps = new LinkedList<IpItem>();
        LinkedList<IpItem> shouldUnreachableIps = new LinkedList<IpItem>();
        Optional.ofNullable(vrmParams.getCna()).ifPresent(cnaFo -> shouldReachableIps.addAll(Arrays.asList(IpItem.createByResKey(cnaFo.getMasterIp(), "vrm.cna.masterIp"), IpItem.createByResKey(cnaFo.getSlaveIp(), "vrm.cna.slaveIp"))));
        List<String> validateResults = ValidationUtils.buildValidateResults(taskId, shouldReachableIps, shouldUnreachableIps);
        log.info("validate vrm, check ip reachable={}, unreachable={}.", shouldReachableIps, shouldUnreachableIps);
        validateResults.addAll(ValidationUtils.classifyVrmIpReachableStatus(taskId, vrmParams));
        log.info("validate vrm, classify Vrm Ip Reachable Status.");
        validateResults.addAll(ValidationUtils.validateVrmMustParams(vrmParams));
        log.info("validate vrm, validate Vrm Must Params.");
        validateResults.addAll(ValidationUtils.validateVrmParamRepeated(vrmParams, null));
        log.info("validate vrm, validate Vrm Param Repeated.");
        validateResults.addAll(ValidationUtils.validateContainerCipherModeStatus(vrmParams, null));
        log.info("validate vrm, validate Container CipherMode.");
        validateResults.addAll(ValidationUtils.validateVrmRegistrySizeValue(vrmParams));
        log.info("validate vrm, validate Vrm Registry Size Value.");
        validateResults.addAll(ValidationUtils.validateVrmHsmParamsValid(vrmParams));
        log.info("validate vrm, validate Vrm Hsm Params.");
        validateResults.addAll(ValidationUtils.validateNtpParams(vrmParams));
        log.info("validate params, validate Ntp Params.");
        validateResults.addAll(ValidationUtils.validateBackupParams(vrmParams));
        log.info("validate params, validate Backup Params.");
        validateResults.addAll(ValidationUtils.validateDomesticEncryptionParams(vrmParams));
        log.info("validate params, validate Domestic encryption  Params.");
        return validateResults;
    }

    private static List<String> validateNtpParams(VrmInstallParamsFo vrmParams) {
        InsParamNtpFo ntpFo = vrmParams.getNtp();
        if (ntpFo == null || !ntpFo.isConfigNtp()) {
            return Collections.emptyList();
        }
        ArrayList<String> validateResults = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)ntpFo.getNtpIp1())) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.fc_vrm_ntp_ip_is_empty"));
        }
        if (!VALID_SYNC_PERIODS.contains(ntpFo.getSyncPeriod())) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.fc_vrm_ntp_sync_period_invalid"));
        }
        return validateResults;
    }

    private static List<String> validateBackupParams(VrmInstallParamsFo vrmParams) {
        InsParamBackupFo backupFo = vrmParams.getBackup();
        if (backupFo == null || !backupFo.isConfigBackup()) {
            return Collections.emptyList();
        }
        if (Objects.equals("host", backupFo.getBackupType()) && CollectionUtils.isEmpty(backupFo.getBackupCnaNames())) {
            return Collections.singletonList(ValidationUtils.getValidationString("error.validation.fc_vrm_backup_cna_names_is_empty"));
        }
        if (!Objects.equals("third", backupFo.getBackupType())) {
            return Collections.emptyList();
        }
        ArrayList<String> validateResults = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)backupFo.getFtpIpAddr())) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.fc_vrm_backup_ftp_ip_empty"));
        }
        if (StringUtils.isEmpty((CharSequence)backupFo.getFtpPassword())) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.fc_vrm_backup_ftp_password_empty"));
        }
        return validateResults;
    }

    private static List<String> validateVrmParamRepeated(VrmInstallParamsFo vrmParams, CnaInstallParamsFo cnaParams) {
        ArrayList<String> validateResults = new ArrayList<String>();
        InsParamCnaFo cna = vrmParams.getCna();
        if (StringUtils.isNotEmpty((CharSequence)cna.getMasterIp()) && Objects.equals(cna.getMasterIp(), cna.getSlaveIp())) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.master_slave_ip_repeated"));
        }
        InsParamVrmFo vrm = vrmParams.getVrm();
        validateResults.addAll(ValidationUtils.checkVrmMasterSlaveIpRepeatedInVrm(vrm));
        validateResults.addAll(ValidationUtils.checkCnaMasterSlaveManageIpRepeatedInVrm(cna, vrm));
        validateResults.addAll(ValidationUtils.checkFloatIpRepeatedInCnaList(cnaParams, vrm));
        validateResults.addAll(ValidationUtils.checkVrmMasterSlaveIpRepeatedInCnaList(cnaParams, vrm));
        validateResults.addAll(ValidationUtils.checkHsmManageIpRepeatedInCnaList(cnaParams, vrm));
        return validateResults;
    }

    private static List<String> checkVrmMasterSlaveIpRepeatedInVrm(InsParamVrmFo vrm) {
        if (vrm == null) {
            return Collections.emptyList();
        }
        LinkedList<String> validateResults = new LinkedList<String>();
        boolean isDoubleMode = ValidationUtils.isVrmDoubleMode(vrm);
        if (ValidationUtils.checkIpRepeated(vrm.getMasterIp(), isDoubleMode ? vrm.getSlaveIp() : "", vrm.getArp01Ip(), vrm.getArp02Ip(), vrm.getArp03Ip())) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.vrm_master_ip_repeated_with_other"));
        }
        if (isDoubleMode && ValidationUtils.checkIpRepeated(vrm.getSlaveIp(), vrm.getArp01Ip(), vrm.getArp02Ip(), vrm.getArp03Ip())) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.vrm_slave_ip_repeated_with_other"));
        }
        if (isDoubleMode && ValidationUtils.checkIpRepeated(vrm.getFloatIp(), vrm.getMasterIp(), vrm.getSlaveIp(), vrm.getArp01Ip(), vrm.getArp02Ip(), vrm.getArp03Ip())) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.vrm_float_ip_repeated_with_other"));
        }
        if (ValidationUtils.isCipherModeSm(vrm)) {
            if (ValidationUtils.checkIpRepeated(vrm.getHsmIp(), vrm.getMasterIp(), vrm.getSlaveIp(), vrm.getFloatIp(), vrm.getArp01Ip(), vrm.getArp02Ip(), vrm.getArp03Ip())) {
                validateResults.add(ValidationUtils.getValidationString("error.validation.vrm_hsm_manage_ip1_repeated_with_other"));
            }
            if (ValidationUtils.checkIpRepeated(vrm.getHsm02Ip(), vrm.getMasterIp(), vrm.getSlaveIp(), vrm.getFloatIp(), vrm.getArp01Ip(), vrm.getArp02Ip(), vrm.getArp03Ip())) {
                validateResults.add(ValidationUtils.getValidationString("error.validation.vrm_hsm_manage_ip2_repeated_with_other"));
            }
            if (StringUtils.isNotEmpty((CharSequence)vrm.getHsmIp()) && Objects.equals(vrm.getHsmIp(), vrm.getHsm02Ip())) {
                validateResults.add(ValidationUtils.getValidationString("error.validation.vrm_hsm_manage_ip_repeated_with_self"));
            }
        }
        return validateResults;
    }

    private static List<String> checkCnaMasterSlaveManageIpRepeatedInVrm(InsParamCnaFo cna, InsParamVrmFo vrm) {
        if (cna == null || vrm == null) {
            return Collections.emptyList();
        }
        boolean isDoubleMode = ValidationUtils.isVrmDoubleMode(vrm);
        LinkedList<String> validateResults = new LinkedList<String>();
        if (ValidationUtils.checkIpRepeated(cna.getMasterIp(), vrm.getMasterIp(), isDoubleMode ? vrm.getSlaveIp() : "", ValidationUtils.isCipherModeSm(vrm) ? vrm.getHsmIp() : "", ValidationUtils.isCipherModeSm(vrm) ? vrm.getHsm02Ip() : "", isDoubleMode ? vrm.getFloatIp() : "", vrm.getArp01Ip(), vrm.getArp02Ip(), vrm.getArp03Ip())) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.vrm_cna_master_ip_repeated_with_other"));
        }
        if (isDoubleMode) {
            String[] stringArray = new String[8];
            stringArray[0] = vrm.getMasterIp();
            stringArray[1] = vrm.getSlaveIp();
            stringArray[2] = vrm.getFloatIp();
            stringArray[3] = vrm.getArp01Ip();
            stringArray[4] = vrm.getArp02Ip();
            stringArray[5] = vrm.getArp03Ip();
            stringArray[6] = ValidationUtils.isCipherModeSm(vrm) ? vrm.getHsmIp() : "";
            String string = stringArray[7] = ValidationUtils.isCipherModeSm(vrm) ? vrm.getHsm02Ip() : "";
            if (ValidationUtils.checkIpRepeated(cna.getSlaveIp(), stringArray)) {
                validateResults.add(ValidationUtils.getValidationString("error.validation.vrm_cna_slave_ip_repeated_with_other"));
            }
        }
        return validateResults;
    }

    private static List<String> checkVrmMasterSlaveIpRepeatedInCnaList(CnaInstallParamsFo cnaParams, InsParamVrmFo vrm) {
        if (cnaParams == null || cnaParams.getNodes() == null) {
            log.error("not find cna or cna nodes.");
            return Collections.emptyList();
        }
        LinkedList<String> validateResults = new LinkedList<String>();
        validateResults.addAll(ValidationUtils.checkVrmMasterSlaveIpRepeatedInCnaListBmcIp(cnaParams, vrm));
        validateResults.addAll(ValidationUtils.checkVrmMasterSlaveIpRepeatedInCnaListHostIp(cnaParams, vrm));
        return validateResults;
    }

    private static List<String> checkVrmMasterSlaveIpRepeatedInCnaListBmcIp(CnaInstallParamsFo cna, InsParamVrmFo vrm) {
        List<String> bmcIps = cna.getNodes().parallelStream().map(InsParamNodeFo::getBmcIp).collect(Collectors.toList());
        return ValidationUtils.checkVrmMasterSlaveIpRepeatedInCnaList(vrm, bmcIps, "error.validation.vrm_master_ip_repeated_with_cna_bmc_list", "error.validation.vrm_slave_ip_repeated_with_cna_bmc_list");
    }

    private static List<String> checkVrmMasterSlaveIpRepeatedInCnaListHostIp(CnaInstallParamsFo cna, InsParamVrmFo vrm) {
        List<String> hostIps = cna.getNodes().parallelStream().map(InsParamNodeFo::getHostIp).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        return ValidationUtils.checkVrmMasterSlaveIpRepeatedInCnaList(vrm, hostIps, "error.validation.vrm_master_ip_repeated_with_cna_host_list", "error.validation.vrm_slave_ip_repeated_with_cna_host_list");
    }

    private static List<String> checkVrmMasterSlaveIpRepeatedInCnaList(InsParamVrmFo vrm, List<String> cnaIpList, String masterIpRepeatedResKey, String slaveIpRepeatedResKey) {
        LinkedList<String> validateResults = new LinkedList<String>();
        if (ValidationUtils.checkIpRepeated(vrm.getMasterIp(), cnaIpList.toArray(new String[0]))) {
            validateResults.add(ValidationUtils.getValidationString(masterIpRepeatedResKey));
        }
        if (ValidationUtils.isVrmDoubleMode(vrm) && ValidationUtils.checkIpRepeated(vrm.getSlaveIp(), cnaIpList.toArray(new String[0]))) {
            validateResults.add(ValidationUtils.getValidationString(slaveIpRepeatedResKey));
        }
        return validateResults;
    }

    private static List<String> checkFloatIpRepeatedInCnaList(CnaInstallParamsFo cnaParams, InsParamVrmFo vrm) {
        if (!ValidationUtils.isVrmDoubleMode(vrm) || cnaParams == null || cnaParams.getNodes() == null) {
            log.error("not double mode or cna param is empty.");
            return Collections.emptyList();
        }
        LinkedList<String> validateResults = new LinkedList<String>();
        validateResults.addAll(ValidationUtils.checkFloatRepeatedInCnaListBmcIp(cnaParams, vrm));
        validateResults.addAll(ValidationUtils.checkFloatRepeatedInCnaListHostIp(cnaParams, vrm));
        return validateResults;
    }

    private static List<String> checkFloatRepeatedInCnaListHostIp(CnaInstallParamsFo cnaParams, InsParamVrmFo vrm) {
        Set<String> hostIps = cnaParams.getNodes().parallelStream().map(InsParamNodeFo::getHostIp).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        if (ValidationUtils.checkIpRepeated(vrm.getFloatIp(), hostIps.toArray(new String[0]))) {
            return Collections.singletonList(ValidationUtils.getValidationString("error.validation.vrm_float_ip_repeated_with_cna_host_list"));
        }
        return Collections.emptyList();
    }

    private static List<String> checkFloatRepeatedInCnaListBmcIp(CnaInstallParamsFo cnaParams, InsParamVrmFo vrm) {
        List<String> bmcIps = cnaParams.getNodes().parallelStream().map(InsParamNodeFo::getBmcIp).collect(Collectors.toList());
        if (ValidationUtils.checkIpRepeated(vrm.getFloatIp(), bmcIps.toArray(new String[0]))) {
            return Collections.singletonList(ValidationUtils.getValidationString("error.validation.vrm_float_ip_repeated_with_cna_bmc_list"));
        }
        return Collections.emptyList();
    }

    private static List<String> checkHsmManageIpRepeatedInCnaList(CnaInstallParamsFo cnaParams, InsParamVrmFo vrm) {
        if (cnaParams == null || cnaParams.getNodes() == null || !ValidationUtils.isCipherModeSm(vrm)) {
            log.error("not find cna or cna nodes or or not sm.");
            return Collections.emptyList();
        }
        LinkedList<String> validateResults = new LinkedList<String>();
        validateResults.addAll(ValidationUtils.checkHsmManageRepeatedInCnaListHostIp(cnaParams, vrm));
        validateResults.addAll(ValidationUtils.checkHsmManageRepeatedInCnaListBmcIp(cnaParams, vrm));
        return validateResults;
    }

    private static List<String> checkHsmManageRepeatedInCnaListHostIp(CnaInstallParamsFo cnaParams, InsParamVrmFo vrm) {
        String[] hostIps = (String[])cnaParams.getNodes().parallelStream().map(InsParamNodeFo::getHostIp).filter(StringUtils::isNotEmpty).distinct().toArray(String[]::new);
        if (ValidationUtils.checkIpRepeated(vrm.getHsmIp(), hostIps) || ValidationUtils.checkIpRepeated(vrm.getHsm02Ip(), hostIps)) {
            return Collections.singletonList(ValidationUtils.getValidationString("error.validation.vrm_hsm_manage_ip_repeated_with_cna_host_list"));
        }
        return Collections.emptyList();
    }

    private static List<String> checkHsmManageRepeatedInCnaListBmcIp(CnaInstallParamsFo cnaParams, InsParamVrmFo vrm) {
        String[] bmcIps = (String[])cnaParams.getNodes().parallelStream().map(InsParamNodeFo::getBmcIp).distinct().toArray(String[]::new);
        if (ValidationUtils.checkIpRepeated(vrm.getHsmIp(), bmcIps) || ValidationUtils.checkIpRepeated(vrm.getHsm02Ip(), bmcIps)) {
            return Collections.singletonList(ValidationUtils.getValidationString("error.validation.vrm_hsm_manage_ip_repeated_with_cna_bmc_list"));
        }
        return Collections.emptyList();
    }

    private static List<String> validateCnaParamRepeated(CnaInstallParamsFo cnaParams) {
        List<InsParamNodeFo> nodeFos = cnaParams.getNodes();
        if (nodeFos == null || nodeFos.isEmpty()) {
            log.error("cna node is empty.");
            return Collections.emptyList();
        }
        ArrayList<String> validateResults = new ArrayList<String>();
        validateResults.addAll(ValidationUtils.validateCnaParamHostBmcIpRepeated(nodeFos));
        validateResults.addAll(ValidationUtils.validateCnaParamHostNameRepeated(nodeFos));
        validateResults.addAll(ValidationUtils.validateCnaParamHostMacAddrRepeated(nodeFos));
        return validateResults;
    }

    private static List<String> validateCnaParamHostMacAddrRepeated(List<InsParamNodeFo> nodeFos) {
        List<String> hostMacs = nodeFos.parallelStream().map(InsParamNodeFo::getHostMac).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        if (ValidationUtils.checkCollectionElementRepeated(hostMacs)) {
            return Collections.singletonList(ValidationUtils.getValidationString("error.validation.cna_host_mac_exist_repeat"));
        }
        return Collections.emptyList();
    }

    private static List<String> validateCnaParamHostNameRepeated(List<InsParamNodeFo> nodeFos) {
        List<String> hostNames = nodeFos.parallelStream().map(InsParamNodeFo::getHostName).collect(Collectors.toList());
        if (ValidationUtils.checkCollectionElementRepeated(hostNames)) {
            return Collections.singletonList(ValidationUtils.getValidationString("error.validation.cna_host_name_exist_repeat"));
        }
        return Collections.emptyList();
    }

    private static List<String> validateCnaParamHostBmcIpRepeated(List<InsParamNodeFo> nodeFos) {
        List<String> hostIps;
        LinkedList<String> validateResults = new LinkedList<String>();
        List<String> bmcIps = nodeFos.parallelStream().map(InsParamNodeFo::getBmcIp).collect(Collectors.toList());
        if (ValidationUtils.checkCollectionElementRepeated(bmcIps)) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.bmc_ip_exist_repeat"));
        }
        if (ValidationUtils.checkCollectionElementRepeated(hostIps = nodeFos.parallelStream().map(InsParamNodeFo::getHostIp).filter(StringUtils::isNotEmpty).collect(Collectors.toList()))) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.host_ip_exist_repeat"));
        }
        HashSet<String> bmcIpSets = new HashSet<String>(bmcIps);
        HashSet<String> hostIpSets = new HashSet<String>(hostIps);
        HashSet<String> allIpSets = new HashSet<String>(bmcIpSets);
        allIpSets.addAll(hostIpSets);
        if (bmcIpSets.size() + hostIpSets.size() != allIpSets.size()) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.bmc_host_ip_exist_repeat"));
        }
        return validateResults;
    }

    public static List<String> validateParamInDeployCna(String taskId, DeployArch arch, CnaInstallParamsFo cnaParams) {
        List<String> validateResults = ValidationUtils.classifyCnaIpReachableStatus(taskId, cnaParams);
        log.info("validate cna, classify Cna Ip Reachable Status.");
        validateResults.addAll(ValidationUtils.validateCnaMustParams(arch, cnaParams));
        log.info("validate cna, validate Cna Must Params.");
        validateResults.addAll(ValidationUtils.validateCnaParamRepeated(cnaParams));
        log.info("validate cna, validate Cna Param Repeated.");
        return validateResults;
    }

    private static List<String> classifyCnaIpReachableStatus(String taskId, CnaInstallParamsFo cnaParams) {
        LinkedList<IpItem> shouldReachableIps = new LinkedList<IpItem>();
        LinkedList<IpItem> shouldUnreachableIps = new LinkedList<IpItem>();
        Optional.ofNullable(cnaParams.getDhcp()).ifPresent(dhcpFo -> {
            shouldUnreachableIps.add(IpItem.createByResKey(dhcpFo.getStart(), "cna.dhcp.start"));
            shouldReachableIps.add(IpItem.createByResKey(dhcpFo.getGateway(), "cna.dhcp.gateway"));
        });
        List<InsParamNodeFo> nodeFos = cnaParams.getNodes();
        if (nodeFos != null && !nodeFos.isEmpty()) {
            shouldReachableIps.addAll(nodeFos.parallelStream().filter(node -> Objects.nonNull(node.getBmcIp())).map(node -> IpItem.createByName(node.getBmcIp(), node.getHostName())).collect(Collectors.toList()));
            shouldReachableIps.addAll(nodeFos.parallelStream().filter(node -> Objects.nonNull(node.getGateway())).map(node -> IpItem.createByName(node.getGateway(), node.getHostName())).collect(Collectors.toList()));
            shouldUnreachableIps.addAll(nodeFos.parallelStream().filter(node -> Objects.nonNull(node.getHostIp())).map(node -> IpItem.createByName(node.getHostIp(), node.getHostName())).collect(Collectors.toList()));
        }
        return ValidationUtils.buildValidateResults(taskId, shouldReachableIps, shouldUnreachableIps);
    }

    private static List<String> classifyVrmIpReachableStatus(String taskId, VrmInstallParamsFo vrmParams) {
        LinkedList<IpItem> shouldReachableIps = new LinkedList<IpItem>();
        LinkedList<IpItem> shouldUnreachableIps = new LinkedList<IpItem>();
        Optional.ofNullable(vrmParams.getVrm()).ifPresent(vrmFo -> {
            shouldReachableIps.addAll(Arrays.asList(IpItem.createByResKey(vrmFo.getGateway(), "vrm.vrm.gateway"), IpItem.createByResKey(ValidationUtils.isCipherModeSm(vrmFo) ? vrmFo.getHsmIp() : "", "vrm.vrm.hsmIp"), IpItem.createByResKey(ValidationUtils.isCipherModeSm(vrmFo) ? vrmFo.getHsm02Ip() : "", "vrm.vrm.hsm02Ip"), IpItem.createByResKey(vrmFo.getArp01Ip(), "vrm.vrm.arp01Ip"), IpItem.createByResKey(vrmFo.getArp02Ip(), "vrm.vrm.arp02Ip"), IpItem.createByResKey(vrmFo.getArp03Ip(), "vrm.vrm.arp03Ip")));
            shouldUnreachableIps.addAll(Arrays.asList(IpItem.createByResKey(vrmFo.getFloatIp(), "vrm.vrm.floatIp"), IpItem.createByResKey(vrmFo.getMasterIp(), "vrm.vrm.masterIp"), IpItem.createByResKey(vrmFo.getSlaveIp(), "vrm.vrm.slaveIp")));
        });
        return ValidationUtils.buildValidateResults(taskId, shouldReachableIps, shouldUnreachableIps);
    }

    private static List<String> buildValidateResults(String taskId, List<IpItem> shouldReachableIps, List<IpItem> shouldUnreachableIps) {
        HashSet<String> results = new HashSet<String>();
        String invalidDesc = ValidationUtils.checkIpReachableStatu(shouldReachableIps, item -> !IpUtils.isReachable((String)((IpItem)item).ip), "error.validation.ip.not.reachable");
        results.add(invalidDesc);
        if (!DeployTaskManager.getManager().isTaskExecuted(taskId)) {
            log.info("create fc param to validate reachable, taskId={}.", (Object)taskId);
            invalidDesc = ValidationUtils.checkIpReachableStatu(shouldUnreachableIps, item -> IpUtils.isReachable((String)((IpItem)item).ip), "error.validation.ip.can.reachable");
            results.add(invalidDesc);
        }
        return results.parallelStream().filter(StringUtils::isNotEmpty).collect(Collectors.toList());
    }

    private static String checkIpReachableStatu(List<IpItem> ips, Predicate<IpItem> checker, String resInvalidKey) {
        String invalidIps = ips.parallelStream().filter(item -> IpUtils.isValidIpV4((String)((IpItem)item).ip)).filter(checker).map(item -> StringUtils.formatTxt((String)"%s(%s)", (Object[])new Object[]{((IpItem)item).name, ((IpItem)item).ip})).collect(Collectors.joining(","));
        if (StringUtils.isNotEmpty((CharSequence)invalidIps)) {
            return StringUtils.formatTxt((String)ValidationUtils.getValidationString(resInvalidKey), (Object[])new Object[]{invalidIps});
        }
        return "";
    }

    public static List<String> validateFcParamsRepeated(List<FcInstallParamsFo> paramsFos) {
        if (paramsFos == null || paramsFos.isEmpty()) {
            log.error("fc install param is empty.");
            return Collections.emptyList();
        }
        List<InsParamNodeFo> nodeFos = paramsFos.parallelStream().map(FcInstallParamsFo::getCna).filter(Objects::nonNull).filter(cnaParam -> Objects.nonNull(cnaParam.getNodes())).flatMap(cnaParam -> cnaParam.getNodes().parallelStream()).collect(Collectors.toList());
        LinkedList<String> validateResults = new LinkedList<String>();
        validateResults.addAll(ValidationUtils.checkHostBmcIpRepeatedInMultiFcParams(nodeFos));
        validateResults.addAll(ValidationUtils.checkHostMacAddrRepeatedInMultiFcParams(nodeFos));
        List<InsParamVrmFo> vrmFos = paramsFos.parallelStream().map(FcInstallParamsFo::getVrm).filter(Objects::nonNull).map(VrmInstallParamsFo::getVrm).filter(Objects::nonNull).collect(Collectors.toList());
        validateResults.addAll(ValidationUtils.checkVrmMasterIpRepeatedInMultiFcParams(vrmFos));
        validateResults.addAll(ValidationUtils.checkFloatIpRepeatedInMultiFcParams(vrmFos));
        validateResults.addAll(ValidationUtils.checkVrmSlaveIpRepeatedInMultiFcParams(vrmFos));
        validateResults.addAll(ValidationUtils.checkVrmAllIpRepeatedInMultiFcParams(vrmFos));
        validateResults.addAll(ValidationUtils.checkTaskIdRepeatedInMultiFcParams(paramsFos));
        return validateResults;
    }

    private static List<String> checkHostBmcIpRepeatedInMultiFcParams(List<InsParamNodeFo> nodeFos) {
        List<String> hostIps;
        LinkedList<String> validateResults = new LinkedList<String>();
        List<String> bmcIps = nodeFos.parallelStream().map(InsParamNodeFo::getBmcIp).collect(Collectors.toList());
        if (ValidationUtils.checkCollectionElementRepeated(bmcIps)) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.fc_bmc_ip_repeated_with_other"));
        }
        if (ValidationUtils.checkCollectionElementRepeated(hostIps = nodeFos.parallelStream().map(InsParamNodeFo::getHostIp).filter(StringUtils::isNotEmpty).collect(Collectors.toList()))) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.fc_host_ip_repeated_with_other"));
        }
        HashSet<String> bmcIpSets = new HashSet<String>(bmcIps);
        HashSet<String> hostIpSets = new HashSet<String>(hostIps);
        LinkedList<String> allCnaIps = new LinkedList<String>(bmcIpSets);
        allCnaIps.addAll(hostIpSets);
        if (bmcIpSets.size() + hostIpSets.size() != allCnaIps.size()) {
            validateResults.add(ValidationUtils.getValidationString("error.validation.fc_host_bmc_ip_repeated_with_other"));
        }
        return validateResults;
    }

    private static List<String> checkHostMacAddrRepeatedInMultiFcParams(List<InsParamNodeFo> nodeFos) {
        List<String> macAddr = nodeFos.parallelStream().map(InsParamNodeFo::getHostMac).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        if (ValidationUtils.checkCollectionElementRepeated(macAddr)) {
            return Collections.singletonList(ValidationUtils.getValidationString("error.validation.fc_mac_repeated_with_other"));
        }
        return Collections.emptyList();
    }

    private static List<String> checkTaskIdRepeatedInMultiFcParams(List<FcInstallParamsFo> paramsFos) {
        List<String> taskIds = paramsFos.parallelStream().map(FcInstallParamsFo::getName).collect(Collectors.toList());
        if (ValidationUtils.checkCollectionElementRepeated(taskIds)) {
            return Collections.singletonList(ValidationUtils.getValidationString("error.validation.fc_name_repeated_with_other"));
        }
        return Collections.emptyList();
    }

    private static List<String> checkFloatIpRepeatedInMultiFcParams(List<InsParamVrmFo> vrmFos) {
        List<String> floatIps = vrmFos.parallelStream().filter(ValidationUtils::isVrmDoubleMode).map(InsParamVrmFo::getFloatIp).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        if (ValidationUtils.checkCollectionElementRepeated(floatIps)) {
            return Collections.singletonList(ValidationUtils.getValidationString("error.validation.fc_float_ip_repeated_with_other"));
        }
        return Collections.emptyList();
    }

    private static List<String> checkVrmMasterIpRepeatedInMultiFcParams(List<InsParamVrmFo> vrmFos) {
        List<String> masterIps = vrmFos.parallelStream().map(InsParamVrmFo::getMasterIp).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        if (ValidationUtils.checkCollectionElementRepeated(masterIps)) {
            return Collections.singletonList(ValidationUtils.getValidationString("error.validation.fc_vrm_master_ip_repeated_with_other"));
        }
        return Collections.emptyList();
    }

    private static List<String> checkVrmSlaveIpRepeatedInMultiFcParams(List<InsParamVrmFo> vrmFos) {
        List<String> slaveIps = vrmFos.parallelStream().filter(ValidationUtils::isVrmDoubleMode).map(InsParamVrmFo::getSlaveIp).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        if (ValidationUtils.checkCollectionElementRepeated(slaveIps)) {
            return Collections.singletonList(ValidationUtils.getValidationString("error.validation.fc_vrm_slave_ip_repeated_with_other"));
        }
        return Collections.emptyList();
    }

    private static List<String> checkVrmAllIpRepeatedInMultiFcParams(List<InsParamVrmFo> vrmFos) {
        LinkedList<String> allIpList = new LinkedList<String>();
        for (InsParamVrmFo vrmFo : vrmFos) {
            allIpList.add(vrmFo.getMasterIp());
            if (!ValidationUtils.isVrmDoubleMode(vrmFo)) continue;
            allIpList.add(vrmFo.getSlaveIp());
            allIpList.add(vrmFo.getFloatIp());
        }
        if (ValidationUtils.checkCollectionElementRepeated(allIpList)) {
            return Collections.singletonList(ValidationUtils.getValidationString("error.validation.fc_master_slave_float_ip_repeated_with_other"));
        }
        return Collections.emptyList();
    }

    private static boolean checkCollectionElementRepeated(Collection<String> collection) {
        return collection.size() != new HashSet<String>(collection).size();
    }

    private static boolean isVrmDoubleMode(InsParamVrmFo vrmFo) {
        return vrmFo != null && Objects.equals("double", vrmFo.getMode());
    }

    private static boolean isCipherModeSm(InsParamVrmFo vrmFo) {
        return vrmFo != null && Objects.equals(vrmFo.getCipherMode(), "sm");
    }

    @Generated
    private ValidationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class IpItem {
        private String ip;
        private String name;

        static IpItem createByName(String ip, String name) {
            return new IpItem(ip, name);
        }

        static IpItem createByResKey(String ip, String resKey) {
            return new IpItem(ip, ValidationUtils.getValidationString(resKey));
        }

        @Generated
        private IpItem(String ip, String name) {
            this.ip = ip;
            this.name = name;
        }
    }
}

