/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.config;

import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.ParamConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.VrmInstallCnaBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.VrmInstallSizeBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.VrmInstallVrmBo;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigVrmInfo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigVrmInfo.class);
    @JSONField(name="type")
    private String type;
    @JSONField(name="cna")
    private CnaParam cna;
    @JSONField(name="vrm")
    private VrmParam vrm;
    @JSONField(name="size")
    private SizeParam size;
    @JSONField(name="other")
    private PatchParam other;

    public void overrideCna(VrmInstallCnaBo insCna, Map<String, String> passwords) {
        if (this.cna == null) {
            this.cna = new CnaParam();
        }
        this.cna.setMasterIp(StringUtils.defaultString((String)insCna.getMasterIp()));
        this.cna.setMasterGandalfPassword(passwords.getOrDefault(insCna.getMasterGandalfPwd(), ""));
        this.cna.setMasterRootPassword(passwords.getOrDefault(insCna.getMasterRootPwd(), ""));
        this.cna.setSlaveIp(StringUtils.defaultString((String)insCna.getSlaveIp()));
        this.cna.setSlaveGandalfPassword(passwords.getOrDefault(insCna.getSlaveGandalfPwd(), ""));
        this.cna.setSlaveRootPassword(passwords.getOrDefault(insCna.getSlaveRootPwd(), ""));
    }

    public void overrideVrm(VrmInstallVrmBo insVrm, Map<String, String> passwords) {
        if (this.vrm == null) {
            this.vrm = new VrmParam();
        }
        insVrm.clearHsmParam();
        this.vrm.setMode(StringUtils.defaultString((String)insVrm.getMode()));
        this.vrm.setCipherMode(StringUtils.defaultString((String)insVrm.getCipherMode(), (String)"general"));
        this.vrm.setFloatIp(StringUtils.defaultString((String)insVrm.getFloatIp()));
        this.vrm.setMasterIp(StringUtils.defaultString((String)insVrm.getMasterIp()));
        this.vrm.setMasterName(StringUtils.defaultString((String)insVrm.getMasterName(), (String)"VRM01"));
        this.vrm.setSlaveIp(StringUtils.defaultString((String)insVrm.getSlaveIp()));
        this.vrm.setSlaveName(StringUtils.defaultString((String)insVrm.getSlaveName(), (String)"VRM02"));
        this.vrm.setNetmask(StringUtils.defaultString((String)insVrm.getNetmask()));
        this.vrm.setGateway(StringUtils.defaultString((String)insVrm.getGateway()));
        this.vrm.setArp01Ip(StringUtils.defaultString((String)insVrm.getArp01Ip()));
        this.vrm.setArp02Ip(StringUtils.defaultString((String)insVrm.getArp02Ip()));
        this.vrm.setArp03Ip(StringUtils.defaultString((String)insVrm.getArp03Ip()));
        this.vrm.setVlanId(Math.max(0, insVrm.getVlanId()));
        this.vrm.setUserMode(StringUtils.defaultString((String)insVrm.getUserMode()));
        this.vrm.setAdminPassword(passwords.getOrDefault(insVrm.getAdminPwd(), ""));
        this.vrm.setSecadminPassword(passwords.getOrDefault(insVrm.getSecAdminPwd(), ""));
        this.vrm.setSecauditorPassword(passwords.getOrDefault(insVrm.getSecAuditorPwd(), ""));
        this.vrm.setSysadminPassword(passwords.getOrDefault(insVrm.getSysAdminPwd(), ""));
        this.vrm.setRootPassword(passwords.getOrDefault(insVrm.getRootPwd(), ""));
        this.vrm.setGrubPassword(passwords.getOrDefault(insVrm.getGrubPwd(), ""));
        this.vrm.setGandalfPassword(passwords.getOrDefault(insVrm.getGandalfPwd(), ""));
        this.vrm.setIsEnableKrm(insVrm.isEnableKrm());
        this.vrm.setIsKmsMode(insVrm.isKmsMode());
        this.vrm.setPostgresPassword(passwords.getOrDefault(insVrm.getPostgresPwd(), ""));
        this.vrm.setGalaxPassword(passwords.getOrDefault(insVrm.getGalaxPwd(), ""));
        if (insVrm.isEnableHsm()) {
            this.vrm.setHsmCompany(StringUtils.defaultString((String)insVrm.getHsmCompany()));
            this.vrm.setHsmType(StringUtils.defaultString((String)insVrm.getHsmType()));
            this.vrm.setHsmIp(StringUtils.defaultString((String)insVrm.getHsmIp()));
            this.vrm.setHsmPort(StringUtils.defaultString((String)insVrm.getHsmPort()));
            this.vrm.setHsm02Ip(StringUtils.defaultString((String)insVrm.getHsm02Ip()));
            this.vrm.setHsm02Port(StringUtils.defaultString((String)insVrm.getHsm02Port()));
            this.vrm.setHsmAccount(StringUtils.defaultString((String)insVrm.getHsmAccount()));
            this.vrm.setHsmPassword(passwords.getOrDefault(insVrm.getHsmPwd(), ""));
            this.vrm.setHsmServicePassword(passwords.getOrDefault(insVrm.getHsmServicePwd(), ""));
        }
    }

    public void overrideSize(VrmInstallSizeBo insSize) {
        if (this.size == null) {
            this.size = new SizeParam();
        }
        String mode = StringUtils.defaultString((String)insSize.getMode(), (String)"normal");
        this.size.setMode(mode);
        log.info("fc size org mode : {}.", (Object)mode);
        String id = StringUtils.defaultString((String)insSize.getId(), (String)"m");
        this.size.setId(this.getSizeId(mode, id, StringUtils.defaultString((String)insSize.getScene())));
        log.info("current fc size id is {} -> {}.", (Object)id, (Object)this.size.getId());
        this.size.setCpu(Math.max(insSize.getCpu(), 4));
        this.size.setMem(Math.max(insSize.getMem(), 6));
        this.size.setRegistrySizeGb(insSize.getRegistrySizeGb());
    }

    private String getSizeId(String mode, String id, String scene) {
        if (Objects.equals("custom", mode)) {
            log.info("fc size is custom.");
            return id;
        }
        return ParamConstant.SCENE_SIZE_MAPS.getOrDefault(scene, Collections.emptyMap()).getOrDefault(id, id);
    }

    public void overrideOther(boolean isPatch) {
        if (this.other == null) {
            this.other = new PatchParam();
        }
        this.other.setIsPatch(isPatch);
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public CnaParam getCna() {
        return this.cna;
    }

    @Generated
    public VrmParam getVrm() {
        return this.vrm;
    }

    @Generated
    public SizeParam getSize() {
        return this.size;
    }

    @Generated
    public PatchParam getOther() {
        return this.other;
    }

    @Generated
    public ConfigVrmInfo setType(String type) {
        this.type = type;
        return this;
    }

    @Generated
    public ConfigVrmInfo setCna(CnaParam cna) {
        this.cna = cna;
        return this;
    }

    @Generated
    public ConfigVrmInfo setVrm(VrmParam vrm) {
        this.vrm = vrm;
        return this;
    }

    @Generated
    public ConfigVrmInfo setSize(SizeParam size) {
        this.size = size;
        return this;
    }

    @Generated
    public ConfigVrmInfo setOther(PatchParam other) {
        this.other = other;
        return this;
    }

    public static class PatchParam {
        @JSONField(name="is_patch")
        private Boolean isPatch;

        @Generated
        public PatchParam setIsPatch(Boolean isPatch) {
            this.isPatch = isPatch;
            return this;
        }

        @Generated
        public Boolean getIsPatch() {
            return this.isPatch;
        }
    }

    public static class SizeParam {
        @JSONField(name="mode")
        private String mode;
        @JSONField(name="id")
        private String id;
        @JSONField(name="cpu")
        private int cpu;
        @JSONField(name="mem")
        private int mem;
        @JSONField(name="registry_size_gb")
        private int registrySizeGb;

        @Generated
        public String getMode() {
            return this.mode;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public int getCpu() {
            return this.cpu;
        }

        @Generated
        public int getMem() {
            return this.mem;
        }

        @Generated
        public int getRegistrySizeGb() {
            return this.registrySizeGb;
        }

        @Generated
        public SizeParam setMode(String mode) {
            this.mode = mode;
            return this;
        }

        @Generated
        public SizeParam setId(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public SizeParam setCpu(int cpu) {
            this.cpu = cpu;
            return this;
        }

        @Generated
        public SizeParam setMem(int mem) {
            this.mem = mem;
            return this;
        }

        @Generated
        public SizeParam setRegistrySizeGb(int registrySizeGb) {
            this.registrySizeGb = registrySizeGb;
            return this;
        }
    }

    public static class VrmParam {
        @JSONField(name="mode")
        private String mode;
        @JSONField(name="cipher_mode")
        private String cipherMode;
        @JSONField(name="float_ip")
        private String floatIp;
        @JSONField(name="master_ip")
        private String masterIp;
        @JSONField(name="slave_ip")
        private String slaveIp;
        @JSONField(name="master_name")
        private String masterName;
        @JSONField(name="slave_name")
        private String slaveName;
        @JSONField(name="netmask")
        private String netmask;
        @JSONField(name="gateway")
        private String gateway;
        @JSONField(name="arp01_ip")
        private String arp01Ip;
        @JSONField(name="arp02_ip")
        private String arp02Ip;
        @JSONField(name="arp03_ip")
        private String arp03Ip;
        @JSONField(name="vlan_id")
        private int vlanId;
        @JSONField(name="user_mode")
        private String userMode;
        @JSONField(name="root_password")
        private String rootPassword;
        @JSONField(name="grub_password")
        private String grubPassword;
        @JSONField(name="gandalf_password")
        private String gandalfPassword;
        @JSONField(name="admin_password")
        private String adminPassword;
        @JSONField(name="sysadmin_password")
        private String sysadminPassword;
        @JSONField(name="secadmin_password")
        private String secadminPassword;
        @JSONField(name="secauditor_password")
        private String secauditorPassword;
        @JSONField(name="hsm_company")
        private String hsmCompany;
        @JSONField(name="hsm_type")
        private String hsmType;
        @JSONField(name="hsm_ip")
        private String hsmIp;
        @JSONField(name="hsm_port_01")
        private String hsmPort;
        @JSONField(name="hsm_ip_02")
        private String hsm02Ip;
        @JSONField(name="hsm_port_02")
        private String hsm02Port;
        @JSONField(name="hsm_account")
        private String hsmAccount;
        @JSONField(name="hsm_password")
        private String hsmPassword;
        @JSONField(name="hsm_service_password")
        private String hsmServicePassword;
        @JSONField(name="enable_krm")
        private Boolean isEnableKrm;
        @JSONField(name="kms_mode")
        private Boolean isKmsMode;
        @JSONField(name="postgres_password")
        private String postgresPassword;
        @JSONField(name="galax_password")
        private String galaxPassword;

        @Generated
        public String getMode() {
            return this.mode;
        }

        @Generated
        public String getCipherMode() {
            return this.cipherMode;
        }

        @Generated
        public String getFloatIp() {
            return this.floatIp;
        }

        @Generated
        public String getMasterIp() {
            return this.masterIp;
        }

        @Generated
        public String getSlaveIp() {
            return this.slaveIp;
        }

        @Generated
        public String getMasterName() {
            return this.masterName;
        }

        @Generated
        public String getSlaveName() {
            return this.slaveName;
        }

        @Generated
        public String getNetmask() {
            return this.netmask;
        }

        @Generated
        public String getGateway() {
            return this.gateway;
        }

        @Generated
        public String getArp01Ip() {
            return this.arp01Ip;
        }

        @Generated
        public String getArp02Ip() {
            return this.arp02Ip;
        }

        @Generated
        public String getArp03Ip() {
            return this.arp03Ip;
        }

        @Generated
        public int getVlanId() {
            return this.vlanId;
        }

        @Generated
        public String getUserMode() {
            return this.userMode;
        }

        @Generated
        public String getRootPassword() {
            return this.rootPassword;
        }

        @Generated
        public String getGrubPassword() {
            return this.grubPassword;
        }

        @Generated
        public String getGandalfPassword() {
            return this.gandalfPassword;
        }

        @Generated
        public String getAdminPassword() {
            return this.adminPassword;
        }

        @Generated
        public String getSysadminPassword() {
            return this.sysadminPassword;
        }

        @Generated
        public String getSecadminPassword() {
            return this.secadminPassword;
        }

        @Generated
        public String getSecauditorPassword() {
            return this.secauditorPassword;
        }

        @Generated
        public String getHsmCompany() {
            return this.hsmCompany;
        }

        @Generated
        public String getHsmType() {
            return this.hsmType;
        }

        @Generated
        public String getHsmIp() {
            return this.hsmIp;
        }

        @Generated
        public String getHsmPort() {
            return this.hsmPort;
        }

        @Generated
        public String getHsm02Ip() {
            return this.hsm02Ip;
        }

        @Generated
        public String getHsm02Port() {
            return this.hsm02Port;
        }

        @Generated
        public String getHsmAccount() {
            return this.hsmAccount;
        }

        @Generated
        public String getHsmPassword() {
            return this.hsmPassword;
        }

        @Generated
        public String getHsmServicePassword() {
            return this.hsmServicePassword;
        }

        @Generated
        public Boolean getIsEnableKrm() {
            return this.isEnableKrm;
        }

        @Generated
        public Boolean getIsKmsMode() {
            return this.isKmsMode;
        }

        @Generated
        public String getPostgresPassword() {
            return this.postgresPassword;
        }

        @Generated
        public String getGalaxPassword() {
            return this.galaxPassword;
        }

        @Generated
        public VrmParam setMode(String mode) {
            this.mode = mode;
            return this;
        }

        @Generated
        public VrmParam setCipherMode(String cipherMode) {
            this.cipherMode = cipherMode;
            return this;
        }

        @Generated
        public VrmParam setFloatIp(String floatIp) {
            this.floatIp = floatIp;
            return this;
        }

        @Generated
        public VrmParam setMasterIp(String masterIp) {
            this.masterIp = masterIp;
            return this;
        }

        @Generated
        public VrmParam setSlaveIp(String slaveIp) {
            this.slaveIp = slaveIp;
            return this;
        }

        @Generated
        public VrmParam setMasterName(String masterName) {
            this.masterName = masterName;
            return this;
        }

        @Generated
        public VrmParam setSlaveName(String slaveName) {
            this.slaveName = slaveName;
            return this;
        }

        @Generated
        public VrmParam setNetmask(String netmask) {
            this.netmask = netmask;
            return this;
        }

        @Generated
        public VrmParam setGateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        @Generated
        public VrmParam setArp01Ip(String arp01Ip) {
            this.arp01Ip = arp01Ip;
            return this;
        }

        @Generated
        public VrmParam setArp02Ip(String arp02Ip) {
            this.arp02Ip = arp02Ip;
            return this;
        }

        @Generated
        public VrmParam setArp03Ip(String arp03Ip) {
            this.arp03Ip = arp03Ip;
            return this;
        }

        @Generated
        public VrmParam setVlanId(int vlanId) {
            this.vlanId = vlanId;
            return this;
        }

        @Generated
        public VrmParam setUserMode(String userMode) {
            this.userMode = userMode;
            return this;
        }

        @Generated
        public VrmParam setRootPassword(String rootPassword) {
            this.rootPassword = rootPassword;
            return this;
        }

        @Generated
        public VrmParam setGrubPassword(String grubPassword) {
            this.grubPassword = grubPassword;
            return this;
        }

        @Generated
        public VrmParam setGandalfPassword(String gandalfPassword) {
            this.gandalfPassword = gandalfPassword;
            return this;
        }

        @Generated
        public VrmParam setAdminPassword(String adminPassword) {
            this.adminPassword = adminPassword;
            return this;
        }

        @Generated
        public VrmParam setSysadminPassword(String sysadminPassword) {
            this.sysadminPassword = sysadminPassword;
            return this;
        }

        @Generated
        public VrmParam setSecadminPassword(String secadminPassword) {
            this.secadminPassword = secadminPassword;
            return this;
        }

        @Generated
        public VrmParam setSecauditorPassword(String secauditorPassword) {
            this.secauditorPassword = secauditorPassword;
            return this;
        }

        @Generated
        public VrmParam setHsmCompany(String hsmCompany) {
            this.hsmCompany = hsmCompany;
            return this;
        }

        @Generated
        public VrmParam setHsmType(String hsmType) {
            this.hsmType = hsmType;
            return this;
        }

        @Generated
        public VrmParam setHsmIp(String hsmIp) {
            this.hsmIp = hsmIp;
            return this;
        }

        @Generated
        public VrmParam setHsmPort(String hsmPort) {
            this.hsmPort = hsmPort;
            return this;
        }

        @Generated
        public VrmParam setHsm02Ip(String hsm02Ip) {
            this.hsm02Ip = hsm02Ip;
            return this;
        }

        @Generated
        public VrmParam setHsm02Port(String hsm02Port) {
            this.hsm02Port = hsm02Port;
            return this;
        }

        @Generated
        public VrmParam setHsmAccount(String hsmAccount) {
            this.hsmAccount = hsmAccount;
            return this;
        }

        @Generated
        public VrmParam setHsmPassword(String hsmPassword) {
            this.hsmPassword = hsmPassword;
            return this;
        }

        @Generated
        public VrmParam setHsmServicePassword(String hsmServicePassword) {
            this.hsmServicePassword = hsmServicePassword;
            return this;
        }

        @Generated
        public VrmParam setIsEnableKrm(Boolean isEnableKrm) {
            this.isEnableKrm = isEnableKrm;
            return this;
        }

        @Generated
        public VrmParam setIsKmsMode(Boolean isKmsMode) {
            this.isKmsMode = isKmsMode;
            return this;
        }

        @Generated
        public VrmParam setPostgresPassword(String postgresPassword) {
            this.postgresPassword = postgresPassword;
            return this;
        }

        @Generated
        public VrmParam setGalaxPassword(String galaxPassword) {
            this.galaxPassword = galaxPassword;
            return this;
        }
    }

    public static class CnaParam {
        @JSONField(name="master_ip")
        private String masterIp;
        @JSONField(name="master_gandalf_password")
        private String masterGandalfPassword;
        @JSONField(name="master_root_password")
        private String masterRootPassword;
        @JSONField(name="slave_ip")
        private String slaveIp;
        @JSONField(name="slave_gandalf_password")
        private String slaveGandalfPassword;
        @JSONField(name="slave_root_password")
        private String slaveRootPassword;

        @Generated
        public String getMasterIp() {
            return this.masterIp;
        }

        @Generated
        public String getMasterGandalfPassword() {
            return this.masterGandalfPassword;
        }

        @Generated
        public String getMasterRootPassword() {
            return this.masterRootPassword;
        }

        @Generated
        public String getSlaveIp() {
            return this.slaveIp;
        }

        @Generated
        public String getSlaveGandalfPassword() {
            return this.slaveGandalfPassword;
        }

        @Generated
        public String getSlaveRootPassword() {
            return this.slaveRootPassword;
        }

        @Generated
        public CnaParam setMasterIp(String masterIp) {
            this.masterIp = masterIp;
            return this;
        }

        @Generated
        public CnaParam setMasterGandalfPassword(String masterGandalfPassword) {
            this.masterGandalfPassword = masterGandalfPassword;
            return this;
        }

        @Generated
        public CnaParam setMasterRootPassword(String masterRootPassword) {
            this.masterRootPassword = masterRootPassword;
            return this;
        }

        @Generated
        public CnaParam setSlaveIp(String slaveIp) {
            this.slaveIp = slaveIp;
            return this;
        }

        @Generated
        public CnaParam setSlaveGandalfPassword(String slaveGandalfPassword) {
            this.slaveGandalfPassword = slaveGandalfPassword;
            return this;
        }

        @Generated
        public CnaParam setSlaveRootPassword(String slaveRootPassword) {
            this.slaveRootPassword = slaveRootPassword;
            return this;
        }
    }
}

