/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.remote;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.remote.RemoteFileService;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.TaskUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshErrParser;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsLogRemoteFileService
implements RemoteFileService<String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbsLogRemoteFileService.class);
    private final DefaultSshEndJudge endJudge = new DefaultSshEndJudge();
    private final SshShellService shellService;

    public boolean isConnected() {
        return this.shellService != null && this.shellService.isConnected();
    }

    protected abstract String getRemoteLogFile();

    @Override
    public Optional<String> fetchConfigFile2Obj(String taskId) throws BasicException {
        String remoteLogFile = this.getRemoteLogFile();
        if (!TaskUtils.switchUser2Root(this.shellService, taskId)) {
            log.error("change root permission failed, taskId={}.", (Object)taskId);
            return Optional.empty();
        }
        if (!this.changePermission(taskId, remoteLogFile)) {
            return Optional.empty();
        }
        return this.readTailTextFromRemoteLogFile(taskId, remoteLogFile);
    }

    private Optional<String> readTailTextFromRemoteLogFile(String taskId, String remoteLogFile) throws SshException {
        String cmd = StringUtils.formatTxt((String)"tail -n %d %s", (Object[])new Object[]{600, remoteLogFile});
        String result = this.shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
        log.info("execute taskId [{}] command [{}], result = {}.", new Object[]{taskId, cmd, result});
        return Optional.ofNullable(result);
    }

    private boolean changePermission(String taskId, String remoteLogFile) throws SshException {
        String cmd = StringUtils.formatTxt((String)"chmod 640 -R %s", (Object[])new Object[]{remoteLogFile});
        String result = this.shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
        log.info("execute taskId [{}] command [{}], result = {}.", new Object[]{taskId, cmd, result});
        if (SshErrParser.isInvalidResult((String)result)) {
            log.error("change other read permission failed, taskId={}.", (Object)taskId);
            return false;
        }
        return true;
    }

    @Override
    public boolean commitObj2ConfigFile(String taskId, String logText) throws BasicException {
        return false;
    }

    @Generated
    public AbsLogRemoteFileService(SshShellService shellService) {
        this.shellService = shellService;
    }
}

