/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.remote;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONValidator;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.FcErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.LogicException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.remote.RemoteFileService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StreamUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsRemoteFileService<T>
implements RemoteFileService<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbsRemoteFileService.class);
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private final SshSftpService sftpService;
    private final String installPath;

    public AbsRemoteFileService(SshSftpService sftpService, String installPath) {
        this.sftpService = sftpService;
        this.installPath = installPath;
    }

    public boolean isConnected() {
        return this.sftpService != null && this.sftpService.isConnected();
    }

    protected abstract String getRemoteConfigFile();

    protected abstract Class<T> getConfigClass();

    private String buildRemoteFullConfigFilePath() {
        return FilePathValidatorUtils.createLinuxPaths((String)this.installPath, (String[])new String[]{this.getRemoteConfigFile()});
    }

    @Override
    public Optional<T> fetchConfigFile2Obj(String taskId) throws BasicException {
        this.byteArrayOutputStream.reset();
        String remoteConfigFile = this.buildRemoteFullConfigFilePath();
        this.sftpService.download(remoteConfigFile, (OutputStream)this.byteArrayOutputStream, (SftpProgCallback)new DefaultSftpProgCallback(this.getRemoteConfigFile()));
        String json = this.byteArrayOutputStream.toString();
        log.info("read config object, taskId={}, json = {}.", (Object)taskId, (Object)json);
        if (!JSONValidator.from((String)json).validate()) {
            return Optional.empty();
        }
        return Optional.ofNullable(JSON.parseObject((String)json, this.getConfigClass()));
    }

    @Override
    public boolean commitObj2ConfigFile(String taskId, T configInfo) throws BasicException {
        boolean bl;
        ByteArrayInputStream is = null;
        try {
            this.byteArrayOutputStream.reset();
            this.byteArrayOutputStream.write(JSON.toJSONString(configInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}).getBytes(StandardCharsets.UTF_8));
            log.info("commit config object json = {}.", (Object)this.byteArrayOutputStream);
            is = new ByteArrayInputStream(this.byteArrayOutputStream.toByteArray());
            this.sftpService.upload((InputStream)is, this.buildRemoteFullConfigFilePath(), (SftpProgCallback)new DefaultSftpProgCallback(this.getRemoteConfigFile()));
            bl = true;
        }
        catch (IOException e) {
            try {
                log.error("read config failed.", (Throwable)e);
                throw new LogicException((ErrorKey)FcErrorCode.CONFIG_FILE_COMMIT_FAILED, Collections.singletonList(this.getRemoteConfigFile()));
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(is);
                throw throwable;
            }
        }
        StreamUtils.closeStream((Closeable)is);
        return bl;
    }
}

