/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task;

import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.FcInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.TaskInfoVo;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.dto.TaskProgressDto;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.cna.CnaInstallNodeBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.cna.DeployFcCnaBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.installer.DeployFcInstallerBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.DeployFcVrmBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.FcErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.LogicException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.cna.DeployCnaTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.common.CleanDeployEnvTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeployTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.TaskBasicInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.TaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.TaskResult;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.installer.DeployInstallerTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.DeployVrmTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.FileUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.TaskUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployTaskManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployTaskManager.class);
    private static final DeployTaskManager MANAGER = new DeployTaskManager();
    private final Map<String, TaskContext> taskContextMaps = new ConcurrentHashMap<String, TaskContext>();
    private final Function<Throwable, TaskResult> taskExceptionHandler = throwable -> {
        log.error("task execute failed:", throwable);
        return null;
    };

    public static DeployTaskManager getManager() {
        return MANAGER;
    }

    public SshShellService findShellService(String taskId) throws BasicException {
        TaskContext taskContext = this.taskContextMaps.get(taskId);
        if (taskContext == null) {
            throw new LogicException((ErrorKey)FcErrorCode.TASK_PARAM_INVALID, Collections.singletonList("taskId"));
        }
        return taskContext.findShellService();
    }

    public SshSftpService findSftpService(String taskId) throws BasicException {
        TaskContext taskContext = this.taskContextMaps.get(taskId);
        if (taskContext == null) {
            throw new LogicException((ErrorKey)FcErrorCode.TASK_PARAM_INVALID, Collections.singletonList("taskId"));
        }
        return taskContext.findSftpService();
    }

    public boolean isTaskExecuted(String taskId) {
        return this.taskContextMaps.containsKey(taskId);
    }

    public String findRootPwd(String taskId) {
        TaskContext taskContext = this.taskContextMaps.get(taskId);
        if (taskContext == null) {
            return "";
        }
        return taskContext.getConnectionRootPwd();
    }

    public List<CnaInstallNodeBo> findCnaNodes(String taskId) {
        TaskContext taskContext = this.taskContextMaps.get(taskId);
        if (taskContext == null || taskContext.getDeployFcCnaBo() == null) {
            return Collections.emptyList();
        }
        return taskContext.getCnaNodes();
    }

    public String findCnaManageRootPwd(String taskId) {
        TaskContext taskContext = this.taskContextMaps.get(taskId);
        if (taskContext == null || taskContext.getDeployFcCnaBo() == null) {
            return "";
        }
        return taskContext.getManageNodeRootPwd();
    }

    private TaskContext buildTaskContext(String taskId, Supplier<TaskBasicInfo> supplier) {
        TaskContext taskContext = this.taskContextMaps.get(taskId);
        if (taskContext == null) {
            taskContext = TaskContext.builder().taskId(taskId).basicInfo(supplier.get()).build();
            this.taskContextMaps.put(taskId, taskContext);
            log.info("create new task context.");
        }
        return taskContext;
    }

    public boolean updateDeployFcParams(FcInstallParamsVo fcInstallParamsVo) {
        TaskInfoVo taskInfoVo = fcInstallParamsVo.getTask();
        if (taskInfoVo == null) {
            log.error("update deploy fc param, task info is null");
            return false;
        }
        TaskContext taskContext = this.taskContextMaps.get(taskInfoVo.getTaskId());
        if (taskContext == null) {
            log.error("update deploy fc param, task context is null");
            return false;
        }
        taskContext.setBasicInfo(TaskUtils.createTaskBasicInfo(taskInfoVo));
        if (taskContext.isDeployInstallerTaskFailed()) {
            taskContext.setDeployFcInstallerBo(TaskUtils.createDeployFcInstallerBo(fcInstallParamsVo));
            log.info("update deploy fc param, update installer params!");
            return true;
        }
        if (taskContext.isDeployCnaTaskFailed() && fcInstallParamsVo.getCna() != null) {
            taskContext.setDeployFcCnaBo(TaskUtils.createDeployFcCnaBo(fcInstallParamsVo.getCna(), taskInfoVo));
            log.info("update deploy fc param, update cna params!");
            return true;
        }
        if (taskContext.isDeployVrmTaskFailed() && fcInstallParamsVo.getVrm() != null) {
            Optional.ofNullable(fcInstallParamsVo.getCna()).ifPresent(cnaBo -> taskContext.setDeployFcCnaBo(TaskUtils.createDeployFcCnaBo(cnaBo, taskInfoVo)));
            taskContext.setDeployFcVrmBo(TaskUtils.createDeployFcVrmBo(fcInstallParamsVo.getVrm(), taskInfoVo));
            log.info("update deploy fc param, update vrm params!");
            return true;
        }
        if (taskContext.isCleanDeployEnvTaskFailed()) {
            String installPath = FilePathValidatorUtils.createLinuxPaths((String)"/home/GalaX8800", (String[])new String[]{FileUtils.removeFileSuffix(taskInfoVo.getInstallerFileName())});
            log.info("update clean deploy env task, install path = {}.", (Object)installPath);
            taskContext.setInstallPath(installPath);
            return true;
        }
        log.warn("update deploy fc param, no task failed and nothing to update.");
        return false;
    }

    public void startDeployInstallerTask(String taskId, DeployFcInstallerBo fcInstallerBo, Supplier<TaskBasicInfo> supplier) {
        TaskContext taskContext = this.buildTaskContext(taskId, supplier);
        DeployInstallerTask deployInstallerTask = new DeployInstallerTask(taskId, fcInstallerBo);
        taskContext.setDeployInstallerTask(deployInstallerTask).setDeployFcInstallerBo(fcInstallerBo);
        log.info("start to deploy installer task, taskId={}.", (Object)taskId);
        CompletableFuture.supplyAsync(deployInstallerTask::call).exceptionally((Function)this.taskExceptionHandler);
    }

    public boolean retryDeployInstallerTask(String taskId) {
        TaskContext taskContext = this.taskContextMaps.get(taskId);
        if (taskContext == null || !taskContext.isDeployInstallerTaskFailed()) {
            return false;
        }
        return this.execute2RetryTask(taskContext.getDeployInstallerTask(), taskContext, taskContext.getDeployFcInstallerBo());
    }

    public Optional<TaskProgressDto> queryDeployInstallerProgress(String taskId) {
        TaskContext taskContext = this.taskContextMaps.get(taskId);
        if (taskContext == null) {
            return Optional.empty();
        }
        return this.queryTaskProgress(taskContext.getDeployInstallerTask());
    }

    public void startDeployVrmTask(String taskId, DeployFcVrmBo fcVrmBo, Supplier<TaskBasicInfo> supplier) {
        TaskContext taskContext = this.buildTaskContext(taskId, supplier);
        DeployVrmTask deployVrmTask = new DeployVrmTask(taskId, fcVrmBo);
        taskContext.setDeployVrmTask(deployVrmTask).setDeployFcVrmBo(fcVrmBo);
        log.info("start to deploy vrm task, taskId={}.", (Object)taskId);
        CompletableFuture.supplyAsync(deployVrmTask::call).exceptionally((Function)this.taskExceptionHandler);
    }

    public boolean retryDeployVrmTask(String taskId) {
        TaskContext taskContext = this.taskContextMaps.get(taskId);
        if (taskContext == null || !taskContext.isDeployVrmTaskFailed()) {
            return false;
        }
        return this.execute2RetryTask(taskContext.getDeployVrmTask(), taskContext, taskContext.getDeployFcVrmBo());
    }

    public Optional<TaskProgressDto> queryDeployVrmProgress(String taskId) {
        TaskContext taskContext = this.taskContextMaps.get(taskId);
        if (taskContext == null) {
            return Optional.empty();
        }
        return this.queryTaskProgress(taskContext.getDeployVrmTask());
    }

    public String queryRemoteVrmRunningLogs(String taskId) {
        TaskContext taskContext = this.taskContextMaps.get(taskId);
        if (taskContext == null || taskContext.getDeployVrmTask() == null) {
            log.warn("query remote vrm running log not task. taskId={}.", (Object)taskId);
            return "";
        }
        return taskContext.getDeployVrmTask().getRemoteRunningLogs();
    }

    public void startDeployCnaTask(String taskId, DeployFcCnaBo fcCnaBo, Supplier<TaskBasicInfo> supplier) {
        TaskContext taskContext = this.buildTaskContext(taskId, supplier);
        DeployCnaTask deployCnaTask = new DeployCnaTask(taskId, fcCnaBo);
        taskContext.setDeployCnaTask(deployCnaTask).setDeployFcCnaBo(fcCnaBo);
        log.info("start to deploy cna task, taskId={}.", (Object)taskId);
        CompletableFuture.supplyAsync(deployCnaTask::call).exceptionally((Function)this.taskExceptionHandler);
    }

    public boolean retryDeployCnaTask(String taskId) {
        TaskContext taskContext = this.taskContextMaps.get(taskId);
        if (taskContext == null || !taskContext.isDeployCnaTaskFailed()) {
            return false;
        }
        return this.execute2RetryTask(taskContext.getDeployCnaTask(), taskContext, taskContext.getDeployFcCnaBo());
    }

    public Optional<TaskProgressDto> queryDeployCnaProgress(String taskId) {
        TaskContext taskContext = this.taskContextMaps.get(taskId);
        if (taskContext == null) {
            return Optional.empty();
        }
        return this.queryTaskProgress(taskContext.getDeployCnaTask());
    }

    public String queryRemoteCnaRunningLogs(String taskId) {
        TaskContext taskContext = this.taskContextMaps.get(taskId);
        if (taskContext == null || taskContext.getDeployCnaTask() == null) {
            log.warn("query remote cna running log not task. taskId={}.", (Object)taskId);
            return "";
        }
        return taskContext.getDeployCnaTask().getRemoteRunningLogs();
    }

    public boolean skipDeployCnaNode(String taskId, String uuid) {
        TaskContext taskContext = this.taskContextMaps.get(taskId);
        if (taskContext == null) {
            return false;
        }
        DeployTask deployTask = null;
        if (taskContext.isDeployInstallerTaskFailed()) {
            deployTask = taskContext.getDeployInstallerTask();
        } else if (taskContext.isDeployCnaTaskFailed()) {
            deployTask = taskContext.getDeployCnaTask();
        } else if (taskContext.isDeployVrmTaskFailed()) {
            deployTask = taskContext.getDeployVrmTask();
        } else if (taskContext.isCleanDeployEnvTaskFailed()) {
            deployTask = taskContext.getCleanDeployEnvTask();
        }
        if (deployTask != null) {
            deployTask.setTaskInSkipStatus(uuid);
            CompletableFuture.supplyAsync(deployTask::call).exceptionally((Function)this.taskExceptionHandler);
            return true;
        }
        return false;
    }

    public void startCleanDeployEnvTask(String taskId, String installPath, Supplier<TaskBasicInfo> supplier) {
        TaskContext taskContext = this.buildTaskContext(taskId, supplier);
        CleanDeployEnvTask cleanDeployEnvTask = new CleanDeployEnvTask(taskId, installPath);
        taskContext.setCleanDeployEnvTask(cleanDeployEnvTask).setInstallPath(installPath);
        log.info("start to deploy clean env task, taskId={}.", (Object)taskId);
        CompletableFuture.supplyAsync(cleanDeployEnvTask::call).exceptionally((Function)this.taskExceptionHandler);
    }

    public boolean retryCleanDeployEnvTask(String taskId) {
        TaskContext taskContext = this.taskContextMaps.get(taskId);
        if (taskContext == null || !taskContext.isCleanDeployEnvTaskFailed()) {
            return false;
        }
        return this.execute2RetryTask(taskContext.getCleanDeployEnvTask(), taskContext, taskContext.getInstallPath());
    }

    private <T> boolean execute2RetryTask(DeployTask<T> deployTask, TaskContext taskContext, T deployParams) {
        taskContext.releaseSshConnection();
        log.info("retry task, release ssh connection finish.");
        if (!deployTask.setTaskInRetryStatus(deployParams)) {
            log.error("retry task, update param failed, taskId={}.", (Object)taskContext.getTaskId());
            return false;
        }
        log.info("start to retry task {}, taskId={}.", (Object)deployTask.getClass().getName(), (Object)taskContext.getTaskId());
        CompletableFuture.supplyAsync(deployTask::call).exceptionally((Function)this.taskExceptionHandler);
        return true;
    }

    public Optional<TaskProgressDto> queryCleanDeployEnvProgress(String taskId) {
        TaskContext taskContext = this.taskContextMaps.get(taskId);
        if (taskContext == null) {
            return Optional.empty();
        }
        return this.queryTaskProgress(taskContext.getCleanDeployEnvTask());
    }

    private Optional<TaskProgressDto> queryTaskProgress(BaseTask baseTask) {
        if (baseTask == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(baseTask.getCurrentTaskProgress());
    }
}

