/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.cna;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.cna.CnaInstallNodeBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.cna.DeployFcCnaBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.FcErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.cna.httprequest.BmcHttpPowerRequest;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeploySubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.ConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.RequestUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.http.HttpRequestApiFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class CheckPowerStateSubTask
extends DeploySubTask<DeployFcCnaBo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckPowerStateSubTask.class);
    private static final String TASK_NAME_RES_KEY = "task.name.cna.subtask_check_power_state";
    private static final int DEFAULT_WAIT_FOR_CHECK_POWER_STATE_TIMEOUT = 10;
    private static final String KEY_WAIT_FOR_CHECK_POWER_STATE_TIMEOUT = "deployfc.cna.max_wait_timeout_check_power";
    private final List<String> checkDetails = Collections.synchronizedList(new LinkedList());
    private final AtomicBoolean checkResult = new AtomicBoolean(true);
    private CountDownLatch countDownLatch;

    public CheckPowerStateSubTask(String taskId) {
        super(taskId, TASK_NAME_RES_KEY);
    }

    @Override
    protected boolean canBeSkipTask() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean executeSubTask(DeployFcCnaBo fcCnaBo) throws BasicException {
        List<CnaInstallNodeBo> checkNodes = Optional.ofNullable(fcCnaBo.getNodes()).orElse(Collections.emptyList()).stream().filter(nodeBo -> !nodeBo.isMaster()).collect(Collectors.toList());
        if (checkNodes.isEmpty()) {
            log.info("no cna item need to check power!");
            this.appendDetail("[check power]", "there is no node to check power.");
            return true;
        }
        try {
            this.checkDetails.clear();
            this.checkResult.set(true);
            log.info("check cna power nodes size={}.", (Object)checkNodes.size());
            this.appendDetail("[check power]", StringUtils.formatTxt((String)"prepare to check power of %d node.", (Object[])new Object[]{checkNodes.size()}));
            this.countDownLatch = new CountDownLatch(checkNodes.size());
            checkNodes.forEach(nodeBo -> ThreadUtils.execute((Runnable)new CheckPowerStateThread((CnaInstallNodeBo)nodeBo)));
            int waitForCheckTime = ConfigUtils.getPropertiesValue(KEY_WAIT_FOR_CHECK_POWER_STATE_TIMEOUT, 10);
            waitForCheckTime = Math.max(1, waitForCheckTime);
            log.info("wait for check cna power state time={}.", (Object)waitForCheckTime);
            boolean isAwaitSuccess = this.countDownLatch.await(waitForCheckTime, TimeUnit.MINUTES);
            if (!isAwaitSuccess) {
                this.setTaskFailed(FcErrorCode.TASK_WAIT_TIMEOUT, Collections.emptyList());
                boolean bl = false;
                return bl;
            }
            if (!this.checkResult.get()) {
                this.setTaskFailed(FcErrorCode.TASK_EXECUTE_DETAIL_FAILED, Collections.singletonList("Check Power"));
                boolean bl = false;
                return bl;
            }
        }
        catch (InterruptedException e) {
            log.error("wait check thread interrupted.", (Throwable)e);
            this.setTaskFailed(FcErrorCode.TASK_EXECUTE_FAILED, Arrays.asList("Check Power", e.getMessage()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.appendDetail("[check power]", String.join((CharSequence)System.lineSeparator(), this.checkDetails));
        }
        return true;
    }

    private class CheckPowerStateThread
    implements Runnable {
        private final CnaInstallNodeBo nodeBo;
        private BmcHttpPowerRequest requestApi;
        private final List<Supplier<Boolean>> executeActions = new LinkedList<Supplier<Boolean>>();
        private String authToken;

        private CheckPowerStateThread(CnaInstallNodeBo nodeBo) {
            this.nodeBo = nodeBo;
            this.initExecuteActions();
        }

        private String buildDetailText(String detailFormat) {
            String detailText = StringUtils.formatTxt((String)detailFormat, (Object[])new Object[]{this.nodeBo.getHostName(), this.nodeBo.getBmcIp()});
            log.info(detailText);
            return detailText;
        }

        private void initExecuteActions() {
            this.executeActions.add(this::executeInitRequestApi);
            this.executeActions.add(this::executeLoginNodeBmc);
            this.executeActions.add(this::executeCheckPowerStateOff);
            this.executeActions.add(this::executeOpenNodePowerStateOn);
        }

        private boolean executeCheckPowerStateOff() {
            if (this.checkNodePowerStatusOn()) {
                CheckPowerStateSubTask.this.checkDetails.add(this.buildDetailText("%s(%s) power is still on."));
                return false;
            }
            return true;
        }

        private boolean executeOpenNodePowerStateOn() {
            if (!this.setPowerOn()) {
                CheckPowerStateSubTask.this.checkDetails.add(this.buildDetailText("%s(%s) set power on failed."));
                CheckPowerStateSubTask.this.checkResult.set(false);
                return false;
            }
            if (!this.waitForPowerOn()) {
                CheckPowerStateSubTask.this.checkDetails.add(this.buildDetailText("%s(%s) wait for power on failed."));
                CheckPowerStateSubTask.this.checkResult.set(false);
                return false;
            }
            return true;
        }

        @Override
        public void run() {
            try {
                boolean isExecuteSuccess = this.executeActions.stream().map(Supplier::get).filter(Predicate.isEqual(false)).findFirst().orElse(true);
                if (isExecuteSuccess) {
                    CheckPowerStateSubTask.this.checkDetails.add(this.buildDetailText("%s(%s) set power on successfully."));
                }
            }
            finally {
                CheckPowerStateSubTask.this.countDownLatch.countDown();
                this.authToken = null;
                log.info("{}({}) check power has finish.", (Object)this.nodeBo.getHostName(), (Object)this.nodeBo.getBmcIp());
            }
        }

        private boolean waitForPowerOn() {
            int maxCheckCount = 6;
            return IntStream.range(1, 7).mapToObj(this::waitAndCheckState).filter(Predicate.isEqual(true)).findFirst().orElse(false);
        }

        private boolean waitAndCheckState(int idx) {
            log.info("wait for power on times({}).", (Object)idx);
            ThreadUtils.threadSafeSleep((int)10, (TimeUnit)TimeUnit.SECONDS);
            if (this.checkNodePowerStatusOn()) {
                log.info("{}({}), check power status on successfully.", (Object)this.nodeBo.getHostName(), (Object)this.nodeBo.getBmcIp());
                return true;
            }
            return false;
        }

        private boolean setPowerOn() {
            try {
                return this.requestApi.setPowerState(RequestUtils.createDefaultHeaderMaps(this.authToken), RequestUtils.createPowerOnBodyMaps()).execute().isSuccessful();
            }
            catch (IOException e) {
                log.error("set power on failed, bmcIp={}.", (Object)this.nodeBo.getBmcIp(), (Object)e);
                return false;
            }
        }

        private boolean checkNodePowerStatusOn() {
            try {
                Response queryResponse = this.requestApi.queryPowerState(RequestUtils.createDefaultHeaderMaps(this.authToken)).execute();
                return queryResponse.isSuccessful() && queryResponse.body() != null && Objects.equals("On", ((Map)queryResponse.body()).get("PowerState"));
            }
            catch (IOException e) {
                log.error("check power state failed, bmcIp={}.", (Object)this.nodeBo.getBmcIp(), (Object)e);
                return false;
            }
        }

        private boolean executeInitRequestApi() {
            String baseUrl = "https://" + this.nodeBo.getBmcIp();
            this.requestApi = (BmcHttpPowerRequest)HttpRequestApiFactory.createRequestApi((String)baseUrl, BmcHttpPowerRequest.class);
            if (Objects.isNull(this.requestApi)) {
                CheckPowerStateSubTask.this.checkDetails.add(this.buildDetailText("%s(%s) init request failed."));
                CheckPowerStateSubTask.this.checkResult.set(false);
            }
            return this.requestApi != null;
        }

        private boolean executeLoginNodeBmc() {
            boolean isLoginSuccess = false;
            try {
                Response response = this.requestApi.loginBmc(RequestUtils.createLoginBmcHeaderMaps(), RequestUtils.createLoginBmcBodyMaps(this.nodeBo.getBmcUser(), this.nodeBo.getBmcPwd())).execute();
                if (response.isSuccessful()) {
                    this.authToken = response.headers().get("X-Auth-Token");
                    isLoginSuccess = StringUtils.isNotEmpty((CharSequence)this.authToken);
                }
            }
            catch (IOException e) {
                log.error("login bmc failed, bmcIp={}.", (Object)this.nodeBo.getBmcIp(), (Object)e);
            }
            if (!isLoginSuccess) {
                CheckPowerStateSubTask.this.checkDetails.add(this.buildDetailText("%s(%s) login bmc failed."));
                CheckPowerStateSubTask.this.checkResult.set(false);
                return false;
            }
            log.info("login successfully, bmcIp={}.", (Object)this.nodeBo.getBmcIp());
            return true;
        }
    }
}

