/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.cna;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeploySubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.CommandUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanDeployCnaEnvSubTask
extends DeploySubTask<String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CleanDeployCnaEnvSubTask.class);
    private static final String TASK_NAME_RES_KEY = "task.name.cna.subtask.clean_deploy_cna_env";
    private final DefaultSshEndJudge endJudge = new DefaultSshEndJudge();

    public CleanDeployCnaEnvSubTask(String taskId) {
        super(taskId, TASK_NAME_RES_KEY);
    }

    @Override
    protected boolean executeSubTask(String installPath) throws BasicException {
        SshShellService shellService = this.findShellService();
        this.stopCnaService(shellService);
        this.clearCnaService(shellService);
        this.deleteUploadCnaFiles(shellService);
        return true;
    }

    private void deleteUploadCnaFiles(SshShellService shellService) throws SshException {
        String cmd = StringUtils.formatTxt((String)"rm -rf %s", (Object[])new Object[]{"/installer/upload/cna"});
        String result = shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
        this.appendDetail(cmd, result);
        log.info("execute [{}], result = {}.", (Object)cmd, (Object)result);
    }

    private void clearCnaService(SshShellService shellService) throws SshException {
        String cmd = CommandUtils.getLanguageCommand("cnaInstaller clear");
        String result = shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
        this.appendDetail(cmd, result);
        log.info("execute [{}], result = {}.", (Object)cmd, (Object)result);
    }

    private void stopCnaService(SshShellService shellService) throws SshException {
        String cmd = CommandUtils.getLanguageCommand("cnaInstaller stop");
        String result = shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
        this.appendDetail(cmd, result);
        log.info("execute [{}], result = {}.", (Object)cmd, (Object)result);
    }
}

