/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.cna;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.cna.CnaInstallNodeBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.cna.DeployFcCnaBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.config.ConfigCnaInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.config.ConfigCnaItemInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.FcErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.cna.RemoteFileCnaListServiceImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.cna.RemoteFileCnaServiceImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeploySubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.TaskUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.ValidationMsgUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshErrParser;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigCnaParamSubTask
extends DeploySubTask<DeployFcCnaBo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigCnaParamSubTask.class);
    private static final String TASK_NAME_RES_KEY = "task.name.cna.subtask_config_cna_params";

    public ConfigCnaParamSubTask(String taskId) {
        super(taskId, TASK_NAME_RES_KEY);
    }

    @Override
    protected boolean canBeSkipTask() {
        return false;
    }

    @Override
    protected boolean executeSubTask(DeployFcCnaBo deployFcCnaBo) throws BasicException {
        SshShellService shellService = this.findShellService();
        String invalidPwdNames = this.checkPasswordInvalid(shellService, deployFcCnaBo);
        if (StringUtils.isNotEmpty((CharSequence)invalidPwdNames)) {
            this.setTaskFailed(FcErrorCode.TASK_PASSWORD_TOO_WEAK, Collections.singletonList(invalidPwdNames));
            log.error("check weak pwd failed, {}.", (Object)invalidPwdNames);
            return false;
        }
        deployFcCnaBo.setCnaDriver(deployFcCnaBo.isCnaDriver() && !this.checkHasNoDriverFiles(shellService));
        SshSftpService sftpService = this.findSftpService();
        Map<String, String> passwords = this.encryptConfigPasswords(shellService, deployFcCnaBo);
        if (!this.saveCnaInfoRecord2Remote(deployFcCnaBo, sftpService, passwords)) {
            log.error("cna config save failed.");
            return false;
        }
        return this.saveCnaListRecord2Remote(deployFcCnaBo, sftpService, passwords);
    }

    private boolean checkHasNoDriverFiles(SshShellService shellService) throws SshException {
        String cmd = StringUtils.formatTxt((String)"ll %s", (Object[])new Object[]{"/installer/upload/driver"});
        String result = shellService.execCommand(cmd);
        this.appendDetail(cmd, result);
        log.info("execute [{}], result={}.", (Object)cmd, (Object)result);
        return SshErrParser.isInvalidResult((String)result) || StringUtils.containIgnoreCase((String)result, (String[])new String[]{"total 0"});
    }

    private String checkPasswordInvalid(SshShellService shellService, DeployFcCnaBo deployFcCnaBo) throws BasicException {
        HashMap<String, String> pwdMaps = new HashMap<String, String>();
        Optional.ofNullable(deployFcCnaBo).ifPresent(cnaBo -> {
            pwdMaps.put(ValidationMsgUtils.getString("cna.rootPwd"), cnaBo.getRootPwd());
            pwdMaps.put(ValidationMsgUtils.getString("cna.gandalfPwd"), cnaBo.getGandalfPwd());
            pwdMaps.put(ValidationMsgUtils.getString("cna.grubPwd"), cnaBo.getGrubPwd());
            pwdMaps.put(ValidationMsgUtils.getString("cna.redisPwd"), cnaBo.getRedisPwd());
        });
        return String.join((CharSequence)",", TaskUtils.getInvalidPasswordParamNames(shellService, pwdMaps));
    }

    private boolean saveCnaInfoRecord2Remote(DeployFcCnaBo deployFcCnaBo, SshSftpService sftpService, Map<String, String> passwords) throws BasicException {
        RemoteFileCnaServiceImpl cnaService = new RemoteFileCnaServiceImpl(sftpService, deployFcCnaBo.getPathBo().getInstallPath());
        ConfigCnaInfo cnaInfo = this.buildConfigCnaInfo(deployFcCnaBo, passwords, cnaService);
        if (!cnaService.commitObj2ConfigFile(this.getTaskId(), cnaInfo)) {
            this.setTaskFailed(FcErrorCode.CONFIG_FILE_COMMIT_FAILED, Collections.singletonList(cnaService.getRemoteConfigFile()));
            return false;
        }
        this.appendDetail("[config cna info]", "sftp save cna config to remote successfully.");
        return true;
    }

    private boolean saveCnaListRecord2Remote(DeployFcCnaBo deployFcCnaBo, SshSftpService sftpService, Map<String, String> passwords) throws BasicException {
        List<CnaInstallNodeBo> nodes = deployFcCnaBo.getNodes();
        if (nodes != null && !nodes.isEmpty()) {
            RemoteFileCnaListServiceImpl cnaListService = new RemoteFileCnaListServiceImpl(sftpService, deployFcCnaBo.getPathBo().getInstallPath());
            ConfigCnaItemInfo[] cnaList = (ConfigCnaItemInfo[])nodes.stream().filter(cnaItem -> !cnaItem.isMaster()).map(cnaItem -> ConfigCnaItemInfo.buildCnaItemInfo(passwords, cnaItem)).toArray(ConfigCnaItemInfo[]::new);
            if (!cnaListService.commitObj2ConfigFile(this.getTaskId(), cnaList)) {
                log.error("cna list config save failed.");
                this.setTaskFailed(FcErrorCode.CONFIG_FILE_COMMIT_FAILED, Collections.singletonList(cnaListService.getRemoteConfigFile()));
                return false;
            }
            this.appendDetail("[config cna list]", "sftp save cna list to remote successfully.");
        }
        return true;
    }

    private ConfigCnaInfo buildConfigCnaInfo(DeployFcCnaBo deployFcCnaBo, Map<String, String> passwords, RemoteFileCnaServiceImpl cnaService) throws BasicException {
        Optional<ConfigCnaInfo> opCnaInfo = cnaService.fetchConfigFile2Obj(this.getTaskId());
        if (!opCnaInfo.isPresent()) {
            log.warn("remote cna.json is not exist");
        }
        ConfigCnaInfo cnaInfo = opCnaInfo.orElse(new ConfigCnaInfo());
        cnaInfo.setCnaPatch("false");
        cnaInfo.setIsUpgradeMcna(false);
        cnaInfo.setCnaDriver(Boolean.toString(deployFcCnaBo.isCnaDriver()));
        cnaInfo.overrideDhcp(deployFcCnaBo.getDhcp());
        cnaInfo.setGandalfPassword(passwords.getOrDefault(deployFcCnaBo.getGandalfPwd(), ""));
        cnaInfo.setGrubPassword(passwords.getOrDefault(deployFcCnaBo.getGrubPwd(), ""));
        cnaInfo.setRootPassword(passwords.getOrDefault(deployFcCnaBo.getRootPwd(), ""));
        cnaInfo.setRedisPassword(passwords.getOrDefault(deployFcCnaBo.getRedisPwd(), ""));
        cnaInfo.setInstallType(deployFcCnaBo.getInstallType());
        cnaInfo.setCipherMode(StringUtils.defaultString((String)deployFcCnaBo.getCipherMode(), (String)"general"));
        cnaInfo.setAutoSwap(deployFcCnaBo.getAutoSwap());
        cnaInfo.setSwap(deployFcCnaBo.getSwapSize());
        cnaInfo.setSoftRaid(deployFcCnaBo.getSoftRaid());
        return cnaInfo;
    }

    private Map<String, String> encryptConfigPasswords(SshShellService shellService, DeployFcCnaBo deployFcCnaBo) throws BasicException {
        HashSet<String> plainTexts = new HashSet<String>(Arrays.asList(deployFcCnaBo.getRootPwd(), deployFcCnaBo.getGrubPwd(), deployFcCnaBo.getGandalfPwd(), deployFcCnaBo.getRedisPwd()));
        List<CnaInstallNodeBo> nodeBos = deployFcCnaBo.getNodes();
        if (nodeBos != null && !nodeBos.isEmpty()) {
            nodeBos.forEach(cnaNode -> plainTexts.add(cnaNode.getBmcPwd()));
        }
        return TaskUtils.encryptConfigPasswords(shellService, this.getTaskId(), plainTexts);
    }
}

