/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.cna;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.DeployPathBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.UploadPackageBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.cna.CnaInstallNodeBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.cna.DeployFcCnaBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.DeployTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.cna.CheckPowerStateSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.cna.ConfigCnaParamSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.cna.InstallCnaSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.cna.InstallPxeServiceSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.cna.RemoteFileCnaLogServiceImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.common.Switch2RootSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.common.UploadPackageSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeployTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.TaskResult;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployCnaTask
extends DeployTask<DeployFcCnaBo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployCnaTask.class);
    private static final String TASK_NAME_RES_KEY = "task.name.cna.task.deploy_cna";
    private DeployFcCnaBo deployFcCnaBo;
    private CheckPowerStateSubTask checkPowerStateSubTask;
    private Switch2RootSubTask switch2RootSubTask;
    private ConfigCnaParamSubTask configCnaParamSubTask;
    private UploadPackageSubTask uploadPackageSubTask;
    private InstallPxeServiceSubTask installPxeServiceSubTask;
    private InstallCnaSubTask installCnaSubTask;
    private RemoteFileCnaLogServiceImpl cnaLogService;

    public DeployCnaTask(String taskId, DeployFcCnaBo deployFcCnaBo) {
        super(taskId, TASK_NAME_RES_KEY);
        this.deployFcCnaBo = deployFcCnaBo;
        this.initializeSubTasks(taskId);
    }

    private void initializeSubTasks(String taskId) {
        this.checkPowerStateSubTask = new CheckPowerStateSubTask(this.getTaskId());
        this.appendSubTask(this.checkPowerStateSubTask, this::execCheckPowerStateSubTask);
        this.switch2RootSubTask = new Switch2RootSubTask(this.getTaskId());
        this.appendSubTask(this.switch2RootSubTask, this::execSwitch2RootSubTask);
        this.configCnaParamSubTask = new ConfigCnaParamSubTask(taskId);
        this.appendSubTask(this.configCnaParamSubTask, this::execConfigCnaParamSubTask);
        this.uploadPackageSubTask = new UploadPackageSubTask(taskId);
        this.appendSubTask(this.uploadPackageSubTask, this::execUploadCnaIsoPackageToRemoteSubTask);
        this.installPxeServiceSubTask = new InstallPxeServiceSubTask(taskId);
        this.appendSubTask(this.installPxeServiceSubTask, this::execInstallPxeServiceSubTask);
        this.installCnaSubTask = new InstallCnaSubTask(taskId);
        this.appendSubTask(this.installCnaSubTask, this::execInstallCnaSubTask);
    }

    private TaskResult execCheckPowerStateSubTask() {
        return this.checkPowerStateSubTask.apply(this.deployFcCnaBo);
    }

    private TaskResult execSwitch2RootSubTask() {
        return this.switch2RootSubTask.apply(DeployTaskManager.getManager().findRootPwd(this.getTaskId()));
    }

    private TaskResult execConfigCnaParamSubTask() {
        return this.configCnaParamSubTask.apply(this.deployFcCnaBo);
    }

    private TaskResult execUploadCnaIsoPackageToRemoteSubTask() {
        DeployPathBo pathBo = this.deployFcCnaBo.getPathBo();
        return this.uploadPackageSubTask.apply(UploadPackageBo.builder().packageType(3).remotePath(pathBo.getRemotePath()).installPath(pathBo.getInstallPath()).packageFile(pathBo.getPackageFile()).build());
    }

    private TaskResult execInstallPxeServiceSubTask() {
        String rootPwd = DeployTaskManager.getManager().findRootPwd(this.getTaskId());
        return this.installPxeServiceSubTask.apply(rootPwd);
    }

    private TaskResult execInstallCnaSubTask() {
        this.installCnaSubTask.buildChildNodeResultList(Optional.ofNullable(this.deployFcCnaBo.getNodes()).orElse(Collections.emptyList()));
        return this.installCnaSubTask.apply(this.deployFcCnaBo);
    }

    @Override
    public String getRemoteRunningLogs() {
        try {
            if (this.cnaLogService == null || !this.cnaLogService.isConnected()) {
                this.cnaLogService = new RemoteFileCnaLogServiceImpl(this.findShellService());
            }
            Optional<String> optionalLogs = this.cnaLogService.fetchConfigFile2Obj(this.getTaskId());
            log.info("read remote cna log, exist : {}.", (Object)optionalLogs.isPresent());
            return optionalLogs.orElse("");
        }
        catch (BasicException e) {
            log.error("read remote cna log failed.", (Throwable)e);
            return "";
        }
    }

    @Override
    protected boolean updateDeployParams(DeployFcCnaBo fcCnaBo) {
        if (fcCnaBo == null || fcCnaBo.getNodes() == null || this.deployFcCnaBo.getNodes() == null) {
            log.error("update deploy cna failed, cna or nodes is null.");
            return false;
        }
        fcCnaBo.getNodes().forEach(this::updateNewNodeUuid);
        this.deployFcCnaBo = fcCnaBo;
        this.installCnaSubTask.buildChildNodeResultList(fcCnaBo.getNodes());
        log.info("update deploy cna params!");
        return true;
    }

    private void updateNewNodeUuid(CnaInstallNodeBo nodeBo) {
        this.deployFcCnaBo.getNodes().stream().filter(existNodeBo -> Objects.equals(nodeBo.getBmcIp(), existNodeBo.getBmcIp())).findFirst().ifPresent(existNodeBo -> this.updateUuid(nodeBo, (CnaInstallNodeBo)existNodeBo));
    }

    private void updateUuid(CnaInstallNodeBo nodeBo, CnaInstallNodeBo existNodeBo) {
        nodeBo.setUuid(existNodeBo.getUuid());
        log.info("update cna node [{}] uuid:{}.", (Object)nodeBo.getBmcIp(), (Object)nodeBo.getUuid());
    }
}

