/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.cna;

import com.alibaba.fastjson.JSON;
import com.huawei.yinglong.river.sitedeployment.dcs.constant.TaskOperateEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.dto.TaskProgressDto;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.cna.CnaInstallNodeBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.cna.DeployFcCnaBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.config.ConfigCnaProgInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.config.ConfigCnaRunningListInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.config.ConfigInstallStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.FcErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.cna.RemoteFileCnaProgServiceImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.cna.RemoteFileCnaRunningListServiceImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeploySubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.TaskResult;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.TaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.CommandUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.ConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.TaskUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallCnaSubTask
extends DeploySubTask<DeployFcCnaBo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstallCnaSubTask.class);
    private static final String TASK_NAME_RES_KEY = "task.name.cna.subtask_install_cna";
    private static final String CNA_RUN_STATUS_INSTALL = "install";
    private static final String CNA_RUN_STATUS_STOP = "stop";
    private static final int DEFAULT_INSTALL_CNA_SIZE_EACH_BATCH = 10;
    private static final String KEY_INSTALL_CNA_SIZE = "deployfc.cna.max_install_size_each_batch";
    private static final long QUERY_CNA_PROGRESS_DELAY_TIME_SEC = 30L;
    private static final int DEX_CHECK_TASK_STATUS_WAIT_TIME_SEC = 30;
    private static final int DEFAULT_TIMEOUT_WAIT_CNA_INSTALL_EACH_BATCH = 45;
    private static final String KEY_WAIT_FOR_CNA_INSTALL_TIMEOUT = "deployfc.cna.max_wait_timeout_pxe_each_batch";
    private final DefaultSshEndJudge endJudge = new DefaultSshEndJudge();
    private RemoteFileCnaRunningListServiceImpl cnaRunningListService;
    private RemoteFileCnaProgServiceImpl cnaProgService;
    private ScheduledFuture<?> scheduledFuture;
    private String installPath;
    private ConfigCnaProgInfo lastCnaProgInfo;
    private final List<TaskResult> childCnaResults = new LinkedList<TaskResult>();
    private int waitForCnaInstallEachBatchTimeout = 45;
    private int installCnaSizeInEachBatch = 10;
    private final Callable<Boolean> checkTaskFinishStatus = () -> {
        while (!this.checkTaskFinish()) {
            ThreadUtils.threadSafeSleep((int)30, (TimeUnit)TimeUnit.SECONDS);
        }
        return this.checkTaskSuccessfully();
    };

    public InstallCnaSubTask(String taskId) {
        super(taskId, TASK_NAME_RES_KEY);
    }

    private StringBuilder createDetails(CnaInstallNodeBo nodeBo) {
        return new StringBuilder().append("UUID:").append(nodeBo.getUuid()).append(System.lineSeparator()).append("BMC IP:").append(nodeBo.getBmcIp()).append(System.lineSeparator()).append("OS IP:").append(nodeBo.getHostIp()).append(System.lineSeparator());
    }

    private boolean checkTaskFinish() {
        return this.childCnaResults.stream().allMatch(TaskResult::isFinished);
    }

    private boolean checkTaskSuccessfully() {
        return this.childCnaResults.stream().allMatch(TaskResult::isSuccessfully);
    }

    @Override
    public boolean skipTaskStep(String uuid) {
        if (super.skipTaskStep(uuid)) {
            return true;
        }
        Optional<TaskResult> opTaskResult = this.childCnaResults.stream().filter(TaskResult::isFailed).filter(taskResult -> Objects.equals(taskResult.getUuid(), uuid)).findFirst();
        if (!opTaskResult.isPresent()) {
            return false;
        }
        opTaskResult.get().setTaskStatus(TaskStatus.SKIP).setTaskFinishTime(System.currentTimeMillis());
        if (this.checkTaskSuccessfully()) {
            this.taskResult.setTaskStatus(TaskStatus.END).setTaskFinishTime(System.currentTimeMillis());
        }
        return true;
    }

    @Override
    public List<TaskProgressDto> getChildTaskProgress() {
        return this.childCnaResults.stream().map(this::buildTaskProgressByResult).collect(Collectors.toList());
    }

    @Override
    protected void clearFailedStatus() {
        super.clearFailedStatus();
        this.childCnaResults.stream().filter(TaskResult::isFailed).forEach(taskResult -> taskResult.setTaskStatus(TaskStatus.NOT_START).setTaskFinishTime(0L).setMessage("").clearDetail());
    }

    private void initInstallConfigParams(DeployFcCnaBo deployFcCnaBo) {
        this.installPath = deployFcCnaBo.getPathBo().getInstallPath();
        this.waitForCnaInstallEachBatchTimeout = ConfigUtils.getPropertiesValue(KEY_WAIT_FOR_CNA_INSTALL_TIMEOUT, 45);
        this.waitForCnaInstallEachBatchTimeout = Math.max(1, this.waitForCnaInstallEachBatchTimeout);
        this.installCnaSizeInEachBatch = ConfigUtils.getPropertiesValue(KEY_INSTALL_CNA_SIZE, 10);
        this.installCnaSizeInEachBatch = Math.max(1, this.installCnaSizeInEachBatch);
        log.info("init install cna params, waitForTimeout={}, installSize={}.", (Object)this.waitForCnaInstallEachBatchTimeout, (Object)this.installCnaSizeInEachBatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean executeSubTask(DeployFcCnaBo deployFcCnaBo) throws BasicException {
        try {
            this.initInstallConfigParams(deployFcCnaBo);
            String command = CommandUtils.getLanguageCommand("cnaInstaller start");
            if (!this.executeDeployCnaCommand(command)) {
                log.error("start cna installer failed.");
                this.setTaskFailed(FcErrorCode.COMMAND_EXECUTE_EXCEPTION, Collections.singletonList(command));
                boolean bl = false;
                return bl;
            }
            List<TaskResult> nextBatchCnas = this.queryNextInstallBatchCna();
            if (nextBatchCnas == null || nextBatchCnas.isEmpty()) {
                log.error("there is not install cna item.");
                boolean bl = true;
                return bl;
            }
            if (!this.startInstallNextBatchCna(nextBatchCnas)) {
                log.error("start next install batch cna failed, size={}", (Object)nextBatchCnas.size());
                boolean bl = false;
                return bl;
            }
            boolean bl = this.waitInstallResults();
            return bl;
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("query cna pxe progress execution or interrupted failed.", (Throwable)e);
            this.setRunningTaskStatuFailed(e.getMessage());
            this.setTaskFailed(FcErrorCode.TASK_EXECUTE_FAILED, Arrays.asList("CNA", e.getMessage()));
            this.appendDetail("[exception]", "happened execution or interrupted failed.");
            boolean bl = false;
            return bl;
        }
        catch (TimeoutException e) {
            log.error("query cna pxe progress timeout failed.", (Throwable)e);
            this.setRunningTaskStatuFailed(FcErrorCode.TASK_PXE_CNA_WAIT_TIMEOUT.getErrorMessage());
            this.setTaskFailed(FcErrorCode.TASK_PXE_CNA_WAIT_TIMEOUT, Collections.emptyList());
            this.appendDetail("[timeout]", "wait for cna pxe install timeout.");
            boolean bl = false;
            return bl;
        }
        finally {
            this.tryToStopCnaInstallTask();
        }
    }

    private boolean waitInstallResults() throws InterruptedException, ExecutionException, TimeoutException {
        this.scheduledFuture = ThreadUtils.scheduleWithFixedDelay((Runnable)new QueryCnaProgressThread(), (long)30L, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        Future future = ThreadUtils.submit(this.checkTaskFinishStatus);
        int waitForTime = this.waitForCnaInstallEachBatchTimeout * (int)Math.ceil((double)this.childCnaResults.size() * 1.0 / (double)this.installCnaSizeInEachBatch);
        log.info("prepare to wait for install cna result, time={}.", (Object)waitForTime);
        this.appendDetail("[wait pxe install]", StringUtils.formatTxt((String)"start to wait for pxe in %d minutes.", (Object[])new Object[]{waitForTime}));
        boolean isSuccess = (Boolean)future.get(waitForTime, TimeUnit.MINUTES);
        log.info("wait for cna install task, result = {}.", (Object)isSuccess);
        if (!isSuccess) {
            this.setRunningTaskStatuFailed(FcErrorCode.TASK_PXE_CNA_WAIT_TIMEOUT.getErrorMessage());
        }
        return isSuccess;
    }

    private void tryToStopCnaInstallTask() {
        try {
            this.cancelScheduleTask();
            this.executeDeployCnaCommand(CommandUtils.getLanguageCommand("cnaInstaller finish"));
        }
        catch (BasicException e) {
            log.error("execute cna finish failed.", (Throwable)e);
        }
    }

    private void setRunningTaskStatuFailed(String message) {
        this.childCnaResults.stream().filter(TaskResult::isRunning).forEach(result -> this.setChildCurrentTaskStatus(TaskStatus.ERROR, message));
        this.childCnaResults.stream().filter(TaskResult::isFailed).findFirst().ifPresent(this::setTaskFailed);
    }

    private void cancelScheduleTask() {
        if (this.scheduledFuture != null && !this.scheduledFuture.isCancelled()) {
            this.scheduledFuture.cancel(true);
        }
    }

    private boolean executeDeployCnaCommand(String cmd) throws BasicException {
        SshShellService shellService = this.findShellService();
        if (TaskUtils.switchUser2Root(shellService, this.getTaskId())) {
            String result = this.findShellService().execCommand(cmd, (SshEndJudge)this.endJudge);
            this.appendDetail(cmd, result);
            log.info("execute [{}], result = {}.", (Object)cmd, (Object)result);
            return true;
        }
        return false;
    }

    private List<TaskResult> queryNextInstallBatchCna() {
        return this.childCnaResults.stream().filter(TaskResult::isNotStarted).limit(this.installCnaSizeInEachBatch).collect(Collectors.toList());
    }

    private boolean startInstallNextBatchCna(List<TaskResult> taskResults) throws BasicException {
        ConfigCnaRunningListInfo runningListInfo = new ConfigCnaRunningListInfo();
        runningListInfo.setLists(taskResults.stream().collect(Collectors.toMap(TaskResult::getTaskId, taskResult -> new ConfigCnaRunningListInfo.CnaRunningItemInfo().setAction(CNA_RUN_STATUS_INSTALL).setCache(UUID.randomUUID().toString()))));
        if (this.cnaRunningListService == null || !this.cnaRunningListService.isConnected()) {
            this.cnaRunningListService = new RemoteFileCnaRunningListServiceImpl(this.findSftpService(), this.installPath);
        }
        boolean isSuccessfully = this.cnaRunningListService.commitObj2ConfigFile(this.getTaskId(), runningListInfo);
        log.info("save cna running list json result = {}.", (Object)isSuccessfully);
        if (!isSuccessfully) {
            this.setTaskFailed(FcErrorCode.CONFIG_FILE_COMMIT_FAILED, Collections.singletonList(this.cnaRunningListService.getRemoteConfigFile()));
            return false;
        }
        String cnaNames = taskResults.stream().peek(taskResult -> taskResult.setTaskStatus(TaskStatus.RUNNING).setTaskBeginTime(System.currentTimeMillis())).map(TaskResult::getTaskName).collect(Collectors.joining(","));
        this.appendDetail("[config cna running list]", StringUtils.formatTxt((String)"start to install cna(%s).", (Object[])new Object[]{cnaNames}));
        return true;
    }

    private void setChildCurrentTaskStatus(TaskStatus status, String message) {
        this.childCnaResults.stream().filter(TaskResult::isRunning).forEach(cnaResult -> cnaResult.setTaskStatus(status).setTaskFinishTime(System.currentTimeMillis()).setMessage(message));
    }

    private void updateTaskStatus(String uuid, TaskStatus status, String message) {
        this.childCnaResults.stream().filter(TaskResult::isRunning).filter(cnaResult -> Objects.equals(cnaResult.getTaskId(), uuid)).findFirst().ifPresent(cnaResult -> this.realUpdateChildTaskStatus(uuid, status, message, (TaskResult)cnaResult));
    }

    private void realUpdateChildTaskStatus(String uuid, TaskStatus status, String message, TaskResult cnaResult) {
        cnaResult.setTaskStatus(status).setMessage(message);
        if (status == TaskStatus.END || status == TaskStatus.ERROR) {
            cnaResult.setTaskFinishTime(System.currentTimeMillis());
        } else if (status == TaskStatus.RUNNING) {
            if (cnaResult.getTaskBeginTime() == 0L) {
                cnaResult.setTaskBeginTime(System.currentTimeMillis());
            } else if (cnaResult.getTaskCostTime() > TimeUnit.MINUTES.toMillis(this.waitForCnaInstallEachBatchTimeout)) {
                cnaResult.setTaskStatus(TaskStatus.ERROR).setTaskFinishTime(System.currentTimeMillis()).setMessage(FcErrorCode.TASK_PXE_CNA_WAIT_TIMEOUT.getErrorMessage());
            } else {
                log.info("running status check.");
            }
        } else {
            log.info("other status, uuid={}, status={}, message={}.", new Object[]{uuid, status, message});
        }
    }

    private boolean checkNeedInstallNextCnaList() {
        return this.childCnaResults.stream().noneMatch(TaskResult::isRunning);
    }

    private void tryToStartInstallNextBatch(ConfigCnaProgInfo cnaProgInfo) throws BasicException {
        if (!this.checkNeedInstallNextCnaList()) {
            log.warn("not need to install next batch cna list.");
            return;
        }
        log.info("start to next batch cna install.");
        List<TaskResult> taskResults = this.queryNextInstallBatchCna();
        if (taskResults == null || taskResults.isEmpty()) {
            log.info("there is not next batch cna node.");
            this.cancelScheduleTask();
            return;
        }
        if (!this.startInstallNextBatchCna(taskResults)) {
            log.error("start next batch cna failed.");
            this.setChildCurrentTaskStatus(TaskStatus.ERROR, cnaProgInfo.getMessage());
            this.cancelScheduleTask();
        }
    }

    private void recordCnaProgressChanged2Details(ConfigCnaProgInfo cnaProgInfo) {
        if (!Objects.equals(this.lastCnaProgInfo, cnaProgInfo)) {
            this.appendDetail("[query cna progress]", JSON.toJSONString((Object)cnaProgInfo));
            this.lastCnaProgInfo = cnaProgInfo;
            log.info("record cna progress, current task status : {}.", (Object)this.lastCnaProgInfo.getStatus());
        }
    }

    private Optional<ConfigCnaProgInfo> fetchConfigCnaProgInfo() throws BasicException {
        if (this.cnaProgService == null || !this.cnaProgService.isConnected()) {
            this.cnaProgService = new RemoteFileCnaProgServiceImpl(this.findSftpService(), this.installPath);
        }
        return this.cnaProgService.fetchConfigFile2Obj(this.getTaskId());
    }

    private void updateCnaDeployStatus(ConfigCnaProgInfo cnaProgInfo) {
        ConfigInstallStatus status = ConfigInstallStatus.of(cnaProgInfo.getStatus());
        if (status == ConfigInstallStatus.TASK_ERROR || status == ConfigInstallStatus.TASK_FAILED) {
            this.setChildCurrentTaskStatus(TaskStatus.ERROR, cnaProgInfo.getMessage());
            this.setTaskFailed(FcErrorCode.TASK_EXECUTE_FAILED, Arrays.asList("CNA", cnaProgInfo.getMessage()));
            this.cancelScheduleTask();
        } else if ((status == ConfigInstallStatus.TASK_FINISHED || status == ConfigInstallStatus.TASK_SUCCESS) && "100".equalsIgnoreCase(cnaProgInfo.getProgress())) {
            this.setChildCurrentTaskStatus(TaskStatus.END, null);
            this.setTaskSuccess();
            this.cancelScheduleTask();
        } else if (this.checkTaskFinish()) {
            this.cancelScheduleTask();
        } else {
            log.info("other scene, continue to query, status = {}.", (Object)status);
        }
    }

    void updateCnaNodeStatus(ConfigCnaProgInfo cnaProgInfo) {
        Map<String, ConfigCnaProgInfo.CnaNodeParam> cnaList = cnaProgInfo.getCnaList();
        if (cnaList != null && !cnaList.isEmpty()) {
            cnaList.forEach((key, value) -> {
                ConfigInstallStatus installStatus = ConfigInstallStatus.of(value.getStatus());
                if (ConfigInstallStatus.of(cnaProgInfo.getStatus()) != ConfigInstallStatus.TASK_RUNNING && (installStatus == ConfigInstallStatus.TASK_ERROR || installStatus == ConfigInstallStatus.TASK_FAILED)) {
                    this.updateTaskStatus((String)key, TaskStatus.ERROR, cnaProgInfo.getMessage());
                } else if (installStatus == ConfigInstallStatus.TASK_FINISHED || installStatus == ConfigInstallStatus.TASK_SUCCESS) {
                    this.updateTaskStatus((String)key, TaskStatus.END, cnaProgInfo.getMessage());
                } else {
                    this.updateTaskStatus((String)key, TaskStatus.RUNNING, cnaProgInfo.getMessage());
                }
            });
        }
    }

    void buildChildNodeResultList(List<CnaInstallNodeBo> nodeBos) {
        log.info("update new node, result size = {},node size = {}.", (Object)this.childCnaResults.size(), (Object)nodeBos.size());
        List<TaskResult> newTaskResults = this.createTaskResultList(nodeBos);
        if (this.childCnaResults.isEmpty()) {
            this.childCnaResults.addAll(newTaskResults);
            log.info("create first child cna result.");
            return;
        }
        newTaskResults.forEach(this::updateSameTaskResultMessage);
        this.childCnaResults.clear();
        this.childCnaResults.addAll(newTaskResults);
        log.info("update new node to install, result size = {}.", (Object)this.childCnaResults.size());
    }

    private List<TaskResult> createTaskResultList(List<CnaInstallNodeBo> nodeBos) {
        return nodeBos.stream().filter(node -> !node.isMaster()).map(node -> new TaskResult().setUuid(node.getBmcIp()).setTaskId(node.getUuid()).setTaskName(node.getHostName()).setDurationTime(this.getDurationTime(TASK_NAME_RES_KEY)).setDetail(this.createDetails((CnaInstallNodeBo)node)).addActions(TaskOperateEnum.SKIP).setSkipMsg(FcErrorCode.SKIP_CNA_NODE.getSuggestMessage()).setTaskStatus(TaskStatus.NOT_START)).collect(Collectors.toList());
    }

    private void updateSameTaskResultMessage(TaskResult taskResult) {
        this.childCnaResults.stream().filter(existTaskResult -> Objects.equals(taskResult.getUuid(), existTaskResult.getUuid())).findFirst().ifPresent(existTaskResult -> this.updateExistTaskResult2NewTaskResult(taskResult, (TaskResult)existTaskResult));
    }

    private void updateExistTaskResult2NewTaskResult(TaskResult taskResult, TaskResult existTaskResult) {
        taskResult.setTaskBeginTime(existTaskResult.getTaskBeginTime()).setTaskFinishTime(existTaskResult.getTaskFinishTime()).setMessage(existTaskResult.getMessage()).setSuggestion(existTaskResult.getSuggestion()).setTaskStatus(existTaskResult.getTaskStatus()).setTaskId(existTaskResult.getTaskId());
        if (StringUtils.isNotEmpty((CharSequence)existTaskResult.getDetail())) {
            taskResult.setDetail(existTaskResult.getDetail());
        }
    }

    private class QueryCnaProgressThread
    implements Runnable {
        private QueryCnaProgressThread() {
        }

        @Override
        public void run() {
            try {
                Optional opCnaProgInfo = InstallCnaSubTask.this.fetchConfigCnaProgInfo();
                if (!opCnaProgInfo.isPresent()) {
                    log.error("cna fetch progress config file is failed.");
                    return;
                }
                ConfigCnaProgInfo cnaProgInfo = (ConfigCnaProgInfo)opCnaProgInfo.get();
                InstallCnaSubTask.this.recordCnaProgressChanged2Details(cnaProgInfo);
                InstallCnaSubTask.this.updateCnaNodeStatus(cnaProgInfo);
                InstallCnaSubTask.this.updateCnaDeployStatus(cnaProgInfo);
                InstallCnaSubTask.this.tryToStartInstallNextBatch(cnaProgInfo);
            }
            catch (BasicException e) {
                log.error("query vrm progress failed.", (Throwable)e);
            }
        }
    }
}

