/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.cna;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.FcErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeploySubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.CommandUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.TaskUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshErrParser;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallPxeServiceSubTask
extends DeploySubTask<String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstallPxeServiceSubTask.class);
    private static final String TASK_NAME_RES_KEY = "task.name.cna.subtask_install_pxe_service";
    private final DefaultSshEndJudge endJudge = new DefaultSshEndJudge();

    public InstallPxeServiceSubTask(String taskId) {
        super(taskId, TASK_NAME_RES_KEY);
    }

    @Override
    protected boolean canBeSkipTask() {
        return false;
    }

    @Override
    protected boolean executeSubTask(String rootPwd) throws BasicException {
        SshShellService shellService = this.findShellService();
        String cmd = CommandUtils.getLanguageCommand("cnaInstaller config");
        String result = shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
        this.appendDetail(cmd, result);
        log.info("execute [{}], result = {}.", (Object)cmd, (Object)result);
        if (SshErrParser.isInvalidResult((String)result)) {
            this.setTaskFailed(FcErrorCode.COMMAND_EXECUTE_FAILED, Arrays.asList(cmd, result));
            return false;
        }
        return !StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Password:"}) || this.handleInputRootPassword(rootPwd, shellService);
    }

    private boolean handleInputRootPassword(String rootPwd, SshShellService shellService) throws SshException {
        String result = shellService.execCommand(StringUtils.defaultString((String)rootPwd), (SshEndJudge)this.endJudge);
        String logResult = TaskUtils.replaceSensitiveTexts(result, rootPwd);
        this.appendDetail("\u3010Root Password\u3011", logResult);
        log.info("execute [root password], result = {}.", (Object)logResult);
        if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Password:"})) {
            result = shellService.execCommand(StringUtils.defaultString((String)rootPwd), (SshEndJudge)this.endJudge);
            logResult = TaskUtils.replaceSensitiveTexts(result, rootPwd);
            this.appendDetail("\u3010Root Password Again\u3011", logResult);
            log.info("execute [root password again], result = {}.", (Object)logResult);
        }
        if (SshErrParser.isInvalidResult((String)result)) {
            this.setTaskFailed(FcErrorCode.COMMAND_EXECUTE_EXCEPTION, Collections.singletonList("pxe password"));
            return false;
        }
        return true;
    }
}

