/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.common;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.CnaInitBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.FcErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeploySubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.TaskUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.ValidationMsgUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshErrParser;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshManager;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.sshd.client.session.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CnaInitSubTask
extends DeploySubTask<CnaInitBo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CnaInitSubTask.class);
    private static final String TASK_NAME_RES_KEY = "task.name.common.subtask.cna_init";
    private final DefaultSshEndJudge endJudge = new DefaultSshEndJudge();

    public CnaInitSubTask(String taskId) {
        super(taskId, TASK_NAME_RES_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected boolean executeSubTask(CnaInitBo cnaInitBo) throws BasicException {
        block8: {
            block7: {
                block6: {
                    session = null;
                    shellService = null;
                    session = this.createSshConnectSession(cnaInitBo);
                    shellService = SshManager.createSshShellService((ClientSession)session);
                    shellService.connect();
                    CnaInitSubTask.log.info("create ssh shell connection successfully, bmcIp={}, osIp={}.", (Object)cnaInitBo.getBmcHostIp(), (Object)cnaInitBo.getOsHostIp());
                    if (!cnaInitBo.hasBmcInfo()) break block6;
                    if (this.executeCnaInitFromIBMC(cnaInitBo, shellService)) ** GOTO lbl30
                    var4_4 = false;
                    SshManager.releaseConnService((SshConnService)shellService);
                    SshManager.releaseSession((ClientSession)session);
                    return var4_4;
                }
                if (TaskUtils.switchUser2Root(shellService, this.getTaskId())) break block7;
                CnaInitSubTask.log.error("user change to root failed.");
                this.setTaskFailed(FcErrorCode.COMMAND_EXECUTE_EXCEPTION, Collections.singletonList("su root"));
                var4_5 = false;
                SshManager.releaseConnService((SshConnService)shellService);
                SshManager.releaseSession((ClientSession)session);
                return var4_5;
            }
            try {
                this.cleanInstallerWebServiceEnv(shellService);
lbl30:
                // 2 sources

                if (this.openSftpService(cnaInitBo, shellService)) break block8;
                var4_6 = false;
            }
            catch (SshException e) {
                try {
                    CnaInitSubTask.log.error("ssh connect failed.", (Throwable)e);
                    this.setTaskFailed((BasicException)e);
                    var5_8 = false;
                }
                catch (Throwable var6_9) {
                    SshManager.releaseConnService(shellService);
                    SshManager.releaseSession((ClientSession)session);
                    throw var6_9;
                }
                SshManager.releaseConnService((SshConnService)shellService);
                SshManager.releaseSession((ClientSession)session);
                return var5_8;
            }
            SshManager.releaseConnService((SshConnService)shellService);
            SshManager.releaseSession((ClientSession)session);
            return var4_6;
        }
        SshManager.releaseConnService((SshConnService)shellService);
        SshManager.releaseSession((ClientSession)session);
        return true;
    }

    private boolean openSftpService(CnaInitBo cnaInitBo, SshShellService shellService) throws SshException {
        if (cnaInitBo.isOpenSftp() && !this.switchSftpService(shellService, true)) {
            this.setTaskFailed(FcErrorCode.COMMAND_EXECUTE_EXCEPTION, Collections.singletonList("configSshSftp.sh open"));
            log.error("open sftp service failed.");
            return false;
        }
        return true;
    }

    private void cleanInstallerWebServiceEnv(SshShellService shellService) throws SshException {
        String cmd = "rm -f /tmp/installer_work_process.pid";
        String result = shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
        this.appendDetail(cmd, result);
        log.info("execute [{}] to remove pid file, result = {}.", (Object)cmd, (Object)result);
        cmd = "webInstaller uninstall";
        result = shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
        this.appendDetail(cmd, result);
        log.info("execute [{}] to uninstall fc web, result = {}.", (Object)cmd, (Object)result);
        cmd = StringUtils.formatTxt((String)"rm -rf %s", (Object[])new Object[]{FilePathValidatorUtils.createLinuxPaths((String)"/home/GalaX8800", (String[])new String[]{"*"})});
        result = shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
        this.appendDetail(cmd, result);
        log.info("execute [{}] to delete files, result = {}.", (Object)cmd, (Object)result);
    }

    private boolean executeCnaInitFromIBMC(CnaInitBo cnaInitBo, SshShellService shellService) throws BasicException {
        if (!this.changeBmcToOsEnvironment(shellService, cnaInitBo)) {
            log.error("change bmc to os failed.");
            return false;
        }
        if (!this.checkPasswordWeak(shellService, cnaInitBo)) {
            log.error("check password weak failed.");
            return false;
        }
        if (!this.changeGrub2Pwd(shellService, cnaInitBo.getGrubPwd())) {
            log.error("change grub2 text failed.");
            return false;
        }
        return this.configCnaInitPassword(cnaInitBo.getCipherMode(), cnaInitBo.getGandalfPwd(), cnaInitBo.getRedisPwd(), shellService);
    }

    private boolean checkPasswordWeak(SshShellService shellService, CnaInitBo cnaInitBo) throws BasicException {
        HashMap<String, String> pwdMaps = new HashMap<String, String>();
        pwdMaps.put(ValidationMsgUtils.getString("cna.rootPwd"), cnaInitBo.getRootPwd());
        pwdMaps.put(ValidationMsgUtils.getString("cna.gandalfPwd"), cnaInitBo.getGandalfPwd());
        pwdMaps.put(ValidationMsgUtils.getString("cna.grubPwd"), cnaInitBo.getGrubPwd());
        pwdMaps.put(ValidationMsgUtils.getString("cna.redisPwd"), cnaInitBo.getRedisPwd());
        String invalidMsg = String.join((CharSequence)",", TaskUtils.getInvalidPasswordParamNames(shellService, pwdMaps));
        if (StringUtils.isNotEmpty((CharSequence)invalidMsg)) {
            this.setTaskFailed(FcErrorCode.TASK_PASSWORD_TOO_WEAK, Collections.singletonList(invalidMsg));
            log.error("check weak pwd failed, {}.", (Object)invalidMsg);
            return false;
        }
        return true;
    }

    private boolean changeGrub2Pwd(SshShellService shellService, String grubPwd) throws SshException {
        String cmd = "grub2-mkpasswd-pbkdf2";
        String result = shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
        log.info("execute [{}], result = {}.", (Object)cmd, (Object)result);
        if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Enter password:"})) {
            result = shellService.execCommand(grubPwd, (SshEndJudge)this.endJudge);
            String logResult = TaskUtils.replaceSensitiveTexts(result, grubPwd);
            log.info("execute [grub text], result = {}.", (Object)logResult);
        }
        if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Reenter password:"})) {
            result = shellService.execCommand(grubPwd, (SshEndJudge)this.endJudge);
            log.info("execute [grub text again], result not log.");
        }
        if (!StringUtils.containIgnoreCase((String)result, (String[])new String[]{"PBKDF2 hash of your password is"})) {
            log.error("make grub2 text failed, {}.", (Object)result);
            this.setTaskFailed(FcErrorCode.COMMAND_EXECUTE_FAILED, Arrays.asList(cmd, result));
            return false;
        }
        log.info("make grub2 text successfully.");
        String grubEncPwd = this.parseGeneratedGrub2Pwd(result);
        if (StringUtils.isEmpty((CharSequence)grubEncPwd)) {
            log.error("parse generate grub2 text failed.");
            return false;
        }
        if (this.isGrub2FileExist(shellService, "ls /etc/grub2.cfg")) {
            this.replaceGrubPwd(shellService, "sed -i '/^password_pbkdf2 root /cpassword_pbkdf2 root %s' /etc/grub2.cfg", grubEncPwd);
            log.info("replace grub2.cfg grub text.");
        }
        if (this.isGrub2FileExist(shellService, "ls /etc/grub2-efi.cfg")) {
            this.replaceGrubPwd(shellService, "sed -i '/^password_pbkdf2 root /cpassword_pbkdf2 root %s' /etc/grub2-efi.cfg", grubEncPwd);
            log.info("replace grub2-efi.cfg grub text.");
        }
        return true;
    }

    private void replaceGrubPwd(SshShellService shellService, String cmd, String grubEncPwd) throws SshException {
        String result = shellService.execCommand(StringUtils.formatTxt((String)cmd, (Object[])new Object[]{grubEncPwd}), (SshEndJudge)this.endJudge);
        String logResult = TaskUtils.replaceSensitiveTexts(result, grubEncPwd);
        log.info("execute [replace grub2 text], result = {}.", (Object)logResult);
    }

    private boolean isGrub2FileExist(SshShellService shellService, String cmd) throws SshException {
        String result = shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
        this.appendDetail(cmd, result);
        log.info("execute [{}], result = {}.", (Object)cmd, (Object)result);
        return !SshErrParser.isInvalidResult((String)result);
    }

    private String parseGeneratedGrub2Pwd(String result) {
        return Stream.of(result.split("\n")).filter(line -> line.contains("grub.pbkdf2.sha512")).map(line -> line.substring(line.indexOf("grub.pbkdf2.sha512"))).findFirst().orElse("");
    }

    private boolean configCnaInitPassword(String cipherMode, String gandalfPwd, String redisPwd, SshShellService shellService) throws SshException {
        Optional<String> opResult = this.configGandalfPassword(cipherMode, gandalfPwd, shellService);
        if (!opResult.isPresent()) {
            log.error("config gandalf text failed.");
            return false;
        }
        if (!StringUtils.containIgnoreCase((String)opResult.get(), (String[])new String[]{"Redis password set start", "Please input new password:"})) {
            return true;
        }
        return this.configRedisPassword(redisPwd, shellService);
    }

    private Optional<String> configGandalfPassword(String cipherMode, String gandalfPwd, SshShellService shellService) throws SshException {
        String logResult;
        String cmd = "TMOUT=0";
        String result = shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
        this.appendDetail(cmd, result);
        log.info("execute [TMOUT=0], result = {}.", (Object)result);
        result = shellService.execCommand("cnaInit", (SshEndJudge)this.endJudge);
        this.appendDetail("cnaInit", result);
        log.info("execute [cnaInit], result = {}.", (Object)result);
        if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Please input cipher mode: (0 for general, 1 for sm):"})) {
            cmd = Objects.equals("general", cipherMode) ? "0" : "1";
            result = shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
            this.appendDetail(cmd, result);
            log.info("execute [cipher mode], result = {}.", (Object)result);
        }
        if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Reset gandalf password? [Y/N]"})) {
            result = shellService.execCommand("Y", (SshEndJudge)this.endJudge);
            this.appendDetail("Y", result);
            log.info("execute [Y] to reset gandalf password, result = {}.", (Object)result);
        }
        if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"New password:"})) {
            result = shellService.execCommand(gandalfPwd, (SshEndJudge)this.endJudge);
            logResult = TaskUtils.replaceSensitiveTexts(result, gandalfPwd);
            this.appendDetail("\u3010gandalf Password\u3011", logResult);
            log.info("execute [gandalf password], result = {}.", (Object)logResult);
        }
        if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Retype new password:"})) {
            result = shellService.execCommand(gandalfPwd, (SshEndJudge)this.endJudge);
            logResult = TaskUtils.replaceSensitiveTexts(result, gandalfPwd);
            this.appendDetail("\u3010gandalf Password again\u3011", logResult);
            log.info("execute [gandalf password again], result = {}.", (Object)logResult);
        }
        if (!StringUtils.containIgnoreCase((String)result, (String[])new String[]{"successfully", "Password has been already used"})) {
            this.setTaskFailed(FcErrorCode.COMMAND_EXECUTE_EXCEPTION, Collections.singletonList("Gandalf Password"));
            return Optional.empty();
        }
        return Optional.of(result);
    }

    private boolean configRedisPassword(String redisPwd, SshShellService shellService) throws SshException {
        String result = shellService.execCommandWithTimeout(redisPwd, (int)TimeUnit.MINUTES.toSeconds(1L), (SshEndJudge)this.endJudge);
        String logResult = TaskUtils.replaceSensitiveTexts(result, redisPwd);
        this.appendDetail("\u3010redis password\u3011", logResult);
        log.info("execute [redis password], result = {}.", (Object)logResult);
        if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Please input new password again:"})) {
            result = shellService.execCommand(redisPwd, (SshEndJudge)this.endJudge);
            logResult = TaskUtils.replaceSensitiveTexts(result, redisPwd);
            this.appendDetail("\u3010redis password again\u3011", logResult);
            log.info("execute [redis password again], result = {}.", (Object)logResult);
        }
        if (!StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Redis password set succeed"})) {
            this.setTaskFailed(FcErrorCode.COMMAND_EXECUTE_EXCEPTION, Collections.singletonList("Redis Password"));
            return false;
        }
        return true;
    }

    private ClientSession createSshConnectSession(CnaInitBo cnaInitBo) throws SshException {
        SshConnInfo sshConnInfo = cnaInitBo.hasBmcInfo() ? SshConnInfo.builder().hostName(cnaInitBo.getBmcHostIp()).userName(cnaInitBo.getBmcUserName()).userPwd(cnaInitBo.getBmcUserPwd()).build() : SshConnInfo.builder().hostName(cnaInitBo.getOsHostIp()).userName("gandalf").userPwd(cnaInitBo.getGandalfPwd()).build();
        return SshManager.getSession((SshConnInfo)sshConnInfo);
    }

    private boolean changeBmcToOsEnvironment(SshShellService shellService, CnaInitBo cnaInitBo) throws SshException {
        String cmd = StringUtils.formatTxt((String)"ipmcset -t sol -d activate -v %s", (Object[])new Object[]{"1 1"});
        String result = shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
        this.appendDetail(cmd, result);
        log.info("execute [{}], result = {}.", (Object)cmd, (Object)result);
        if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Current SOL session is in private mode"})) {
            cmd = StringUtils.formatTxt((String)"ipmcset -t sol -d activate -v %s", (Object[])new Object[]{"1 0"});
            result = shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
            this.appendDetail(cmd, result);
            log.info("execute [{}], result = {}.", (Object)cmd, (Object)result);
        }
        if (!StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Connect SOL successfully"})) {
            this.setTaskFailed(FcErrorCode.COMMAND_EXECUTE_EXCEPTION, Collections.singletonList("ipmcset"));
            return false;
        }
        try {
            result = this.loginOsSystem(shellService, cnaInitBo);
        }
        catch (SshException e) {
            log.error("login os system failed.", (Throwable)e);
            this.setTaskFailed(FcErrorCode.GETTY_SERVICE_START_FAILED, Collections.emptyList());
            return false;
        }
        if (!StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Last login:", "#"})) {
            this.setTaskFailed(FcErrorCode.COMMAND_EXECUTE_EXCEPTION, Collections.singletonList("Password"));
            return false;
        }
        return true;
    }

    private String loginOsSystem(SshShellService shellService, CnaInitBo cnaInitBo) throws SshException {
        ThreadUtils.threadSafeSleep((int)2, (TimeUnit)TimeUnit.SECONDS);
        String cmd = "";
        String result = shellService.execCommandWithTimeout(cmd, (int)TimeUnit.MINUTES.toSeconds(1L), (SshEndJudge)this.endJudge);
        this.appendDetail(cmd, result);
        log.info("execute [ENTER], result = {}.", (Object)result);
        if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"login:"})) {
            result = shellService.execCommand("root", (SshEndJudge)this.endJudge);
            this.appendDetail("root", result);
            log.info("execute [root], result = {}.", (Object)result);
        }
        if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Password:", "Please input new password:"})) {
            result = shellService.execCommand(cnaInitBo.getRootPwd(), (SshEndJudge)this.endJudge);
            String logResult = TaskUtils.replaceSensitiveTexts(result, cnaInitBo.getRootPwd());
            this.appendDetail("\u3010Root Password\u3011", logResult);
            log.info("execute [root text], result = {}.", (Object)logResult);
        }
        return result;
    }
}

