/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.common;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.UploadPackageBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.FcErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeploySubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.FileUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.TaskUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshErrParser;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.UploadFileProgCallBack;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.NumberUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadPackageSubTask
extends DeploySubTask<UploadPackageBo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UploadPackageSubTask.class);
    private static final String TASK_NAME_RES_KEY = "task.name.common.subtask.upload_package";
    private static final int DISK_FILE_RATE = 2;

    public UploadPackageSubTask(String taskId) {
        super(taskId, TASK_NAME_RES_KEY);
    }

    private boolean checkRemoteRemainSpace(SshShellService shellService, String remotePath, long fileSize) throws SshException {
        long recoverableSpaceSize = this.getRecoverableSpaceSize(shellService, remotePath);
        long remainSpace = this.getRemainSpace(shellService, remotePath, fileSize);
        return fileSize * 2L <= remainSpace + recoverableSpaceSize;
    }

    private long getRemainSpace(SshShellService shellService, String remotePath, long fileSize) throws SshException {
        String cmd = StringUtils.formatTxt((String)"df %s | awk '{print $4}' | grep -v 'Available'", (Object[])new Object[]{FileUtils.parseParentPath(remotePath)});
        String result = shellService.execCommand(cmd);
        this.appendDetail(cmd, result);
        log.info("execute [{}], result = {}.", (Object)cmd, (Object)result);
        long remainSpace = NumberUtils.parseLong((String)FileUtils.readSpecialLineText(result, 2), (long)0L) * 1024L;
        log.info("execute [{}] to remain space is {}, file size is {}.", new Object[]{cmd, remainSpace, fileSize});
        return remainSpace;
    }

    private long getRecoverableSpaceSize(SshShellService shellService, String remotePath) throws SshException {
        String cmd = StringUtils.formatTxt((String)"du -sb %s | awk '{print $1}'", (Object[])new Object[]{remotePath});
        String result = shellService.execCommand(cmd);
        this.appendDetail(cmd, result);
        log.info("execute [{}], result = {}.", (Object)cmd, (Object)result);
        long recoverableSpaceSize = NumberUtils.parseLong((String)FileUtils.readSpecialLineText(result, 2), (long)0L);
        log.info("execute [{}] to recoverable space size is {}.", (Object)cmd, (Object)recoverableSpaceSize);
        return recoverableSpaceSize;
    }

    private void cleanRemoteUploadPath(SshShellService shellService, String dstPath, File uploadFile) throws SshException {
        String dstFile = FilePathValidatorUtils.createLinuxPaths((String)dstPath, (String[])new String[]{uploadFile.getName()});
        String cmd = StringUtils.formatTxt((String)"rm -f %s", (Object[])new Object[]{dstFile});
        String result = shellService.execCommand(cmd);
        this.appendDetail(cmd, result);
        log.info("execute [{}] to delete remote file = {}, result = {}.", new Object[]{cmd, dstFile, result});
        cmd = StringUtils.formatTxt((String)"mkdir -p %s", (Object[])new Object[]{dstPath});
        result = shellService.execCommand(cmd);
        this.appendDetail(cmd, result);
        log.info("execute [{}] to create upload dir, result = {}.", (Object)cmd, (Object)result);
        cmd = StringUtils.formatTxt((String)"chown -hR gandalf %s", (Object[])new Object[]{dstPath});
        result = shellService.execCommand(cmd);
        this.appendDetail(cmd, result);
        log.info("execute [{}] to change owner, result = {}.", (Object)cmd, (Object)result);
    }

    private boolean verifyUploadFileInRemote(SshShellService shellService, UploadPackageBo uploadPackageBo) throws SshException {
        String cmd;
        String scriptPath = FilePathValidatorUtils.createLinuxPaths((String)uploadPackageBo.getInstallPath(), (String[])new String[]{"scripts"});
        log.info("verify file script path={}.", (Object)scriptPath);
        if (uploadPackageBo.getPackageType() == 3) {
            cmd = StringUtils.formatTxt((String)"sh %s/check_iso.sh check", (Object[])new Object[]{scriptPath});
        } else if (uploadPackageBo.getPackageType() == 2) {
            String verifyTempFile = FilePathValidatorUtils.createLinuxPaths((String)uploadPackageBo.getRemotePath(), (String[])new String[]{new File(uploadPackageBo.getPackageFile()).getName()});
            cmd = StringUtils.formatTxt((String)"sh %s/check_template.sh %s", (Object[])new Object[]{scriptPath, verifyTempFile});
        } else {
            if (uploadPackageBo.getPackageType() == 4) {
                return this.unzipKmsLibFiles(shellService, uploadPackageBo);
            }
            log.info("this file not need verify, type={}.", (Object)uploadPackageBo.getPackageType());
            return true;
        }
        log.info("upload file success but wait for verify.");
        ThreadUtils.threadSafeSleep((int)5, (TimeUnit)TimeUnit.SECONDS);
        String result = shellService.execCommandWithTimeout(cmd, 180);
        this.appendDetail(cmd, result);
        log.info("execute [{}] to verify file type={}, result = {}.", new Object[]{cmd, uploadPackageBo.getPackageType(), result});
        return !SshErrParser.isInvalidResult((String)result);
    }

    private boolean unzipKmsLibFiles(SshShellService shellService, UploadPackageBo uploadPackageBo) throws SshException {
        File uploadFile = new File(uploadPackageBo.getPackageFile());
        if (!this.changeDir(shellService, uploadPackageBo.getRemotePath())) {
            log.error("change dir to remote failed.");
            return false;
        }
        if (!this.unzipKmsJarFile(shellService, uploadFile.getName())) {
            log.error("unzip kms jar file failed.");
            return false;
        }
        if (!this.deleteKmsZipFile(shellService, uploadFile.getName())) {
            log.error("delete kms zip file failed.");
            return false;
        }
        return this.changeDir(shellService, "/home/GalaX8800");
    }

    private boolean deleteKmsZipFile(SshShellService shellService, String fileName) throws SshException {
        String cmd = StringUtils.formatTxt((String)"rm -f %s", (Object[])new Object[]{fileName});
        String result = shellService.execCommand(cmd);
        this.appendDetail(cmd, result);
        log.info("execute [{}] to delete zip, result = {}.", (Object)cmd, (Object)result);
        return !SshErrParser.isInvalidResult((String)result);
    }

    private boolean unzipKmsJarFile(SshShellService shellService, String fileName) throws SshException {
        String cmd = StringUtils.formatTxt((String)"unzip -o %s '*.jar'", (Object[])new Object[]{fileName});
        String result = shellService.execCommandWithTimeout(cmd, 180);
        this.appendDetail(cmd, result);
        log.info("execute [{}] to unzip, result = {}.", (Object)cmd, (Object)result);
        return !SshErrParser.isInvalidResult((String)result);
    }

    private boolean changeDir(SshShellService shellService, String remotePath) throws SshException {
        String cmd = StringUtils.formatTxt((String)"cd %s", (Object[])new Object[]{remotePath});
        String result = shellService.execCommand(cmd);
        this.appendDetail(cmd, result);
        log.info("execute [{}] to change dir, result = {}.", (Object)cmd, (Object)result);
        return !SshErrParser.isInvalidResult((String)result);
    }

    @Override
    protected boolean executeSubTask(UploadPackageBo uploadPackageBo) throws BasicException {
        File uploadFile = new File(uploadPackageBo.getPackageFile());
        if (!uploadFile.exists()) {
            log.error("local file not found. fileName={}.", (Object)uploadFile.getName());
            this.setTaskFailed(FcErrorCode.UPLOAD_FILE_NOT_EXIST, Collections.emptyList());
            return false;
        }
        SshShellService shellService = this.findShellService();
        TaskUtils.switchUser2Root(shellService, this.getTaskId());
        this.cleanRemoteUploadPath(shellService, uploadPackageBo.getRemotePath(), uploadFile);
        if (!this.checkRemoteRemainSpace(shellService, uploadPackageBo.getRemotePath(), uploadFile.length())) {
            log.error("space not enough. fileName={}.", (Object)uploadFile.getName());
            this.setTaskFailed(FcErrorCode.REMOTE_SPACE_NOT_ENOUGH, Collections.emptyList());
            return false;
        }
        if (!this.uploadFile2RemoteBySftp(uploadPackageBo, uploadFile)) {
            this.setTaskFailed(FcErrorCode.UPLOAD_FILE_BY_SFTP_FAILED, Collections.singletonList(uploadFile.getName()));
            return false;
        }
        if (!this.verifyUploadFileInRemote(shellService, uploadPackageBo)) {
            log.error("upload vrm template, verify file failed.");
            this.setTaskFailed(FcErrorCode.REMOTE_FILE_VALIDATE_FAILED, Collections.emptyList());
            return false;
        }
        return true;
    }

    private boolean uploadFile2RemoteBySftp(UploadPackageBo uploadPackageBo, File uploadFile) throws BasicException {
        SshSftpService sftpService = this.findSftpService();
        if (!sftpService.upload(uploadPackageBo.getPackageFile(), uploadPackageBo.getRemotePath(), (SftpProgCallback)new UploadFileProgCallBack(uploadFile.getName(), this::appendDetail))) {
            log.error("upload package failed.");
            return false;
        }
        return true;
    }
}

