/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.dto.TaskProgressDto;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.LogicException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.DeployTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.TaskResult;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.TaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.NumberUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.resource.ResourceBundleUtils;
import java.util.List;
import java.util.MissingResourceException;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseTask.class);
    private static final String RESOURCE_TASK_NAME = "TaskName";
    private static final int MAX_DETAIL_TEXT_SIZE = 4000;
    protected final TaskResult taskResult = new TaskResult();
    protected boolean isRetryTask;
    protected boolean isSkipTask;

    public BaseTask(String taskId, String taskNameResKey) {
        this.taskResult.setTaskName(this.getRealTaskName(taskNameResKey)).setDurationTime(this.getDurationTime(taskNameResKey)).setTaskId(taskId).setUuid(UUID.randomUUID().toString()).setTaskStatus(TaskStatus.NOT_START);
    }

    protected final String getRealTaskName(String resKey) {
        try {
            return ResourceBundleUtils.getStringFromResource((String)RESOURCE_TASK_NAME, (String)resKey);
        }
        catch (MissingResourceException e) {
            log.error("not find task name of res key, {}.", (Object)resKey);
            return this.getClass().getName();
        }
    }

    protected final int getDurationTime(String resKey) {
        return NumberUtils.parseInt((String)ResourceBundleUtils.getStringFromResource((String)RESOURCE_TASK_NAME, (String)(resKey + ".duration")), (int)0);
    }

    protected SshShellService findShellService() throws BasicException {
        return DeployTaskManager.getManager().findShellService(this.getTaskId());
    }

    protected SshSftpService findSftpService() throws BasicException {
        return DeployTaskManager.getManager().findSftpService(this.getTaskId());
    }

    protected String getTaskId() {
        return this.taskResult.getTaskId();
    }

    protected String getTaskName() {
        return this.taskResult.getTaskName();
    }

    protected void setTaskSuccess() {
        this.taskResult.setTaskStatus(TaskStatus.END);
    }

    protected void setTaskFailed(ErrorKey errorCode, List<Object> params) {
        this.setTaskFailed(new LogicException(errorCode, params));
    }

    protected void setTaskFailed(TaskResult subTaskResult) {
        this.taskResult.setTaskStatus(subTaskResult.getTaskStatus() == TaskStatus.PAUSE ? TaskStatus.PAUSE : TaskStatus.ERROR);
        this.taskResult.setMessage(subTaskResult.getMessage());
        this.taskResult.setSuggestion(subTaskResult.getSuggestion());
        this.taskResult.appendDetail(subTaskResult.getDetail().toString());
    }

    protected void setTaskFailed(BasicException basicException) {
        this.taskResult.setTaskStatus(TaskStatus.ERROR);
        this.taskResult.setMessage(basicException.getErrorMessage());
        this.taskResult.setSuggestion(basicException.getSuggestMessage());
    }

    protected void appendDetail(String cmd, String text) {
        String realText = text;
        if (text.length() > 4000) {
            realText = text.substring(0, 4000) + "...";
            log.warn("cmd detail has overload max size.");
        }
        this.taskResult.appendDetail(realText);
    }

    public boolean isFailed() {
        return this.taskResult.isFailed();
    }

    public boolean isSuccessfully() {
        return this.taskResult.isSuccessfully();
    }

    public boolean isNotStarted() {
        return this.taskResult.isNotStarted();
    }

    public boolean isRunning() {
        return this.taskResult.isRunning();
    }

    protected void clearFailedStatus() {
        this.taskResult.setTaskStatus(TaskStatus.RUNNING).setTaskFinishTime(0L).setMessage("").setSuggestion("").clearDetail();
    }

    public TaskProgressDto getCurrentTaskProgress() {
        return TaskProgressDto.builder().id(this.taskResult.getUuid()).taskName(this.taskResult.getTaskName()).durationTime(this.taskResult.getDurationTime()).beginTime(this.taskResult.getTaskBeginTime()).finishTime(this.taskResult.getTaskFinishTime()).status(this.taskResult.getTaskStatus().name()).message(this.taskResult.getMessage()).suggestion(this.taskResult.getSuggestion()).detail(this.taskResult.getDetail().toString()).actions(this.taskResult.getActions().stream().map(Enum::name).collect(Collectors.toList())).skipMsg(this.taskResult.getSkipMsg()).childs(this.getChildTaskProgress()).build();
    }

    public abstract List<TaskProgressDto> getChildTaskProgress();

    @Generated
    public TaskResult getTaskResult() {
        return this.taskResult;
    }

    @Generated
    public void setRetryTask(boolean isRetryTask) {
        this.isRetryTask = isRetryTask;
    }

    @Generated
    public void setSkipTask(boolean isSkipTask) {
        this.isSkipTask = isSkipTask;
    }
}

