/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework;

import com.huawei.yinglong.river.sitedeployment.dcs.constant.TaskOperateEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.dto.TaskProgressDto;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.FcErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.TaskResult;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.TaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeploySubTask<T>
extends BaseTask
implements Function<T, TaskResult> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeploySubTask.class);

    public DeploySubTask(String taskId, String taskNameResKey) {
        super(taskId, taskNameResKey);
    }

    @Override
    public TaskResult apply(T t) {
        log.info("prepare to execute subtask, name={}, isRetry={}.", (Object)this.getTaskName(), (Object)this.isRetryTask);
        this.taskResult.setTaskBeginTime(System.currentTimeMillis()).setTaskStatus(TaskStatus.RUNNING);
        try {
            if (this.executeSubTask(t)) {
                this.taskResult.setTaskStatus(TaskStatus.END);
            } else if (this.taskResult.isRunning()) {
                this.setTaskFailed(FcErrorCode.TASK_EXECUTE_DETAIL_FAILED, Collections.singletonList(this.taskResult.getTaskName()));
            }
        }
        catch (BasicException e) {
            log.error("execute subtask failed.", (Throwable)e);
            this.setTaskFailed(e);
        }
        this.setRetryTask(false);
        this.taskResult.setTaskFinishTime(System.currentTimeMillis());
        log.info("finish to execute subtask, result={}, name={}.", (Object)this.taskResult.getTaskStatus(), (Object)this.getTaskName());
        return this.taskResult;
    }

    @Override
    public List<TaskProgressDto> getChildTaskProgress() {
        return Collections.emptyList();
    }

    protected boolean canBeSkipTask() {
        return true;
    }

    protected TaskProgressDto buildTaskProgressByResult(TaskResult taskResult) {
        return TaskProgressDto.builder().id(taskResult.getUuid()).taskName(taskResult.getTaskName()).durationTime(taskResult.getDurationTime()).beginTime(taskResult.getTaskBeginTime()).finishTime(taskResult.getTaskFinishTime()).status(taskResult.getTaskStatus().name()).message(taskResult.getMessage()).suggestion(taskResult.getSuggestion()).detail(taskResult.getDetail().toString()).skipMsg(taskResult.getSkipMsg()).actions(taskResult.getActions().stream().map(Enum::name).collect(Collectors.toList())).build();
    }

    public boolean skipTaskStep(String uuid) {
        if (this.taskResult.isFailed() && Objects.equals(this.taskResult.getUuid(), uuid)) {
            this.taskResult.setTaskStatus(TaskStatus.SKIP).setTaskFinishTime(System.currentTimeMillis());
            return true;
        }
        return false;
    }

    protected void setTaskSkipMsgOnFailed(String skipMsg) {
        this.taskResult.addActions(TaskOperateEnum.SKIP).setSkipMsg(skipMsg);
    }

    protected abstract boolean executeSubTask(T var1) throws BasicException;

    protected boolean switchSftpService(SshShellService shellService, boolean isOpen) throws SshException {
        String cmd = StringUtils.formatTxt((String)"sh /opt/galax/gms/common/util/configSshSftp.sh %s", (Object[])new Object[]{isOpen ? "open" : "close"});
        String result = shellService.execCommand(cmd, (SshEndJudge)new DefaultSshEndJudge());
        this.appendDetail(cmd, result);
        log.info("execute [{}], result = {}.", (Object)cmd, (Object)result);
        return StringUtils.containIgnoreCase((String)result, (String[])new String[]{"sftp service succeed"});
    }
}

