/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework;

import com.huawei.yinglong.river.sitedeployment.dcs.fc.dto.TaskProgressDto;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.FcErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.LogicException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeploySubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.SubTaskWrapper;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.TaskResult;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.TaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeployTask<T>
extends BaseTask
implements Callable<TaskResult> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployTask.class);
    private final List<SubTaskWrapper> subTasks = new LinkedList<SubTaskWrapper>();
    private String taskSkipUid;

    public DeployTask(String taskId, String taskNameResKey) {
        super(taskId, taskNameResKey);
    }

    @Override
    public TaskResult call() {
        log.info("prepare to execute task, name={}, isRetry={}.", (Object)this.getTaskName(), (Object)this.isRetryTask);
        this.taskResult.setTaskBeginTime(System.currentTimeMillis()).setTaskStatus(TaskStatus.RUNNING);
        if (this.executeTask()) {
            log.info("======executeSubTask(FINISH)=======");
            this.setTaskSuccess();
        }
        this.setRetryTask(false);
        this.setSkipTask(false);
        this.taskResult.setTaskFinishTime(System.currentTimeMillis());
        log.info("finish to execute task, result={}, name={}.", (Object)this.taskResult.getTaskStatus(), (Object)this.getTaskName());
        return this.taskResult;
    }

    protected void appendSubTask(DeploySubTask<?> subTask, Supplier<TaskResult> supplier) {
        this.subTasks.add(new SubTaskWrapper(subTask, supplier));
    }

    @Override
    public List<TaskProgressDto> getChildTaskProgress() {
        return this.subTasks.stream().map(SubTaskWrapper::getSubTask).map(BaseTask::getCurrentTaskProgress).collect(Collectors.toList());
    }

    public boolean setTaskInRetryStatus(T deployParams) {
        this.setRetryTask(true);
        this.clearFailedStatus();
        return this.updateDeployParams(deployParams);
    }

    public void setTaskInSkipStatus(String uid) {
        this.setSkipTask(true);
        this.taskSkipUid = uid;
    }

    protected abstract boolean updateDeployParams(T var1);

    public String getRemoteRunningLogs() {
        return "";
    }

    protected boolean executeSubTask(DeploySubTask<?> subTask, Supplier<TaskResult> supplier) {
        TaskResult taskResult = null;
        if (this.isRetryTask) {
            if (this.checkTaskCanBeRetry(subTask)) {
                subTask.clearFailedStatus();
                subTask.setRetryTask(true);
                taskResult = supplier.get();
                log.info("prepare to retry this task, name={}.", (Object)subTask.getTaskName());
            }
        } else if (this.isSkipTask) {
            if (subTask.skipTaskStep(this.taskSkipUid)) {
                this.setSkipTask(false);
                taskResult = subTask.getTaskResult();
                log.info("skip this task, uid={}, name={}.", (Object)this.taskSkipUid, (Object)subTask.getTaskName());
            }
        } else {
            taskResult = supplier.get();
        }
        return Optional.ofNullable(taskResult).filter(subTaskResult -> !subTaskResult.isSuccessfully()).map(this::setTaskRetryFailed).orElse(true);
    }

    private boolean setTaskRetryFailed(TaskResult subTaskResult) {
        this.setTaskFailed(subTaskResult);
        log.error("execute subTask failed, name={}, message={}.", (Object)subTaskResult.getTaskName(), (Object)subTaskResult.getMessage());
        return false;
    }

    private boolean checkTaskCanBeRetry(DeploySubTask<?> subTask) {
        return subTask.isNotStarted() || subTask.isFailed() || subTask.isSuccessfully() && !subTask.canBeSkipTask();
    }

    private boolean executeTask() {
        try {
            for (SubTaskWrapper subTaskWrapper : this.subTasks) {
                String taskClassName = subTaskWrapper.getSubTask().getClass().getSimpleName();
                log.info("=======start executeSubTask({})========", (Object)taskClassName);
                if (this.executeSubTask(subTaskWrapper.getSubTask(), subTaskWrapper.getResultSupplier())) continue;
                log.error("=======executeSubTask({}) failed========", (Object)taskClassName);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.setTaskFailed(new LogicException((ErrorKey)FcErrorCode.TASK_EXECUTE_FAILED, Arrays.asList(this.getTaskName(), e.getMessage())));
            log.error("task {} execute failed.", (Object)this.getTaskName(), (Object)e);
            return false;
        }
    }
}

