/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.cna.CnaInstallNodeBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.cna.DeployFcCnaBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.installer.DeployFcInstallerBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.DeployFcVrmBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.cna.DeployCnaTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.common.CleanDeployEnvTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.TaskBasicInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.installer.DeployInstallerTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.DeployVrmTask;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshManager;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.sshd.client.session.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskContext.class);
    private String taskId;
    private TaskBasicInfo basicInfo;
    private ClientSession osSession;
    private SshShellService shellService;
    private SshSftpService sftpService;
    private DeployInstallerTask deployInstallerTask;
    private DeployFcInstallerBo deployFcInstallerBo;
    private DeployCnaTask deployCnaTask;
    private DeployFcCnaBo deployFcCnaBo;
    private DeployVrmTask deployVrmTask;
    private DeployFcVrmBo deployFcVrmBo;
    private CleanDeployEnvTask cleanDeployEnvTask;
    private String installPath;

    public boolean isDeployInstallerTaskFailed() {
        return this.deployInstallerTask != null && this.deployInstallerTask.isFailed();
    }

    public boolean isDeployCnaTaskFailed() {
        return this.deployCnaTask != null && this.deployCnaTask.isFailed();
    }

    public boolean isDeployVrmTaskFailed() {
        return this.deployVrmTask != null && this.deployVrmTask.isFailed();
    }

    public boolean isCleanDeployEnvTaskFailed() {
        return this.cleanDeployEnvTask != null && this.cleanDeployEnvTask.isFailed();
    }

    public String getConnectionRootPwd() {
        return this.basicInfo != null ? this.basicInfo.getRootPwd() : "";
    }

    public String getManageNodeRootPwd() {
        return this.deployFcCnaBo != null ? this.deployFcCnaBo.getRootPwd() : "";
    }

    public List<CnaInstallNodeBo> getCnaNodes() {
        if (this.deployFcCnaBo == null || this.deployFcCnaBo.getNodes() == null) {
            return Collections.emptyList();
        }
        return new ArrayList<CnaInstallNodeBo>(this.deployFcCnaBo.getNodes());
    }

    public SshShellService findShellService() throws BasicException {
        if (!this.isOsSessionConnected() && this.connectOsSession()) {
            log.info("first find shell service and connect os session.");
        }
        if (this.shellService != null && !this.shellService.isConnected()) {
            this.shellService.connect();
            log.info("first find shell service and create connection.");
        }
        if (this.shellService == null || !this.shellService.isConnected()) {
            throw new SshException((ErrorKey)SshErrorCode.SHELL_CONNECTION_FAILED);
        }
        return this.shellService;
    }

    public SshSftpService findSftpService() throws BasicException {
        if (!this.isOsSessionConnected() && this.connectOsSession()) {
            log.info("first find sftp service and connect os session.");
        }
        if (this.sftpService != null && !this.sftpService.isConnected()) {
            this.sftpService.connect();
            log.info("first find sftp service and create connection.");
        }
        if (this.sftpService == null || !this.sftpService.isConnected()) {
            throw new SshException((ErrorKey)SshErrorCode.SFTP_CONNECTION_FAILED);
        }
        return this.sftpService;
    }

    public void releaseSshConnection() {
        if (this.sftpService != null && this.sftpService.isConnected()) {
            this.sftpService.disconnect();
            log.warn("disconnect sftp successfully.");
        }
        this.sftpService = null;
        if (this.shellService != null && this.shellService.isConnected()) {
            this.shellService.disconnect();
            log.warn("disconnect shell successfully.");
        }
        this.shellService = null;
        try {
            if (this.osSession != null && this.osSession.isOpen()) {
                this.osSession.close();
                log.warn("disconnect session successfully.");
            }
            this.osSession = null;
        }
        catch (IOException e) {
            log.error("osSession close failed.", (Throwable)e);
        }
    }

    private boolean connectOsSession() throws BasicException {
        Optional<ClientSession> opSession = this.createSshSession();
        log.info("create ssh session, taskId={}, session={}.", (Object)this.taskId, opSession);
        if (!opSession.isPresent() || !opSession.get().isOpen()) {
            return false;
        }
        ClientSession session = opSession.get();
        this.setOsSession(session).setShellService(SshManager.createSshShellService((ClientSession)session)).setSftpService(SshManager.createSshSftpService((ClientSession)session));
        return true;
    }

    private Optional<ClientSession> createSshSession() throws SshException {
        if (this.basicInfo == null) {
            log.error("create ssh session failed, basic info is null.");
            return Optional.empty();
        }
        SshConnInfo sshConnInfo = SshConnInfo.builder().hostName(this.basicInfo.getHostIp()).userPwd(this.basicInfo.getUserPwd()).port(this.basicInfo.getHostPort()).userName(this.basicInfo.getUserName()).build();
        log.info("prepare to create ssh session, hostIp={}.", (Object)this.basicInfo.getHostIp());
        return Optional.of(SshManager.getSession((SshConnInfo)sshConnInfo));
    }

    private boolean isOsSessionConnected() {
        return this.osSession != null && this.osSession.isOpen();
    }

    @Generated
    TaskContext(String taskId, TaskBasicInfo basicInfo, ClientSession osSession, SshShellService shellService, SshSftpService sftpService, DeployInstallerTask deployInstallerTask, DeployFcInstallerBo deployFcInstallerBo, DeployCnaTask deployCnaTask, DeployFcCnaBo deployFcCnaBo, DeployVrmTask deployVrmTask, DeployFcVrmBo deployFcVrmBo, CleanDeployEnvTask cleanDeployEnvTask, String installPath) {
        this.taskId = taskId;
        this.basicInfo = basicInfo;
        this.osSession = osSession;
        this.shellService = shellService;
        this.sftpService = sftpService;
        this.deployInstallerTask = deployInstallerTask;
        this.deployFcInstallerBo = deployFcInstallerBo;
        this.deployCnaTask = deployCnaTask;
        this.deployFcCnaBo = deployFcCnaBo;
        this.deployVrmTask = deployVrmTask;
        this.deployFcVrmBo = deployFcVrmBo;
        this.cleanDeployEnvTask = cleanDeployEnvTask;
        this.installPath = installPath;
    }

    @Generated
    public static TaskContextBuilder builder() {
        return new TaskContextBuilder();
    }

    @Generated
    public TaskContext setTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    @Generated
    public TaskContext setBasicInfo(TaskBasicInfo basicInfo) {
        this.basicInfo = basicInfo;
        return this;
    }

    @Generated
    public TaskContext setOsSession(ClientSession osSession) {
        this.osSession = osSession;
        return this;
    }

    @Generated
    public TaskContext setShellService(SshShellService shellService) {
        this.shellService = shellService;
        return this;
    }

    @Generated
    public TaskContext setSftpService(SshSftpService sftpService) {
        this.sftpService = sftpService;
        return this;
    }

    @Generated
    public TaskContext setDeployInstallerTask(DeployInstallerTask deployInstallerTask) {
        this.deployInstallerTask = deployInstallerTask;
        return this;
    }

    @Generated
    public TaskContext setDeployFcInstallerBo(DeployFcInstallerBo deployFcInstallerBo) {
        this.deployFcInstallerBo = deployFcInstallerBo;
        return this;
    }

    @Generated
    public TaskContext setDeployCnaTask(DeployCnaTask deployCnaTask) {
        this.deployCnaTask = deployCnaTask;
        return this;
    }

    @Generated
    public TaskContext setDeployFcCnaBo(DeployFcCnaBo deployFcCnaBo) {
        this.deployFcCnaBo = deployFcCnaBo;
        return this;
    }

    @Generated
    public TaskContext setDeployVrmTask(DeployVrmTask deployVrmTask) {
        this.deployVrmTask = deployVrmTask;
        return this;
    }

    @Generated
    public TaskContext setDeployFcVrmBo(DeployFcVrmBo deployFcVrmBo) {
        this.deployFcVrmBo = deployFcVrmBo;
        return this;
    }

    @Generated
    public TaskContext setCleanDeployEnvTask(CleanDeployEnvTask cleanDeployEnvTask) {
        this.cleanDeployEnvTask = cleanDeployEnvTask;
        return this;
    }

    @Generated
    public TaskContext setInstallPath(String installPath) {
        this.installPath = installPath;
        return this;
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public TaskBasicInfo getBasicInfo() {
        return this.basicInfo;
    }

    @Generated
    public ClientSession getOsSession() {
        return this.osSession;
    }

    @Generated
    public SshShellService getShellService() {
        return this.shellService;
    }

    @Generated
    public SshSftpService getSftpService() {
        return this.sftpService;
    }

    @Generated
    public DeployInstallerTask getDeployInstallerTask() {
        return this.deployInstallerTask;
    }

    @Generated
    public DeployFcInstallerBo getDeployFcInstallerBo() {
        return this.deployFcInstallerBo;
    }

    @Generated
    public DeployCnaTask getDeployCnaTask() {
        return this.deployCnaTask;
    }

    @Generated
    public DeployFcCnaBo getDeployFcCnaBo() {
        return this.deployFcCnaBo;
    }

    @Generated
    public DeployVrmTask getDeployVrmTask() {
        return this.deployVrmTask;
    }

    @Generated
    public DeployFcVrmBo getDeployFcVrmBo() {
        return this.deployFcVrmBo;
    }

    @Generated
    public CleanDeployEnvTask getCleanDeployEnvTask() {
        return this.cleanDeployEnvTask;
    }

    @Generated
    public String getInstallPath() {
        return this.installPath;
    }

    @Generated
    public static class TaskContextBuilder {
        @Generated
        private String taskId;
        @Generated
        private TaskBasicInfo basicInfo;
        @Generated
        private ClientSession osSession;
        @Generated
        private SshShellService shellService;
        @Generated
        private SshSftpService sftpService;
        @Generated
        private DeployInstallerTask deployInstallerTask;
        @Generated
        private DeployFcInstallerBo deployFcInstallerBo;
        @Generated
        private DeployCnaTask deployCnaTask;
        @Generated
        private DeployFcCnaBo deployFcCnaBo;
        @Generated
        private DeployVrmTask deployVrmTask;
        @Generated
        private DeployFcVrmBo deployFcVrmBo;
        @Generated
        private CleanDeployEnvTask cleanDeployEnvTask;
        @Generated
        private String installPath;

        @Generated
        TaskContextBuilder() {
        }

        @Generated
        public TaskContextBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Generated
        public TaskContextBuilder basicInfo(TaskBasicInfo basicInfo) {
            this.basicInfo = basicInfo;
            return this;
        }

        @Generated
        public TaskContextBuilder osSession(ClientSession osSession) {
            this.osSession = osSession;
            return this;
        }

        @Generated
        public TaskContextBuilder shellService(SshShellService shellService) {
            this.shellService = shellService;
            return this;
        }

        @Generated
        public TaskContextBuilder sftpService(SshSftpService sftpService) {
            this.sftpService = sftpService;
            return this;
        }

        @Generated
        public TaskContextBuilder deployInstallerTask(DeployInstallerTask deployInstallerTask) {
            this.deployInstallerTask = deployInstallerTask;
            return this;
        }

        @Generated
        public TaskContextBuilder deployFcInstallerBo(DeployFcInstallerBo deployFcInstallerBo) {
            this.deployFcInstallerBo = deployFcInstallerBo;
            return this;
        }

        @Generated
        public TaskContextBuilder deployCnaTask(DeployCnaTask deployCnaTask) {
            this.deployCnaTask = deployCnaTask;
            return this;
        }

        @Generated
        public TaskContextBuilder deployFcCnaBo(DeployFcCnaBo deployFcCnaBo) {
            this.deployFcCnaBo = deployFcCnaBo;
            return this;
        }

        @Generated
        public TaskContextBuilder deployVrmTask(DeployVrmTask deployVrmTask) {
            this.deployVrmTask = deployVrmTask;
            return this;
        }

        @Generated
        public TaskContextBuilder deployFcVrmBo(DeployFcVrmBo deployFcVrmBo) {
            this.deployFcVrmBo = deployFcVrmBo;
            return this;
        }

        @Generated
        public TaskContextBuilder cleanDeployEnvTask(CleanDeployEnvTask cleanDeployEnvTask) {
            this.cleanDeployEnvTask = cleanDeployEnvTask;
            return this;
        }

        @Generated
        public TaskContextBuilder installPath(String installPath) {
            this.installPath = installPath;
            return this;
        }

        @Generated
        public TaskContext build() {
            return new TaskContext(this.taskId, this.basicInfo, this.osSession, this.shellService, this.sftpService, this.deployInstallerTask, this.deployFcInstallerBo, this.deployCnaTask, this.deployFcCnaBo, this.deployVrmTask, this.deployFcVrmBo, this.cleanDeployEnvTask, this.installPath);
        }

        @Generated
        public String toString() {
            return "TaskContext.TaskContextBuilder(taskId=" + this.taskId + ", basicInfo=" + this.basicInfo + ", osSession=" + this.osSession + ", shellService=" + this.shellService + ", sftpService=" + this.sftpService + ", deployInstallerTask=" + this.deployInstallerTask + ", deployFcInstallerBo=" + this.deployFcInstallerBo + ", deployCnaTask=" + this.deployCnaTask + ", deployFcCnaBo=" + this.deployFcCnaBo + ", deployVrmTask=" + this.deployVrmTask + ", deployFcVrmBo=" + this.deployFcVrmBo + ", cleanDeployEnvTask=" + this.cleanDeployEnvTask + ", installPath=" + this.installPath + ")";
        }
    }
}

