/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework;

import com.huawei.yinglong.river.sitedeployment.dcs.constant.TaskOperateEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.TaskStatus;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

public class TaskResult {
    private String uuid;
    private String taskId;
    private String taskName;
    private TaskStatus taskStatus;
    private int durationTime;
    private long taskBeginTime;
    private long taskFinishTime;
    private String message;
    private String suggestion;
    private String skipMsg;
    private StringBuilder detail = new StringBuilder();
    private Set<TaskOperateEnum> actions = new HashSet<TaskOperateEnum>();

    public boolean isFinished() {
        return this.taskStatus == TaskStatus.END || this.taskStatus == TaskStatus.ERROR || this.taskStatus == TaskStatus.SKIP || this.taskStatus == TaskStatus.PAUSE;
    }

    public boolean isSuccessfully() {
        return this.taskStatus == TaskStatus.END || this.taskStatus == TaskStatus.SKIP;
    }

    public boolean isRunning() {
        return this.taskStatus == TaskStatus.RUNNING;
    }

    public boolean isFailed() {
        return this.taskStatus == TaskStatus.ERROR || this.taskStatus == TaskStatus.PAUSE;
    }

    public boolean isNotStarted() {
        return this.taskStatus == TaskStatus.NOT_START;
    }

    public void appendDetail(String text) {
        this.detail.append(text).append(System.lineSeparator());
    }

    public void clearDetail() {
        this.detail.setLength(0);
    }

    public TaskResult addActions(TaskOperateEnum ... operateEnums) {
        Optional.ofNullable(operateEnums).ifPresent(taskOperateEnums -> this.actions.addAll(Arrays.asList(taskOperateEnums)));
        return this;
    }

    public long getTaskCostTime() {
        return this.taskBeginTime == 0L ? 0L : System.currentTimeMillis() - this.taskBeginTime;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getTaskName() {
        return this.taskName;
    }

    @Generated
    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    @Generated
    public int getDurationTime() {
        return this.durationTime;
    }

    @Generated
    public long getTaskBeginTime() {
        return this.taskBeginTime;
    }

    @Generated
    public long getTaskFinishTime() {
        return this.taskFinishTime;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getSuggestion() {
        return this.suggestion;
    }

    @Generated
    public String getSkipMsg() {
        return this.skipMsg;
    }

    @Generated
    public StringBuilder getDetail() {
        return this.detail;
    }

    @Generated
    public Set<TaskOperateEnum> getActions() {
        return this.actions;
    }

    @Generated
    public TaskResult setUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Generated
    public TaskResult setTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    @Generated
    public TaskResult setTaskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    @Generated
    public TaskResult setTaskStatus(TaskStatus taskStatus) {
        this.taskStatus = taskStatus;
        return this;
    }

    @Generated
    public TaskResult setDurationTime(int durationTime) {
        this.durationTime = durationTime;
        return this;
    }

    @Generated
    public TaskResult setTaskBeginTime(long taskBeginTime) {
        this.taskBeginTime = taskBeginTime;
        return this;
    }

    @Generated
    public TaskResult setTaskFinishTime(long taskFinishTime) {
        this.taskFinishTime = taskFinishTime;
        return this;
    }

    @Generated
    public TaskResult setMessage(String message) {
        this.message = message;
        return this;
    }

    @Generated
    public TaskResult setSuggestion(String suggestion) {
        this.suggestion = suggestion;
        return this;
    }

    @Generated
    public TaskResult setSkipMsg(String skipMsg) {
        this.skipMsg = skipMsg;
        return this;
    }

    @Generated
    public TaskResult setDetail(StringBuilder detail) {
        this.detail = detail;
        return this;
    }

    @Generated
    public TaskResult setActions(Set<TaskOperateEnum> actions) {
        this.actions = actions;
        return this;
    }
}

