/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.installer;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeploySubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanInstallerEnvSubTask
extends DeploySubTask<String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CleanInstallerEnvSubTask.class);
    private static final String TASK_NAME_RES_KEY = "task.name.installer.subtask.clean_installer_env";
    private final DefaultSshEndJudge endJudge = new DefaultSshEndJudge();

    public CleanInstallerEnvSubTask(String taskId) {
        super(taskId, TASK_NAME_RES_KEY);
    }

    @Override
    protected boolean executeSubTask(String installPath) throws BasicException {
        SshShellService shellService = this.findShellService();
        this.uninstallWebInstaller(installPath, shellService);
        this.deleteUploadInstallerFiles(shellService);
        this.switchSftpService(shellService, false);
        return true;
    }

    private void deleteUploadInstallerFiles(SshShellService shellService) throws SshException {
        String cmd = StringUtils.formatTxt((String)"rm -rf %s", (Object[])new Object[]{FilePathValidatorUtils.createLinuxPaths((String)"/home/GalaX8800", (String[])new String[]{"*"})});
        String result = shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
        this.appendDetail(cmd, result);
        log.info("execute [{}] to delete upload file, result = {}.", (Object)cmd, (Object)result);
    }

    private void uninstallWebInstaller(String installPath, SshShellService shellService) throws SshException {
        String cmd = StringUtils.formatTxt((String)"sh %s/bin/webInstaller.sh %s", (Object[])new Object[]{installPath, "uninstall"});
        String result = shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
        this.appendDetail(cmd, result);
        log.info("execute [{}] to uninstall web, result = {}.", (Object)cmd, (Object)result);
    }
}

