/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.installer;

import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.CnaInitBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.DeployPathBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.UploadPackageBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.installer.DeployFcInstallerBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.installer.DeployNofDriverBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.common.CnaInitSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.common.Switch2RootSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.common.UploadPackageSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeployTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.TaskResult;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.installer.InstallFcSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.installer.InstallNofDriverSubTask;
import java.io.File;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployInstallerTask
extends DeployTask<DeployFcInstallerBo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployInstallerTask.class);
    private static final String TASK_NAME_RES_KEY = "task.name.installer.task.deploy_installer";
    private DeployFcInstallerBo deployFcInstallerBo;
    private CnaInitSubTask cnaInitSubTask;
    private Switch2RootSubTask switch2RootSubTask;
    private InstallNofDriverSubTask driverSubTask;
    private UploadPackageSubTask uploadPackageSubTask;
    private InstallFcSubTask installFcSubTask;

    public DeployInstallerTask(String taskId, DeployFcInstallerBo deployFcInstallerBo) {
        super(taskId, TASK_NAME_RES_KEY);
        this.deployFcInstallerBo = deployFcInstallerBo;
        this.initializeSubTasks(taskId);
    }

    private void initializeSubTasks(String taskId) {
        this.cnaInitSubTask = new CnaInitSubTask(taskId);
        this.appendSubTask(this.cnaInitSubTask, this::execInitCnaSubTask);
        this.switch2RootSubTask = new Switch2RootSubTask(this.getTaskId());
        this.appendSubTask(this.switch2RootSubTask, this::execSwitch2RootSubTask);
        this.uploadPackageSubTask = new UploadPackageSubTask(taskId);
        this.appendSubTask(this.uploadPackageSubTask, this::execUploadFcInstallerPackageToRemoteSubTask);
        this.installFcSubTask = new InstallFcSubTask(taskId);
        this.appendSubTask(this.installFcSubTask, this::execInstallFcInstallerSubTask);
        if (Optional.ofNullable(this.deployFcInstallerBo).map(DeployFcInstallerBo::getDriverBo).map(DeployNofDriverBo::isCnaDriver).orElse(false).booleanValue()) {
            this.driverSubTask = new InstallNofDriverSubTask(taskId);
            this.appendSubTask(this.driverSubTask, this::execInstallNofDriverSubTask);
        }
    }

    private TaskResult execInitCnaSubTask() {
        return this.cnaInitSubTask.apply(this.deployFcInstallerBo.getCnaInitBo());
    }

    private TaskResult execSwitch2RootSubTask() {
        CnaInitBo cnaInitBo = this.deployFcInstallerBo.getCnaInitBo();
        return this.switch2RootSubTask.apply(cnaInitBo.getRootPwd());
    }

    private TaskResult execInstallNofDriverSubTask() {
        return this.driverSubTask.apply(this.deployFcInstallerBo.getDriverBo());
    }

    private TaskResult execUploadFcInstallerPackageToRemoteSubTask() {
        DeployPathBo pathBo = this.deployFcInstallerBo.getPathBo();
        return this.uploadPackageSubTask.apply(UploadPackageBo.builder().packageType(1).remotePath(pathBo.getRemotePath()).packageFile(pathBo.getPackageFile()).installPath(pathBo.getInstallPath()).build());
    }

    private TaskResult execInstallFcInstallerSubTask() {
        File packageFile = new File(this.deployFcInstallerBo.getPathBo().getPackageFile());
        return this.installFcSubTask.apply(packageFile.getName());
    }

    @Override
    protected boolean updateDeployParams(DeployFcInstallerBo installerBo) {
        if (installerBo == null) {
            log.error("update deploy vrm failed, vrm is null.");
            return false;
        }
        this.deployFcInstallerBo = installerBo;
        log.info("update deploy fc installer param.");
        return true;
    }
}

