/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.installer;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.FcErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeploySubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.FileUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.Collections;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallFcSubTask
extends DeploySubTask<String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstallFcSubTask.class);
    private static final String TASK_NAME_RES_KEY = "task.name.installer.subtask.install_fc";
    private static final int UNZIP_COMMAND_TIMEOUT = 300;
    private final DefaultSshEndJudge endJudge = new DefaultSshEndJudge();

    public InstallFcSubTask(String taskId) {
        super(taskId, TASK_NAME_RES_KEY);
    }

    @Override
    protected boolean executeSubTask(String packageFileName) throws BasicException {
        SshShellService shellService = this.findShellService();
        this.changeDir2WorkPath(shellService);
        this.unzipInstallerPackageFile(packageFileName, shellService);
        String filePath = FileUtils.removeFileSuffix(packageFileName);
        this.modifyInstallerPackageFileOwner(filePath, shellService);
        return this.installWebInstaller(shellService, filePath);
    }

    private boolean installWebInstaller(SshShellService shellService, String filePath) throws SshException {
        String cmd = StringUtils.formatTxt((String)"sh %s/bin/webInstaller.sh %s", (Object[])new Object[]{filePath, "install"});
        String result = shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
        this.appendDetail(cmd, result);
        log.info("install fc installer, install result = {}.", (Object)result);
        if (!StringUtils.containIgnoreCase((String)result, (String[])new String[]{"successfully"})) {
            this.setTaskFailed(FcErrorCode.COMMAND_EXECUTE_EXCEPTION, Collections.singletonList(cmd));
            return false;
        }
        return true;
    }

    private void modifyInstallerPackageFileOwner(String filePath, SshShellService shellService) throws SshException {
        String cmd = StringUtils.formatTxt((String)"chown -hR gandalf %s", (Object[])new Object[]{filePath});
        String result = shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
        this.appendDetail(cmd, result);
        log.info("install fc installer, modify install path owner result = {}.", (Object)result);
    }

    private void unzipInstallerPackageFile(String packageFileName, SshShellService shellService) throws SshException {
        String cmd = StringUtils.formatTxt((String)"unzip -o %s", (Object[])new Object[]{packageFileName});
        String result = shellService.execCommandWithTimeout(cmd, 300, (SshEndJudge)this.endJudge);
        this.appendDetail(cmd, "........");
        log.info("install fc installer, unzip file = {}, result={}.", (Object)packageFileName, (Object)result);
        if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"[y]es, [n]o, [A]ll, [N]one, [r]ename"})) {
            result = shellService.execCommandWithTimeout("A", 300, (SshEndJudge)this.endJudge);
            log.info("install fc installer, unzip replace all file = {}, result={}.", (Object)packageFileName, (Object)result);
        }
    }

    private void changeDir2WorkPath(SshShellService shellService) throws SshException {
        String cmd = StringUtils.formatTxt((String)"cd %s", (Object[])new Object[]{"/home/GalaX8800"});
        String result = shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
        this.appendDetail(cmd, result);
        log.info("install fc installer, change dir result={}.", (Object)result);
    }
}

