/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.installer;

import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyPattern;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.installer.DeployNofDriverBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.FcErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.LogicException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeploySubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.ConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.FileUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.TaskUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshErrParser;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.UploadFileProgCallBack;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallNofDriverSubTask
extends DeploySubTask<DeployNofDriverBo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstallNofDriverSubTask.class);
    private static final String TASK_NAME_RES_KEY = "task.name.installer.task.nof_driver";
    private static final int DEFAULT_CHECK_REBOOT_SYSTEM_DELTA = (int)TimeUnit.SECONDS.toSeconds(30L);
    private final Set<String> hasInstalledDriverFiles = new HashSet<String>();
    private boolean hasRebootSystem = false;

    public InstallNofDriverSubTask(String taskId) {
        super(taskId, TASK_NAME_RES_KEY);
        this.setTaskSkipMsgOnFailed(FcErrorCode.SKIP_ROCE_DRIVER.getSuggestMessage());
    }

    @Override
    protected boolean executeSubTask(DeployNofDriverBo driverBo) throws BasicException {
        if (!driverBo.isCnaDriver()) {
            log.info("not need to install NOF driver.");
            return true;
        }
        File pathFile = new File(driverBo.getPackagePath());
        List<DriverItem> driverItems = this.findLocalPackageDriverFile(pathFile);
        if (driverItems.isEmpty()) {
            this.setTaskFailed(FcErrorCode.TASK_NOT_FIND_DRIVER_FILE, Collections.emptyList());
            return false;
        }
        SshShellService shellService = this.findShellService();
        if (!this.checkRemoteHostHasNofNic(driverItems, shellService)) {
            log.info("host has not NOF NIC.");
            return true;
        }
        if (!this.makeInstallDriverDirectory(shellService)) {
            this.setTaskFailed(FcErrorCode.TASK_EXECUTE_FAILED, Collections.singletonList("mkdir"));
            return false;
        }
        this.startInstallDriverFiles(pathFile, driverItems, shellService);
        if (!this.hasRebootSystem) {
            this.rebootSystem(shellService);
            shellService = this.waitForSystemReboot();
        }
        this.checkDriverInstallResult(driverItems, shellService);
        return true;
    }

    private boolean makeInstallDriverDirectory(SshShellService shellService) throws SshException {
        return this.makeRemoteDirs(shellService, "/installer/upload/driver") && this.makeRemoteDirs(shellService, "/opt/galax/install/driver/installfiles");
    }

    private void checkDriverInstallResult(List<DriverItem> driverItems, SshShellService shellService) throws BasicException {
        for (DriverItem driverItem : driverItems) {
            this.checkInstallResult(shellService, driverItem.getCheckCmd(), driverItem.getCheckPatterns());
        }
    }

    private void startInstallDriverFiles(File pathFile, List<DriverItem> driverItems, SshShellService shellService) throws BasicException {
        this.copyScriptFile2InstallFiles(shellService);
        for (DriverItem driverItem : driverItems) {
            if (this.hasInstalledDriverFiles.contains(driverItem.getFileName())) {
                log.info("{} has been installed.", (Object)driverItem.getFileName());
                this.appendDetail("[ignore]", driverItem.getFileName() + " has been installed.");
                continue;
            }
            this.uploadDriverFile2Remote(shellService, new File(pathFile, driverItem.getFileName()));
            this.moveDriverFile2DriverFiles(shellService, driverItem.getFileName());
            this.installDriverByCmd(shellService, driverItem.getInstallKey());
            this.hasInstalledDriverFiles.add(driverItem.getFileName());
            this.removeRemoteFile(shellService, driverItem.getFileName());
        }
        this.deleteScriptFile2InstallFiles(shellService);
    }

    private void checkInstallResult(SshShellService shellService, String cmd, List<String> patterns) throws BasicException {
        if (StringUtils.isEmpty((CharSequence)cmd) || CollectionUtils.isEmpty(patterns)) {
            log.info("not need to check install result.");
            return;
        }
        String result = shellService.execCommand(cmd);
        this.appendDetail(cmd, result);
        log.info("execute [{}] to check install result, result = {}.", (Object)cmd, (Object)result);
        try (BufferedReader bufferedReader = new BufferedReader(new StringReader(result));){
            if (bufferedReader.lines().filter(line -> patterns.stream().anyMatch(line::matches)).count() != (long)patterns.size()) {
                throw new LogicException(FcErrorCode.CHECK_DRIVER_INSTALL_RESULT_FAILED);
            }
        }
        catch (IOException e) {
            log.warn("read string line error.", (Throwable)e);
        }
    }

    private SshShellService waitForSystemReboot() throws LogicException {
        int sleepTimes = this.getWaitRebootSystemTime();
        ThreadUtils.threadSafeSleep((int)sleepTimes, (TimeUnit)TimeUnit.SECONDS);
        for (int remainTimes = this.getRemainCheckTime(sleepTimes); remainTimes > 0; remainTimes -= DEFAULT_CHECK_REBOOT_SYSTEM_DELTA) {
            Optional<SshShellService> opShellService = this.tryToReconnectSystemBySsh();
            if (opShellService.isPresent()) {
                this.appendDetail("[connect success]", "connect to system successfully");
                return opShellService.get();
            }
            this.appendDetail("[wait connect]", "wait for next connect system, remain time is " + remainTimes);
            ThreadUtils.threadSafeSleep((int)DEFAULT_CHECK_REBOOT_SYSTEM_DELTA, (TimeUnit)TimeUnit.SECONDS);
        }
        throw new LogicException(FcErrorCode.WAIT_FOR_REBOOT_FAILED);
    }

    private int getRemainCheckTime(int sleepTimes) {
        int remainTimes = Math.max(sleepTimes, ConfigUtils.getPropertiesValue("deployfc.cna.max_wait_timeout_reboot_nof_nic", (int)TimeUnit.MINUTES.toSeconds(8L))) - sleepTimes;
        log.info("start to connect system, remain time is {}.", (Object)remainTimes);
        return remainTimes;
    }

    private int getWaitRebootSystemTime() {
        int waitRebootSystemTime = Math.max((int)TimeUnit.MINUTES.toSeconds(2L), ConfigUtils.getPropertiesValue("deployfc.cna.wait_system_reboot_time", (int)TimeUnit.MINUTES.toSeconds(3L)));
        log.info("start to wait system reboot, wait time is {}.", (Object)waitRebootSystemTime);
        return waitRebootSystemTime;
    }

    private Optional<SshShellService> tryToReconnectSystemBySsh() {
        try {
            SshShellService shellService = this.findShellService();
            if (TaskUtils.switchUser2Root(shellService, this.getTaskId())) {
                this.appendDetail("su root", "switch root user successfully.");
                return Optional.of(shellService);
            }
        }
        catch (BasicException e) {
            log.warn("try to reconnected ssh, but system is not started.", (Throwable)e);
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebootSystem(SshShellService shellService) {
        try {
            String cmd = "reboot";
            String result = shellService.execCommand(cmd);
            this.appendDetail(cmd, result);
            log.info("execute [{}] to reboot, result = {}.", (Object)cmd, (Object)result);
        }
        catch (SshException e) {
            log.warn("reboot system, ssh auto disconnect.", (Throwable)e);
        }
        finally {
            this.hasRebootSystem = true;
        }
    }

    private void deleteScriptFile2InstallFiles(SshShellService shellService) throws SshException {
        String cmd = StringUtils.formatTxt((String)"rm -rf %s", (Object[])new Object[]{"/opt/galax/install/driver/installfiles"});
        String result = shellService.execCommand(cmd);
        this.appendDetail(cmd, result);
        log.info("execute [{}] to delete driver file, result = {}.", (Object)cmd, (Object)result);
    }

    private void removeRemoteFile(SshShellService shellService, String fileName) throws SshException {
        String cmd = StringUtils.formatTxt((String)"mv -f %s/%s %s", (Object[])new Object[]{"/opt/galax/install/driver", fileName, "/installer/upload/driver"});
        String result = shellService.execCommand(cmd);
        this.appendDetail(cmd, result);
        log.info("execute [{}] to move driver file, result = {}.", (Object)cmd, (Object)result);
        cmd = StringUtils.formatTxt((String)"rm -rf %s/%s", (Object[])new Object[]{"/opt/galax/install/driver/installfiles", FileUtils.removeFileSuffix(fileName)});
        result = shellService.execCommand(cmd);
        this.appendDetail(cmd, result);
        log.info("execute [{}] to delete driver path, result = {}.", (Object)cmd, (Object)result);
    }

    private void installDriverByCmd(SshShellService shellService, String installKey) throws BasicException {
        String cmd = StringUtils.formatTxt((String)"cd %s", (Object[])new Object[]{"/opt/galax/install/driver/installfiles"});
        String result = shellService.execCommand(cmd);
        this.appendDetail(cmd, result);
        log.info("execute [{}] to change dir, result = {}.", (Object)cmd, (Object)result);
        cmd = StringUtils.formatTxt((String)"%s/driver_install.sh %s", (Object[])new Object[]{"/opt/galax/install/driver/installfiles", installKey});
        result = shellService.execCommandWithTimeout(cmd, this.getExecuteInstallDriverTimeout());
        this.appendDetail(cmd, result);
        log.info("execute [{}] to install driver, result = {}.", (Object)cmd, (Object)result);
        if (!StringUtils.containIgnoreCase((String)result, (String[])new String[]{"success"})) {
            throw new LogicException((ErrorKey)FcErrorCode.INSTALL_NOF_DRIVER_FAILED, Collections.emptyList());
        }
    }

    private int getExecuteInstallDriverTimeout() {
        int timeout = Math.max((int)TimeUnit.MINUTES.toSeconds(5L), ConfigUtils.getPropertiesValue("deployfc.cna.max_wait_timeout_execute_install_driver", (int)TimeUnit.MINUTES.toSeconds(12L)));
        log.info("execute install driver timeout is {}.", (Object)timeout);
        return timeout;
    }

    private void moveDriverFile2DriverFiles(SshShellService shellService, String fileName) throws BasicException {
        String cmd = StringUtils.formatTxt((String)"mv -f %s/%s %s", (Object[])new Object[]{"/home/GalaX8800", fileName, "/opt/galax/install/driver"});
        String result = shellService.execCommand(cmd);
        this.appendDetail(cmd, result);
        log.info("execute [{}] to move driver file, result = {}.", (Object)cmd, (Object)result);
        if (SshErrParser.isInvalidResult((String)result)) {
            throw new LogicException((ErrorKey)FcErrorCode.COMMAND_EXECUTE_FAILED, Arrays.asList("cp", result));
        }
    }

    private void copyScriptFile2InstallFiles(SshShellService shellService) throws BasicException {
        String cmd = StringUtils.formatTxt((String)"cp -R %s %s", (Object[])new Object[]{"/opt/sia/Thirdparty/*", "/opt/galax/install/driver/installfiles"});
        String result = shellService.execCommand(cmd);
        this.appendDetail(cmd, result);
        log.info("execute [{}] to copy script file, result = {}.", (Object)cmd, (Object)result);
        if (SshErrParser.isInvalidResult((String)result)) {
            throw new LogicException((ErrorKey)FcErrorCode.COMMAND_EXECUTE_FAILED, Arrays.asList("cp -R", result));
        }
    }

    private void uploadDriverFile2Remote(SshShellService shellService, File file) throws BasicException {
        String cmd = StringUtils.formatTxt((String)"rm -f %s", (Object[])new Object[]{FilePathValidatorUtils.createLinuxPaths((String)"/home/GalaX8800", (String[])new String[]{file.getName()})});
        String result = shellService.execCommand(cmd);
        this.appendDetail(cmd, result);
        log.info("execute [{}] to delete driver file, result = {}.", (Object)cmd, (Object)result);
        SshSftpService sftpService = this.findSftpService();
        Optional filePath = FilePathValidatorUtils.getSafePath((File)file);
        if (!filePath.isPresent()) {
            log.error("file get canonical path {} failed.", (Object)file.getName());
            throw new LogicException((ErrorKey)FcErrorCode.TASK_PARAM_INVALID, Collections.singletonList(file.getName()));
        }
        if (!sftpService.upload((String)filePath.get(), "/home/GalaX8800", (SftpProgCallback)new UploadFileProgCallBack(file.getName(), this::appendDetail))) {
            log.error("upload package {} failed.", (Object)file.getName());
            throw new LogicException((ErrorKey)FcErrorCode.UPLOAD_FILE_BY_SFTP_FAILED, Collections.singletonList(file.getName()));
        }
    }

    private boolean makeRemoteDirs(SshShellService shellService, String remotePath) throws SshException {
        String cmd = StringUtils.formatTxt((String)"mkdir -p %s", (Object[])new Object[]{remotePath});
        String result = shellService.execCommand(cmd);
        this.appendDetail(cmd, result);
        log.info("make remote dirs, result={}.", (Object)result);
        return !SshErrParser.isInvalidResult((String)result);
    }

    private boolean checkRemoteHostHasNofNic(List<DriverItem> driverItems, SshShellService shellService) throws SshException {
        Iterator<DriverItem> iterator = driverItems.iterator();
        while (iterator.hasNext()) {
            DriverItem driverItem = iterator.next();
            if (this.checkHasNofNic(shellService, driverItem.getSearchKey())) continue;
            iterator.remove();
        }
        return !driverItems.isEmpty();
    }

    private List<DriverItem> findLocalPackageDriverFile(File pathFile) {
        LinkedList<DriverItem> driverItems = new LinkedList<DriverItem>();
        List fileNames = FileOperateUtils.getSpecialFileNames((File)pathFile, ConsistencyPattern::isMatchEulerMlnxRoCEDriver);
        if (fileNames.size() == 1) {
            driverItems.add(DriverItem.buildMlnx(pathFile, (String)fileNames.get(0)));
        }
        if ((fileNames = FileOperateUtils.getSpecialFileNames((File)pathFile, ConsistencyPattern::isMatchHifc1822RoCEDriver)).size() == 1) {
            driverItems.add(DriverItem.build1822(pathFile, (String)fileNames.get(0)));
        }
        if ((fileNames = FileOperateUtils.getSpecialFileNames((File)pathFile, ConsistencyPattern::isMatchTxgbeRoCEDriver)).size() == 1) {
            driverItems.add(DriverItem.buildTxgbe(pathFile, (String)fileNames.get(0)));
        }
        return driverItems;
    }

    private boolean checkHasNofNic(SshShellService shellService, String key) throws SshException {
        String cmd = StringUtils.formatTxt((String)"sh /opt/sia/Thirdparty/driver_install.sh %s", (Object[])new Object[]{key});
        String result = shellService.execCommand(cmd);
        this.appendDetail(cmd, result);
        log.info("execute [{}] to check has RoCE NIC, result = {}.", (Object)cmd, (Object)result);
        return StringUtils.containIgnoreCase((String)result, (String[])new String[]{"success"});
    }

    private static class DriverItem {
        private String searchKey;
        private String installKey;
        private String checkCmd;
        private List<String> checkPatterns;
        private String fileName;
        private File pathFile;

        static DriverItem buildMlnx(File pathFile, String fileName) {
            return DriverItem.builder().pathFile(pathFile).fileName(fileName).searchKey("search_cx5").installKey("install_mlnx").checkCmd("lsmod | grep --color=never -E 'nvme_rdma|mlx5_ib'").checkPatterns(Arrays.asList("mlx5_ib\\s+\\d+\\s+0", "nvme_rdma\\s+\\d+\\s+0")).build();
        }

        static DriverItem build1822(File pathFile, String fileName) {
            return DriverItem.builder().pathFile(pathFile).fileName(fileName).searchKey("search_1822").installKey("install_hifc").build();
        }

        static DriverItem buildTxgbe(File pathFile, String fileName) {
            return DriverItem.builder().pathFile(pathFile).fileName(fileName).searchKey("search_2001_1001").installKey("install_txgbe").build();
        }

        @Generated
        DriverItem(String searchKey, String installKey, String checkCmd, List<String> checkPatterns, String fileName, File pathFile) {
            this.searchKey = searchKey;
            this.installKey = installKey;
            this.checkCmd = checkCmd;
            this.checkPatterns = checkPatterns;
            this.fileName = fileName;
            this.pathFile = pathFile;
        }

        @Generated
        public static DriverItemBuilder builder() {
            return new DriverItemBuilder();
        }

        @Generated
        public String getSearchKey() {
            return this.searchKey;
        }

        @Generated
        public String getInstallKey() {
            return this.installKey;
        }

        @Generated
        public String getCheckCmd() {
            return this.checkCmd;
        }

        @Generated
        public List<String> getCheckPatterns() {
            return this.checkPatterns;
        }

        @Generated
        public String getFileName() {
            return this.fileName;
        }

        @Generated
        public File getPathFile() {
            return this.pathFile;
        }

        @Generated
        public static class DriverItemBuilder {
            @Generated
            private String searchKey;
            @Generated
            private String installKey;
            @Generated
            private String checkCmd;
            @Generated
            private List<String> checkPatterns;
            @Generated
            private String fileName;
            @Generated
            private File pathFile;

            @Generated
            DriverItemBuilder() {
            }

            @Generated
            public DriverItemBuilder searchKey(String searchKey) {
                this.searchKey = searchKey;
                return this;
            }

            @Generated
            public DriverItemBuilder installKey(String installKey) {
                this.installKey = installKey;
                return this;
            }

            @Generated
            public DriverItemBuilder checkCmd(String checkCmd) {
                this.checkCmd = checkCmd;
                return this;
            }

            @Generated
            public DriverItemBuilder checkPatterns(List<String> checkPatterns) {
                this.checkPatterns = checkPatterns;
                return this;
            }

            @Generated
            public DriverItemBuilder fileName(String fileName) {
                this.fileName = fileName;
                return this;
            }

            @Generated
            public DriverItemBuilder pathFile(File pathFile) {
                this.pathFile = pathFile;
                return this;
            }

            @Generated
            public DriverItem build() {
                return new DriverItem(this.searchKey, this.installKey, this.checkCmd, this.checkPatterns, this.fileName, this.pathFile);
            }

            @Generated
            public String toString() {
                return "InstallNofDriverSubTask.DriverItem.DriverItemBuilder(searchKey=" + this.searchKey + ", installKey=" + this.installKey + ", checkCmd=" + this.checkCmd + ", checkPatterns=" + this.checkPatterns + ", fileName=" + this.fileName + ", pathFile=" + this.pathFile + ")";
            }
        }
    }
}

