/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.cna.CnaInstallNodeBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.DeployFcVrmBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.VrmInstallCnaBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.VrmInstallVrmBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.FcErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.DeployTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeploySubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.VrmRequestClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.host.HostCreate;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.common.ApiException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.RequestUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.http.fc.FcRequestClient;
import com.huawei.yinglong.river.sitedeployment.dcs.http.fc.entry.VerifySwitch;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddNode2ClusterSubTask
extends DeploySubTask<DeployFcVrmBo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AddNode2ClusterSubTask.class);
    private static final String TASK_NAME_RES_KEY = "task.name.vrm.subtask.add_node_to_manager_cluster";
    private String manageRootPwd;

    public AddNode2ClusterSubTask(String taskId) {
        super(taskId, TASK_NAME_RES_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean executeSubTask(DeployFcVrmBo fcVrmBo) throws BasicException {
        VrmInstallCnaBo cnaBo = fcVrmBo.getCna();
        this.manageRootPwd = DeployTaskManager.getManager().findCnaManageRootPwd(this.getTaskId());
        if (cnaBo == null || fcVrmBo.getVrm() == null || StringUtils.isEmpty((CharSequence)this.manageRootPwd)) {
            log.error("not find cna or vrm or manage root pwd.");
            this.setTaskFailed(FcErrorCode.TASK_PARAM_INVALID, Collections.singletonList("cna, vrm, root pwd"));
            return false;
        }
        VrmInstallVrmBo vrmBo = fcVrmBo.getVrm();
        boolean isDoubleMode = Objects.equals("double", vrmBo.getMode());
        LinkedList<CnaInstallNodeBo> masterSlaveNodes = new LinkedList<CnaInstallNodeBo>();
        LinkedList<CnaInstallNodeBo> otherManageNodes = new LinkedList<CnaInstallNodeBo>();
        List<CnaInstallNodeBo> cnaNodeBos = DeployTaskManager.getManager().findCnaNodes(this.getTaskId());
        this.classifyCnaManageNode(masterSlaveNodes, otherManageNodes, cnaBo, isDoubleMode, cnaNodeBos);
        this.appendDetail("[query manage node]", StringUtils.formatTxt((String)"find %d-%d manage nodes need to add cluster.", (Object[])new Object[]{masterSlaveNodes.size(), otherManageNodes.size()}));
        log.info("find {}-{} manage node to add cluster.", (Object)masterSlaveNodes.size(), (Object)otherManageNodes.size());
        FcRequestClient requestClient = RequestUtils.createFcRequestClient(vrmBo);
        Optional optionalVerifySwitch = requestClient.queryAccountIsolationSwitch();
        try {
            LinkedList<String> hostNames;
            VrmRequestClient vrmRequestClient;
            if (optionalVerifySwitch.isPresent() && ((VerifySwitch)optionalVerifySwitch.get()).isVerifySwitch()) {
                log.info("set verify switch false.");
                requestClient.setAccountIsolationSwitch(false);
            }
            if (!this.handleCnaNodesToManageCluster(masterSlaveNodes, otherManageNodes, vrmRequestClient = RequestUtils.createVrmRequestClient(vrmBo), hostNames = new LinkedList<String>())) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.handleCnaNodesToComputeCluster(cnaNodeBos, vrmRequestClient);
            return bl;
        }
        finally {
            if (optionalVerifySwitch.isPresent() && ((VerifySwitch)optionalVerifySwitch.get()).isVerifySwitch()) {
                log.info("set verify switch true.");
                requestClient.setAccountIsolationSwitch(true);
            }
        }
    }

    private boolean handleCnaNodesToManageCluster(List<CnaInstallNodeBo> masterSlaveNodes, List<CnaInstallNodeBo> otherManageNodes, VrmRequestClient vrmRequestClient, List<String> hostNames) {
        if (!this.addHost2ManageCluster(otherManageNodes, hostNames, vrmRequestClient)) {
            log.error("add host to manage cluster failed.");
            return false;
        }
        log.info("add host to manage cluster, hostNames={}.", hostNames);
        hostNames.addAll(masterSlaveNodes.stream().map(CnaInstallNodeBo::getHostName).collect(Collectors.toList()));
        log.info("prepare to add host uplink and dats store, hostNames={}.", hostNames);
        if (!this.addHostUplinkAndDataStore(vrmRequestClient, hostNames)) {
            log.error("add uplink and datastore to manage cluster failed.");
            return false;
        }
        return true;
    }

    private boolean handleCnaNodesToComputeCluster(List<CnaInstallNodeBo> cnaNodeBos, VrmRequestClient vrmRequestClient) {
        List<CnaInstallNodeBo> computeNodeBos = cnaNodeBos.stream().filter(nodeBo -> !nodeBo.isManageNode()).filter(nodeBo -> StringUtils.isNotEmpty((CharSequence)nodeBo.getClusterName())).collect(Collectors.toList());
        log.info("add compute node to cluster, size = {}.", (Object)computeNodeBos.size());
        if (CollectionUtils.isEmpty(computeNodeBos)) {
            return true;
        }
        return this.addHostToComputeCluster(computeNodeBos, vrmRequestClient);
    }

    private boolean addHostToComputeCluster(List<CnaInstallNodeBo> nodeBos, VrmRequestClient vrmRequestClient) {
        ArrayListMultimap clusterNodeMaps = ArrayListMultimap.create();
        nodeBos.forEach(arg_0 -> AddNode2ClusterSubTask.lambda$addHostToComputeCluster$2((Multimap)clusterNodeMaps, arg_0));
        for (String clusterName : clusterNodeMaps.keySet()) {
            if (this.createCnaNodeCluster(vrmRequestClient, clusterName)) continue;
            log.error("create compute cluster failed.");
            return false;
        }
        for (CnaInstallNodeBo nodeBo : clusterNodeMaps.values()) {
            if (this.addCnaNodeToCluster(vrmRequestClient, nodeBo)) continue;
            log.error("add host to compute cluster failed.");
            return false;
        }
        return true;
    }

    private boolean createCnaNodeCluster(VrmRequestClient vrmRequestClient, String clusterName) {
        try {
            vrmRequestClient.createCluster(clusterName);
            this.appendDetail("[create cluster]", StringUtils.formatTxt((String)"create cluster [%s] successfully.", (Object[])new Object[]{clusterName}));
            log.info("create cluster [{}]  successfully", (Object)clusterName);
            return true;
        }
        catch (ApiException e) {
            log.error("create cluster {} failed.", (Object)clusterName, (Object)e);
            this.appendDetail("[create cluster]", StringUtils.formatTxt((String)"create cluster [%s] failed.", (Object[])new Object[]{clusterName}));
            this.setTaskFailed(FcErrorCode.COMMAND_EXECUTE_FAILED, Arrays.asList("create cluster", e.getMessage()));
            return false;
        }
    }

    private boolean addCnaNodeToCluster(VrmRequestClient vrmRequestClient, CnaInstallNodeBo nodeBo) {
        try {
            vrmRequestClient.createHostToCluster(this.buildHostCreateParam(nodeBo), nodeBo.getClusterName());
            this.appendDetail("[add host]", StringUtils.formatTxt((String)"add host [%s] to %s successfully.", (Object[])new Object[]{nodeBo.getHostName(), nodeBo.getClusterName()}));
            log.info("add host [{}/{}] to {} successfully.", new Object[]{nodeBo.getHostName(), nodeBo.getHostIp(), nodeBo.getClusterName()});
            return true;
        }
        catch (ApiException e) {
            log.error("add compute host {} to cluster failed.", (Object)nodeBo.getHostIp(), (Object)e);
            this.appendDetail("[add host]", StringUtils.formatTxt((String)"add host [%s] failed.", (Object[])new Object[]{nodeBo.getHostName()}));
            this.setTaskFailed(FcErrorCode.COMMAND_EXECUTE_FAILED, Arrays.asList("add host", e.getMessage()));
            return false;
        }
    }

    private void classifyCnaManageNode(List<CnaInstallNodeBo> masterSlaveNodes, List<CnaInstallNodeBo> otherManageNodes, VrmInstallCnaBo cnaBo, boolean isDoubleMode, List<CnaInstallNodeBo> cnaNodeBos) {
        List nodeBos = cnaNodeBos.stream().filter(CnaInstallNodeBo::isManageNode).collect(Collectors.toList());
        for (CnaInstallNodeBo nodeBo : nodeBos) {
            if (Objects.equals(nodeBo.getHostIp(), cnaBo.getMasterIp())) {
                masterSlaveNodes.add(nodeBo);
                continue;
            }
            if (isDoubleMode && Objects.equals(nodeBo.getHostIp(), cnaBo.getSlaveIp())) {
                masterSlaveNodes.add(nodeBo);
                continue;
            }
            otherManageNodes.add(nodeBo);
        }
    }

    private boolean addHost2ManageCluster(List<CnaInstallNodeBo> nodeBos, List<String> hostNames, VrmRequestClient vrmRequestClient) {
        for (CnaInstallNodeBo nodeBo : nodeBos) {
            try {
                vrmRequestClient.createHostToManageCluster(this.buildHostCreateParam(nodeBo));
                hostNames.add(nodeBo.getHostName());
                this.appendDetail("[add host]", StringUtils.formatTxt((String)"add host [%s] successfully.", (Object[])new Object[]{nodeBo.getHostName()}));
                log.info("add host [{}/{}] successfully.", (Object)nodeBo.getHostName(), (Object)nodeBo.getHostIp());
            }
            catch (ApiException e) {
                log.error("add manage host {} to cluster failed.", (Object)nodeBo.getHostIp(), (Object)e);
                this.appendDetail("[add host]", StringUtils.formatTxt((String)"add host [%s] failed.", (Object[])new Object[]{nodeBo.getHostName()}));
                this.setTaskFailed(FcErrorCode.COMMAND_EXECUTE_FAILED, Arrays.asList("add host", e.getMessage()));
                return false;
            }
        }
        return true;
    }

    private boolean addHostUplinkAndDataStore(VrmRequestClient vrmRequestClient, List<String> hostNames) {
        try {
            vrmRequestClient.createUplinkPorts(hostNames);
            this.appendDetail("[create uplink]", StringUtils.formatTxt((String)"create uplink [%s] successfully.", (Object[])new Object[]{String.join((CharSequence)",", hostNames)}));
            log.info("create uplink [{}] successfully.", hostNames);
        }
        catch (ApiException e) {
            log.error("create uplink[{}] failed.", hostNames, (Object)e);
            this.appendDetail("[create uplink]", StringUtils.formatTxt((String)"create uplink [%s] failed.", (Object[])new Object[]{String.join((CharSequence)",", hostNames)}));
            this.setTaskFailed(FcErrorCode.COMMAND_EXECUTE_FAILED, Arrays.asList("create uplink", e.getMessage()));
            return false;
        }
        try {
            vrmRequestClient.attachDataStore(hostNames);
            this.appendDetail("[attach datastore]", StringUtils.formatTxt((String)"attach datastore [%s] successfully.", (Object[])new Object[]{String.join((CharSequence)",", hostNames)}));
            log.info("attach datastore [{}] successfully.", hostNames);
        }
        catch (ApiException e) {
            log.error("attach datastore[{}] failed.", hostNames, (Object)e);
            this.appendDetail("[attach datastore]", StringUtils.formatTxt((String)"attach datastore [%s] failed.", (Object[])new Object[]{String.join((CharSequence)",", hostNames)}));
            this.setTaskFailed(FcErrorCode.COMMAND_EXECUTE_FAILED, Arrays.asList("attach datastore", e.getMessage()));
            return false;
        }
        return true;
    }

    private HostCreate buildHostCreateParam(CnaInstallNodeBo nodeBo) {
        HostCreate hostCreate = new HostCreate();
        hostCreate.setIp(nodeBo.getHostIp());
        hostCreate.setName(nodeBo.getHostName());
        hostCreate.setRootPassword(this.manageRootPwd);
        hostCreate.setIsConfDefNtpTimeZone(1);
        return hostCreate;
    }

    private static /* synthetic */ void lambda$addHostToComputeCluster$2(Multimap clusterNodeMaps, CnaInstallNodeBo nodeBo) {
        clusterNodeMaps.put((Object)nodeBo.getClusterName(), (Object)nodeBo);
    }
}

