/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.VrmInstallVrmBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.FcErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeploySubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.ConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.RequestUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.http.fc.FcRequestClient;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckVrmServiceStateSubTask
extends DeploySubTask<VrmInstallVrmBo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckVrmServiceStateSubTask.class);
    private static final String TASK_NAME_RES_KEY = "task.name.vrm.subtask.check_vrm_service_state";
    private static final String KEY_CHECK_VRM_MAX_COUNT = "deployfc.vrm.max_check_vrm_count";

    public CheckVrmServiceStateSubTask(String taskId) {
        super(taskId, TASK_NAME_RES_KEY);
        this.setTaskSkipMsgOnFailed(FcErrorCode.SKIP_CHECK_VRM_SERVICE_STATE.getSuggestMessage());
    }

    @Override
    protected boolean executeSubTask(VrmInstallVrmBo vrmBo) throws BasicException {
        int checkCount = Math.max(1, ConfigUtils.getPropertiesValue(KEY_CHECK_VRM_MAX_COUNT, 20));
        log.info("prepare to check vrm [{}] for fusion compute service started.", (Object)checkCount);
        this.appendDetail("", "start to check FusionCompute Portal Service.");
        FcRequestClient requestClient = RequestUtils.createFcRequestClient(vrmBo);
        do {
            ThreadUtils.threadSafeSleep((int)30, (TimeUnit)TimeUnit.SECONDS);
            log.info("start to login FusionCompute, current check value = {}", (Object)checkCount);
            this.appendDetail("", "try to login FusionCompute.");
            if (!requestClient.login()) continue;
            return true;
        } while (--checkCount > 0);
        log.error("timeout to login to FusionCompute Portal failed.");
        this.setTaskFailed(FcErrorCode.TASK_CHECK_VRM_SERVICE_FAILED, Collections.emptyList());
        return false;
    }
}

