/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeploySubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.CommandUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanDeployVrmEnvSubTask
extends DeploySubTask<String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CleanDeployVrmEnvSubTask.class);
    private static final String TASK_NAME_RES_KEY = "task.name.vrm.subtask.clean_deploy_vrm_env";
    private final DefaultSshEndJudge endJudge = new DefaultSshEndJudge();

    public CleanDeployVrmEnvSubTask(String taskId) {
        super(taskId, TASK_NAME_RES_KEY);
    }

    @Override
    protected boolean executeSubTask(String installPath) throws BasicException {
        SshShellService shellService = this.findShellService();
        this.stopVrmService(shellService);
        this.clearVrmService(shellService);
        this.deleteUploadVrmFiles(shellService);
        return true;
    }

    private void deleteUploadVrmFiles(SshShellService shellService) throws SshException {
        this.deleteUploadFile(shellService, "/installer/upload/vrm");
        this.deleteUploadFile(shellService, "/installer/upload/kms");
        this.deleteUploadFile(shellService, "/installer/upload/vmtools");
    }

    private void deleteUploadFile(SshShellService shellService, String remotePath) throws SshException {
        String cmd = StringUtils.formatTxt((String)"rm -rf %s", (Object[])new Object[]{remotePath});
        String result = shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
        this.appendDetail(cmd, result);
        log.info("execute [{}], result = {}.", (Object)cmd, (Object)result);
    }

    private void clearVrmService(SshShellService shellService) throws SshException {
        String cmd = CommandUtils.getLanguageCommand("vrmInstaller clear");
        String result = shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
        this.appendDetail(cmd, result);
        log.info("execute [{}], result = {}.", (Object)cmd, (Object)result);
    }

    private void stopVrmService(SshShellService shellService) throws SshException {
        String cmd = CommandUtils.getLanguageCommand("vrmInstaller stop");
        String result = shellService.execCommand(cmd, (SshEndJudge)this.endJudge);
        this.appendDetail(cmd, result);
        log.info("execute [{}], result = {}.", (Object)cmd, (Object)result);
    }
}

