/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.cna.CnaInstallNodeBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.DeployFcVrmBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.VrmInstallBackupBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.VrmInstallVrmBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.FcErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.DeployTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.constant.BackupDataType;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.constant.BackupFtpProtocol;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeploySubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.VrmRequestClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.backup.MgntDataBackupInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.common.ApiException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.RequestUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.TaskUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshErrParser;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshManager;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.sshd.client.session.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMgntDataBackupSubTask
extends DeploySubTask<DeployFcVrmBo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigMgntDataBackupSubTask.class);
    private static final String TASK_NAME_RES_KEY = "task.name.vrm.subtask.config_mgnt_data_backup";

    public ConfigMgntDataBackupSubTask(String taskId) {
        super(taskId, TASK_NAME_RES_KEY);
        this.setTaskSkipMsgOnFailed(FcErrorCode.SKIP_CONFIG_MGNT_DATA_BACKUP.getSuggestMessage());
    }

    @Override
    protected boolean executeSubTask(DeployFcVrmBo vrmBo) throws BasicException {
        VrmRequestClient vrmRequestClient = RequestUtils.createVrmRequestClient(vrmBo.getVrm());
        VrmInstallBackupBo backupBo = vrmBo.getBackup();
        if (!backupBo.isConfigBackup()) {
            log.info("not need to config backup.");
            return true;
        }
        try {
            log.info("config management data backup, type={}.", (Object)backupBo.getBackupType());
            MgntDataBackupInfo backupInfo = BackupDataType.of(backupBo.getBackupType()) == BackupDataType.THIRD ? this.buildFtpBackupInfo(backupBo) : this.buildHostBackupInfo(backupBo.getBackupCnaNames());
            vrmRequestClient.configMgntDataBackup(backupInfo);
            log.info("config management data backup successfully.");
            this.appendDetail("[config backup]", "config management data backup successfully.");
            this.uploadFtpsCertFile(vrmBo.getVrm(), backupBo);
            return true;
        }
        catch (ApiException e) {
            log.error("config management data backup failed.", (Throwable)e);
            this.appendDetail("[config backup]", "config management data backup failed.");
            this.setTaskFailed(FcErrorCode.COMMAND_EXECUTE_FAILED, Arrays.asList("add host", e.getMessage()));
            return false;
        }
    }

    private boolean checkCertFileValid(String certFile) {
        if (StringUtils.isEmpty((CharSequence)certFile)) {
            log.warn("ftps cert file is empty.");
            return false;
        }
        return FilePathValidatorUtils.getSafePath((String)certFile).map(File::new).filter(File::isFile).filter(File::exists).isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFtpsCertFile(VrmInstallVrmBo vrmBo, VrmInstallBackupBo backupBo) throws BasicException {
        SshSftpService sftpService;
        SshShellService shellService;
        ClientSession session;
        block6: {
            if (BackupDataType.of(backupBo.getBackupType()) != BackupDataType.THIRD) {
                log.info("backup type not need to upload cert file, type={}.", (Object)backupBo.getBackupType());
                return;
            }
            if (BackupFtpProtocol.of(backupBo.getFtpProtocol()) != BackupFtpProtocol.FTPS) {
                log.info("ftp protocol not need to upload cert file, protocol={}.", (Object)backupBo.getFtpProtocol());
                return;
            }
            if (!this.checkCertFileValid(backupBo.getFtpCertPath())) {
                log.warn("ftps protocol not find cert file.");
                return;
            }
            session = null;
            shellService = null;
            sftpService = null;
            try {
                session = this.buildSession(vrmBo);
                shellService = this.buildShellService(session);
                log.info("start to open sftp service.");
                this.switchSftpService(shellService, true);
                File certFile = new File(backupBo.getFtpCertPath());
                log.info("start to upload cert file to remote, fileName={}.", (Object)certFile.getName());
                this.appendDetail("[upload ftps cert]", "start to upload ftps cert file.");
                sftpService = this.uploadBySftpService(session, certFile);
                log.info("start to move and chmod cert file.");
                this.appendDetail("[upload ftps cert]", "start to move and chmod ftps cert file.");
                if (this.moveCertFileToDest(shellService, certFile)) break block6;
            }
            catch (Throwable throwable) {
                SshManager.releaseConnService(sftpService);
                SshManager.releaseConnService(shellService);
                SshManager.releaseSession((ClientSession)session);
                throw throwable;
            }
            SshManager.releaseConnService((SshConnService)sftpService);
            SshManager.releaseConnService((SshConnService)shellService);
            SshManager.releaseSession((ClientSession)session);
            return;
        }
        log.info("start to close sftp service.");
        this.switchSftpService(shellService, false);
        log.info("upload cert file successfully.");
        this.appendDetail("[upload ftps cert]", "upload ftps cert file successfully.");
        SshManager.releaseConnService((SshConnService)sftpService);
        SshManager.releaseConnService((SshConnService)shellService);
        SshManager.releaseSession((ClientSession)session);
    }

    private boolean moveCertFileToDest(SshShellService shellService, File certFile) throws SshException {
        String cmd = StringUtils.formatTxt((String)"mv -f %s/%s %s", (Object[])new Object[]{"/home/GalaX8800", certFile.getName(), "/etc/galax/ge_backup/ftps_root_cert.crt"});
        String result = shellService.execCommand(cmd);
        log.info("execute [{}], result={}.", (Object)cmd, (Object)result);
        if (!SshErrParser.isInvalidResult((String)result)) {
            this.setTaskFailed(FcErrorCode.COMMAND_EXECUTE_FAILED, Arrays.asList(cmd, result));
            log.error("move cert file failed.");
            return false;
        }
        cmd = StringUtils.formatTxt((String)"chmod 600 %s", (Object[])new Object[]{"/etc/galax/ge_backup/ftps_root_cert.crt"});
        result = shellService.execCommand(cmd);
        log.info("execute [{}], result={}.", (Object)cmd, (Object)result);
        if (!SshErrParser.isInvalidResult((String)result)) {
            this.setTaskFailed(FcErrorCode.COMMAND_EXECUTE_FAILED, Arrays.asList(cmd, result));
            log.error("chmod cert file failed.");
            return false;
        }
        return true;
    }

    private SshSftpService uploadBySftpService(ClientSession session, File certFile) throws SshException {
        String certPath = FilePathValidatorUtils.getSafePath((File)certFile).orElse("");
        SshSftpService sftpService = SshManager.createSshSftpService((ClientSession)session);
        sftpService.connect();
        sftpService.upload(certPath, "/home/GalaX8800", (SftpProgCallback)new DefaultSftpProgCallback(certFile.getName()));
        return sftpService;
    }

    private SshShellService buildShellService(ClientSession session) throws BasicException {
        SshShellService shellService = SshManager.createSshShellService((ClientSession)session);
        shellService.connect();
        TaskUtils.switchUser2Root(shellService, this.getTaskId());
        return shellService;
    }

    private ClientSession buildSession(VrmInstallVrmBo vrmBo) throws SshException {
        boolean isDoubleMode = Objects.equals("double", vrmBo.getMode());
        String hostIp = isDoubleMode ? vrmBo.getFloatIp() : vrmBo.getMasterIp();
        log.info("start to build session, hostIp={}.", (Object)hostIp);
        return SshManager.getSession((SshConnInfo)SshConnInfo.builder().hostName(hostIp).userName("gandalf").userPwd(vrmBo.getGandalfPwd()).build());
    }

    private MgntDataBackupInfo buildFtpBackupInfo(VrmInstallBackupBo backupBo) {
        log.info("build ftp backup config, protocol={},ip={}.", (Object)backupBo.getFtpProtocol(), (Object)backupBo.getFtpIpAddr());
        return new MgntDataBackupInfo().setIsUploadtoFtp(true).setFtptype(BackupFtpProtocol.of(backupBo.getFtpProtocol()) == BackupFtpProtocol.FTPS ? 2 : 1).setFtpIP(backupBo.getFtpIpAddr()).setFtpuserName(backupBo.getFtpUsername()).setFtpPwd(backupBo.getFtpPassword()).setFtpport(String.valueOf(backupBo.getFtpPort())).setBackupPath(backupBo.getFtpBackupPath());
    }

    private MgntDataBackupInfo buildHostBackupInfo(List<String> hostNameList) {
        String hostIps = DeployTaskManager.getManager().findCnaNodes(this.getTaskId()).stream().filter(cna -> hostNameList.contains(cna.getHostName())).map(CnaInstallNodeBo::getHostIp).collect(Collectors.joining(","));
        log.info("build host backup config, hostNames={},hostIps={}.", hostNameList, (Object)hostIps);
        return new MgntDataBackupInfo().setIsUploadtoFtp(true).setFtptype(3).setFtpIP(hostIps).setFtpuserName("gandalf").setFtpPwd("").setFtpport("2121").setBackupPath("/opt/backupdb");
    }
}

